﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/managedblockchain/ManagedBlockchain_EXPORTS.h>
#include <aws/managedblockchain/model/LogConfigurations.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace ManagedBlockchain
{
namespace Model
{

  /**
   * <p>Configuration properties for logging events associated with a peer node owned
   * by a member in a Managed Blockchain network.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/NodeFabricLogPublishingConfiguration">AWS
   * API Reference</a></p>
   */
  class AWS_MANAGEDBLOCKCHAIN_API NodeFabricLogPublishingConfiguration
  {
  public:
    NodeFabricLogPublishingConfiguration();
    NodeFabricLogPublishingConfiguration(Aws::Utils::Json::JsonView jsonValue);
    NodeFabricLogPublishingConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Configuration properties for logging events associated with chaincode
     * execution on a peer node. Chaincode logs contain the results of instantiating,
     * invoking, and querying the chaincode. A peer can run multiple instances of
     * chaincode. When enabled, a log stream is created for all chaincodes, with an
     * individual log stream for each chaincode.</p>
     */
    inline const LogConfigurations& GetChaincodeLogs() const{ return m_chaincodeLogs; }

    /**
     * <p>Configuration properties for logging events associated with chaincode
     * execution on a peer node. Chaincode logs contain the results of instantiating,
     * invoking, and querying the chaincode. A peer can run multiple instances of
     * chaincode. When enabled, a log stream is created for all chaincodes, with an
     * individual log stream for each chaincode.</p>
     */
    inline bool ChaincodeLogsHasBeenSet() const { return m_chaincodeLogsHasBeenSet; }

    /**
     * <p>Configuration properties for logging events associated with chaincode
     * execution on a peer node. Chaincode logs contain the results of instantiating,
     * invoking, and querying the chaincode. A peer can run multiple instances of
     * chaincode. When enabled, a log stream is created for all chaincodes, with an
     * individual log stream for each chaincode.</p>
     */
    inline void SetChaincodeLogs(const LogConfigurations& value) { m_chaincodeLogsHasBeenSet = true; m_chaincodeLogs = value; }

    /**
     * <p>Configuration properties for logging events associated with chaincode
     * execution on a peer node. Chaincode logs contain the results of instantiating,
     * invoking, and querying the chaincode. A peer can run multiple instances of
     * chaincode. When enabled, a log stream is created for all chaincodes, with an
     * individual log stream for each chaincode.</p>
     */
    inline void SetChaincodeLogs(LogConfigurations&& value) { m_chaincodeLogsHasBeenSet = true; m_chaincodeLogs = std::move(value); }

    /**
     * <p>Configuration properties for logging events associated with chaincode
     * execution on a peer node. Chaincode logs contain the results of instantiating,
     * invoking, and querying the chaincode. A peer can run multiple instances of
     * chaincode. When enabled, a log stream is created for all chaincodes, with an
     * individual log stream for each chaincode.</p>
     */
    inline NodeFabricLogPublishingConfiguration& WithChaincodeLogs(const LogConfigurations& value) { SetChaincodeLogs(value); return *this;}

    /**
     * <p>Configuration properties for logging events associated with chaincode
     * execution on a peer node. Chaincode logs contain the results of instantiating,
     * invoking, and querying the chaincode. A peer can run multiple instances of
     * chaincode. When enabled, a log stream is created for all chaincodes, with an
     * individual log stream for each chaincode.</p>
     */
    inline NodeFabricLogPublishingConfiguration& WithChaincodeLogs(LogConfigurations&& value) { SetChaincodeLogs(std::move(value)); return *this;}


    /**
     * <p>Configuration properties for a peer node log. Peer node logs contain messages
     * generated when your client submits transaction proposals to peer nodes, requests
     * to join channels, enrolls an admin peer, and lists the chaincode instances on a
     * peer node. </p>
     */
    inline const LogConfigurations& GetPeerLogs() const{ return m_peerLogs; }

    /**
     * <p>Configuration properties for a peer node log. Peer node logs contain messages
     * generated when your client submits transaction proposals to peer nodes, requests
     * to join channels, enrolls an admin peer, and lists the chaincode instances on a
     * peer node. </p>
     */
    inline bool PeerLogsHasBeenSet() const { return m_peerLogsHasBeenSet; }

    /**
     * <p>Configuration properties for a peer node log. Peer node logs contain messages
     * generated when your client submits transaction proposals to peer nodes, requests
     * to join channels, enrolls an admin peer, and lists the chaincode instances on a
     * peer node. </p>
     */
    inline void SetPeerLogs(const LogConfigurations& value) { m_peerLogsHasBeenSet = true; m_peerLogs = value; }

    /**
     * <p>Configuration properties for a peer node log. Peer node logs contain messages
     * generated when your client submits transaction proposals to peer nodes, requests
     * to join channels, enrolls an admin peer, and lists the chaincode instances on a
     * peer node. </p>
     */
    inline void SetPeerLogs(LogConfigurations&& value) { m_peerLogsHasBeenSet = true; m_peerLogs = std::move(value); }

    /**
     * <p>Configuration properties for a peer node log. Peer node logs contain messages
     * generated when your client submits transaction proposals to peer nodes, requests
     * to join channels, enrolls an admin peer, and lists the chaincode instances on a
     * peer node. </p>
     */
    inline NodeFabricLogPublishingConfiguration& WithPeerLogs(const LogConfigurations& value) { SetPeerLogs(value); return *this;}

    /**
     * <p>Configuration properties for a peer node log. Peer node logs contain messages
     * generated when your client submits transaction proposals to peer nodes, requests
     * to join channels, enrolls an admin peer, and lists the chaincode instances on a
     * peer node. </p>
     */
    inline NodeFabricLogPublishingConfiguration& WithPeerLogs(LogConfigurations&& value) { SetPeerLogs(std::move(value)); return *this;}

  private:

    LogConfigurations m_chaincodeLogs;
    bool m_chaincodeLogsHasBeenSet;

    LogConfigurations m_peerLogs;
    bool m_peerLogsHasBeenSet;
  };

} // namespace Model
} // namespace ManagedBlockchain
} // namespace Aws
