/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.tables.columns;

import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.desktop.datalab.tables.columns.ElementDataColumn;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;

public class AttributeDataColumn<T extends Element>
implements ElementDataColumn<T> {
    private final AttributeColumnsController attributeColumnsController;
    private final Column column;
    private final Class<?> columnClassForTable;

    public AttributeDataColumn(AttributeColumnsController attributeColumnsController, Column column) {
        this.attributeColumnsController = attributeColumnsController;
        this.column = column;
        this.columnClassForTable = column.getTypeClass();
    }

    @Override
    public Class<?> getColumnClass() {
        return this.columnClassForTable;
    }

    @Override
    public String getColumnName() {
        return this.column.getTitle();
    }

    @Override
    public Object getValueFor(T element) {
        return element.getAttribute(this.column);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.column != null ? this.column.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeDataColumn other = (AttributeDataColumn)obj;
        return this.column == other.column || this.column != null && this.column.equals(other.column);
    }

    @Override
    public void setValueFor(T element, Object value) {
        this.attributeColumnsController.setAttributeValue(value, element, this.column);
    }

    @Override
    public boolean isEditable() {
        return this.attributeColumnsController.canChangeColumnData(this.column);
    }

    @Override
    public Column getColumn() {
        return this.column;
    }
}

