/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.modules.autoupdate.services.UpdateItemDeploymentImpl;
import org.netbeans.modules.autoupdate.services.UpdateLicenseImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.DummyModuleInfo;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;

public class ModuleItem
extends UpdateItemImpl {
    private String codeName;
    private String specificationVersion;
    private ModuleInfo info;
    private String author;
    private String downloadSize;
    private String homepage;
    private String category;
    private Date publishDate;
    private boolean isEager;
    private boolean isAutoload;
    private boolean isPreferedUpdate;
    private String moduleNotification = null;
    private URL distribution;
    private Manifest manifest;
    private UpdateItemDeploymentImpl deployImpl;
    private UpdateLicenseImpl licenseImpl;

    protected ModuleItem() {
    }

    public ModuleItem(String string, String string2, URL uRL, String string3, String string4, String string5, String string6, String string7, Manifest manifest, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, String string8, UpdateLicenseImpl updateLicenseImpl) {
        this.codeName = string;
        this.specificationVersion = string2;
        this.distribution = uRL;
        this.manifest = manifest;
        this.deployImpl = new UpdateItemDeploymentImpl(bl3, bl4, string8, null, null);
        if (string4 != null && string4.length() > 0) {
            try {
                this.publishDate = Utilities.parseDate(string4);
            }
            catch (ParseException parseException) {
                Logger.getLogger(ModuleItem.class.getName()).log(Level.INFO, "Parsing \"" + string4 + "\" of " + string + " throws " + parseException.getMessage(), parseException);
            }
            catch (RuntimeException runtimeException) {
                Logger.getLogger(ModuleItem.class.getName()).log(Level.INFO, "Parsing \"" + string4 + "\" of " + string + " throws " + runtimeException.getMessage(), runtimeException);
            }
        }
        this.licenseImpl = updateLicenseImpl;
        this.author = string3;
        this.downloadSize = string5;
        this.homepage = string6;
        this.category = string7;
        this.isEager = bl;
        this.isAutoload = bl2;
        this.isPreferedUpdate = bl5;
    }

    @Override
    public String getCodeName() {
        return this.codeName;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public URL getDistribution() {
        return this.distribution;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public int getDownloadSize() {
        int n = 0;
        if (this.downloadSize == null || this.downloadSize.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(this.downloadSize);
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(ModuleItem.class.getName()).log(Level.WARNING, "Module {0} has invalid value of downloadSize: {1}", new Object[]{this.codeName, this.downloadSize});
        }
        return n;
    }

    public UpdateItemDeploymentImpl getUpdateItemDeploymentImpl() {
        return this.deployImpl;
    }

    @Override
    public UpdateLicenseImpl getUpdateLicenseImpl() {
        return this.licenseImpl;
    }

    public ModuleInfo getModuleInfo() {
        if (this.info == null) {
            Module module = Utilities.toModule(this.codeName, this.specificationVersion == null ? null : new SpecificationVersion(this.specificationVersion));
            this.info = module != null ? module : new DummyModuleInfo(this.manifest.getMainAttributes());
        }
        return this.info;
    }

    public String getAgreement() {
        return this.getUpdateLicenseImpl().getAgreement();
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public String getDate() {
        return this.publishDate == null ? null : Utilities.formatDate(this.publishDate);
    }

    public boolean isAutoload() {
        return this.isAutoload;
    }

    public boolean isEager() {
        return this.isEager;
    }

    public boolean isPreferredUpdate() {
        return this.isPreferedUpdate;
    }

    public String getModuleNotification() {
        return this.moduleNotification;
    }

    void setModuleNotification(String string) {
        this.moduleNotification = string;
    }

    @Override
    public void setUpdateLicenseImpl(UpdateLicenseImpl updateLicenseImpl) {
        this.licenseImpl = updateLicenseImpl;
    }

    @Override
    public void setNeedsRestart(Boolean bl) {
        this.deployImpl.setNeedsRestart(bl);
    }
}

