/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class AuthList {
    private final LinkedList<AuthTimeWithHash> entries;
    private final int lifespan;
    private volatile int oldestTime = Integer.MIN_VALUE;

    public AuthList(int lifespan) {
        this.lifespan = lifespan;
        this.entries = new LinkedList();
    }

    public synchronized void put(AuthTimeWithHash t, KerberosTime currentTime) throws KrbApErrException {
        if (this.entries.isEmpty()) {
            this.entries.addFirst(t);
            this.oldestTime = t.ctime;
            return;
        }
        AuthTimeWithHash temp = this.entries.getFirst();
        int cmp = temp.compareTo(t);
        if (cmp < 0) {
            this.entries.addFirst(t);
        } else {
            if (cmp == 0) {
                throw new KrbApErrException(34);
            }
            ListIterator<AuthTimeWithHash> it = this.entries.listIterator(1);
            boolean found = false;
            while (it.hasNext()) {
                temp = it.next();
                cmp = temp.compareTo(t);
                if (cmp < 0) {
                    this.entries.add(this.entries.indexOf(temp), t);
                    found = true;
                    break;
                }
                if (cmp != 0) continue;
                throw new KrbApErrException(34);
            }
            if (!found) {
                this.entries.addLast(t);
            }
        }
        long timeLimit = currentTime.getSeconds() - this.lifespan;
        if ((long)this.oldestTime > timeLimit - 5L) {
            return;
        }
        while (!this.entries.isEmpty()) {
            AuthTimeWithHash removed = this.entries.removeLast();
            if ((long)removed.ctime < timeLimit) continue;
            this.entries.addLast(removed);
            this.oldestTime = removed.ctime;
            return;
        }
        this.oldestTime = Integer.MIN_VALUE;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<AuthTimeWithHash> iter = this.entries.descendingIterator();
        int pos = this.entries.size();
        while (iter.hasNext()) {
            AuthTimeWithHash at = iter.next();
            sb.append('#').append(pos--).append(": ").append(at.toString()).append('\n');
        }
        return sb.toString();
    }
}

