﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace IoT
{
namespace Model
{
  class AWS_IOT_API DescribeProvisioningTemplateVersionResult
  {
  public:
    DescribeProvisioningTemplateVersionResult();
    DescribeProvisioningTemplateVersionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    DescribeProvisioningTemplateVersionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The fleet provisioning template version ID.</p>
     */
    inline int GetVersionId() const{ return m_versionId; }

    /**
     * <p>The fleet provisioning template version ID.</p>
     */
    inline void SetVersionId(int value) { m_versionId = value; }

    /**
     * <p>The fleet provisioning template version ID.</p>
     */
    inline DescribeProvisioningTemplateVersionResult& WithVersionId(int value) { SetVersionId(value); return *this;}


    /**
     * <p>The date when the fleet provisioning template version was created.</p>
     */
    inline const Aws::Utils::DateTime& GetCreationDate() const{ return m_creationDate; }

    /**
     * <p>The date when the fleet provisioning template version was created.</p>
     */
    inline void SetCreationDate(const Aws::Utils::DateTime& value) { m_creationDate = value; }

    /**
     * <p>The date when the fleet provisioning template version was created.</p>
     */
    inline void SetCreationDate(Aws::Utils::DateTime&& value) { m_creationDate = std::move(value); }

    /**
     * <p>The date when the fleet provisioning template version was created.</p>
     */
    inline DescribeProvisioningTemplateVersionResult& WithCreationDate(const Aws::Utils::DateTime& value) { SetCreationDate(value); return *this;}

    /**
     * <p>The date when the fleet provisioning template version was created.</p>
     */
    inline DescribeProvisioningTemplateVersionResult& WithCreationDate(Aws::Utils::DateTime&& value) { SetCreationDate(std::move(value)); return *this;}


    /**
     * <p>The JSON formatted contents of the fleet provisioning template version.</p>
     */
    inline const Aws::String& GetTemplateBody() const{ return m_templateBody; }

    /**
     * <p>The JSON formatted contents of the fleet provisioning template version.</p>
     */
    inline void SetTemplateBody(const Aws::String& value) { m_templateBody = value; }

    /**
     * <p>The JSON formatted contents of the fleet provisioning template version.</p>
     */
    inline void SetTemplateBody(Aws::String&& value) { m_templateBody = std::move(value); }

    /**
     * <p>The JSON formatted contents of the fleet provisioning template version.</p>
     */
    inline void SetTemplateBody(const char* value) { m_templateBody.assign(value); }

    /**
     * <p>The JSON formatted contents of the fleet provisioning template version.</p>
     */
    inline DescribeProvisioningTemplateVersionResult& WithTemplateBody(const Aws::String& value) { SetTemplateBody(value); return *this;}

    /**
     * <p>The JSON formatted contents of the fleet provisioning template version.</p>
     */
    inline DescribeProvisioningTemplateVersionResult& WithTemplateBody(Aws::String&& value) { SetTemplateBody(std::move(value)); return *this;}

    /**
     * <p>The JSON formatted contents of the fleet provisioning template version.</p>
     */
    inline DescribeProvisioningTemplateVersionResult& WithTemplateBody(const char* value) { SetTemplateBody(value); return *this;}


    /**
     * <p>True if the fleet provisioning template version is the default version.</p>
     */
    inline bool GetIsDefaultVersion() const{ return m_isDefaultVersion; }

    /**
     * <p>True if the fleet provisioning template version is the default version.</p>
     */
    inline void SetIsDefaultVersion(bool value) { m_isDefaultVersion = value; }

    /**
     * <p>True if the fleet provisioning template version is the default version.</p>
     */
    inline DescribeProvisioningTemplateVersionResult& WithIsDefaultVersion(bool value) { SetIsDefaultVersion(value); return *this;}

  private:

    int m_versionId;

    Aws::Utils::DateTime m_creationDate;

    Aws::String m_templateBody;

    bool m_isDefaultVersion;
  };

} // namespace Model
} // namespace IoT
} // namespace Aws
