/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import net.java.dev.colorchooser.NamedColor;
import net.java.dev.colorchooser.Palette;
import net.java.dev.colorchooser.PredefinedPalette;

class RecentColors
extends Palette {
    private Palette palette;
    private boolean changed = true;
    Stack stack = new Stack();
    public static final String INNER_DELIMITER = "^$";
    public static final String OUTER_DELIMITER = "!*";
    static Map namedMap = null;
    private static RecentColors defaultInstance = null;

    private RecentColors() {
    }

    private Palette getWrapped() {
        if (this.changed || this.palette == null) {
            this.palette = this.createPalette();
            this.changed = false;
        }
        return this.palette;
    }

    public Color getColorAt(int x, int y) {
        return this.getWrapped().getColorAt(x, y);
    }

    public String getDisplayName() {
        try {
            return ResourceBundle.getBundle("org.netbeans.swing.colorchooser.Bundle").getString("recent");
        }
        catch (MissingResourceException mre) {
            return "Recent colors";
        }
    }

    public Dimension getSize() {
        Dimension result = ((PredefinedPalette)this.getWrapped()).calcSize();
        return result;
    }

    public void paintTo(Graphics g) {
        this.getWrapped().paintTo(g);
    }

    public String getNameAt(int x, int y) {
        return this.getWrapped().getNameAt(x, y);
    }

    void add(Color c) {
        if (c instanceof RecentColor) {
            return;
        }
        if (this.stack.indexOf(c) == -1) {
            String name = c instanceof PredefinedPalette.BasicNamedColor ? ((PredefinedPalette.BasicNamedColor)c).getDisplayName() : null;
            String toString = c instanceof PredefinedPalette.BasicNamedColor ? ((PredefinedPalette.BasicNamedColor)c).toString() : null;
            RecentColor col = new RecentColor(name, c.getRed(), c.getGreen(), c.getBlue(), toString);
            this.stack.push(col);
            this.changed = true;
            this.palette = null;
            if (c instanceof NamedColor) {
                RecentColors.addToNameCache((NamedColor)c);
            }
            this.saveToPrefs();
        }
    }

    public void saveToPrefs() {
        Preferences prefs = this.getPreferences();
        if (prefs == null) {
            return;
        }
        int count = 0;
        StringBuffer sb = new StringBuffer();
        Stack stack = new Stack();
        stack.addAll(this.stack);
        while (!stack.isEmpty() && count < 64) {
            ++count;
            Color c = (Color)stack.pop();
            if (c instanceof DummyColor) break;
            String name = "null";
            if (c instanceof PredefinedPalette.BasicNamedColor) {
                PredefinedPalette.BasicNamedColor nc = (PredefinedPalette.BasicNamedColor)c;
                name = nc.getDisplayName();
            }
            if (name == "null") {
                name = null;
            }
            sb.append(name);
            sb.append(INNER_DELIMITER);
            sb.append(c.getRed());
            sb.append(INNER_DELIMITER);
            sb.append(c.getGreen());
            sb.append(INNER_DELIMITER);
            sb.append(c.getBlue());
            sb.append(INNER_DELIMITER);
            if (c instanceof PredefinedPalette.BasicNamedColor) {
                sb.append(c.toString());
            } else {
                sb.append('x');
            }
            sb.append(OUTER_DELIMITER);
        }
        prefs.put("recentColors", sb.toString());
    }

    static NamedColor findNamedColor(Color color) {
        if (namedMap == null) {
            return null;
        }
        NamedColor result = (NamedColor)namedMap.get(new Integer(color.getRGB()));
        return result;
    }

    static void addToNameCache(NamedColor color) {
        if (namedMap == null) {
            namedMap = new HashMap(40);
        }
        namedMap.put(new Integer(color.getRGB()), color);
    }

    private Preferences getPreferences() {
        try {
            Preferences base = Preferences.userNodeForPackage(this.getClass());
            return base.node("1.5");
        }
        catch (AccessControlException ace) {
            return null;
        }
    }

    public void loadFromPrefs() {
        Preferences prefs = this.getPreferences();
        if (prefs == null) {
            return;
        }
        String s = prefs.get("recentColors", null);
        this.stack = new Stack();
        Object[] col = new Color[64];
        Arrays.fill(col, new DummyColor());
        try {
            if (s != null) {
                StringTokenizer tok = new StringTokenizer(s, OUTER_DELIMITER);
                for (int count = 63; tok.hasMoreTokens() && count >= 0; --count) {
                    String curr = tok.nextToken();
                    StringTokenizer tk2 = new StringTokenizer(curr, INNER_DELIMITER);
                    while (tk2.hasMoreTokens()) {
                        String name = tk2.nextToken();
                        if ("null".equals(name)) {
                            name = null;
                        }
                        int r = Integer.parseInt(tk2.nextToken());
                        int g = Integer.parseInt(tk2.nextToken());
                        int b = Integer.parseInt(tk2.nextToken());
                        String toString = tk2.nextToken();
                        col[count] = "x".equals(toString) ? new RecentColor(name, r, g, b) : new RecentColor(name, r, g, b, toString);
                        RecentColors.addToNameCache((NamedColor)col[count]);
                    }
                }
            }
            this.stack.addAll(Arrays.asList(col));
        }
        catch (Exception e) {
            System.err.println("Error loading color preferences");
            e.printStackTrace();
        }
    }

    private Palette createPalette() {
        NamedColor[] nc = this.stack.toArray(new PredefinedPalette.BasicNamedColor[0]);
        return new PredefinedPalette("", nc);
    }

    public static final RecentColors getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new RecentColors();
            defaultInstance.loadFromPrefs();
        }
        return defaultInstance;
    }

    private class DummyColor
    extends RecentColor {
        public DummyColor() {
            super(null, 0, 0, 0);
        }

        public String getDisplayName() {
            return null;
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    private class RecentColor
    extends PredefinedPalette.BasicNamedColor {
        String displayName;
        String toString;

        public RecentColor(String name, int r, int g, int b) {
            super(name, r, g, b);
            this.toString = null;
            this.displayName = name;
        }

        public RecentColor(String name, int r, int g, int b, String toString) {
            this(name, r, g, b);
            this.displayName = name;
            this.toString = toString;
        }

        public int compareTo(Object o) {
            return RecentColors.this.stack.indexOf(o) - RecentColors.this.stack.indexOf(this);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object o) {
            if (o instanceof Color) {
                Color c = (Color)o;
                return c.getRGB() == this.getRGB();
            }
            return false;
        }

        public int hashCode() {
            return this.getRGB();
        }

        public String toString() {
            if (this.toString != null) {
                return this.toString;
            }
            return "new java.awt.Color(" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + ")";
        }
    }
}

