/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultIncludeRule;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.IncludeRule;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.WorkspaceModuleDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ArtifactId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.IvyNode;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.ExactPatternMatcher;

public class IvyNodeUsage {
    private IvyNode node;
    private Map<String, Set<String>> rootModuleConfs = new HashMap<String, Set<String>>();
    private Map<NodeConf, Set<String>> requiredConfs = new HashMap<NodeConf, Set<String>>();
    private Map<String, Set<Depender>> dependers = new HashMap<String, Set<Depender>>();
    private Map<String, IvyNodeBlacklist> blacklisted = new HashMap<String, IvyNodeBlacklist>();

    public IvyNodeUsage(IvyNode node) {
        this.node = node;
    }

    protected Collection<String> getRequiredConfigurations(IvyNode in, String inConf) {
        return this.requiredConfs.get(new NodeConf(in, inConf));
    }

    protected void setRequiredConfs(IvyNode parent, String parentConf, Collection<String> confs) {
        this.requiredConfs.put(new NodeConf(parent, parentConf), new HashSet<String>(confs));
    }

    protected Set<String> getConfigurations(String rootModuleConf) {
        return this.rootModuleConfs.get(rootModuleConf);
    }

    protected Set<String> addAndGetConfigurations(String rootModuleConf) {
        Set<String> depConfs = this.rootModuleConfs.get(rootModuleConf);
        if (depConfs == null) {
            depConfs = new HashSet<String>();
            this.rootModuleConfs.put(rootModuleConf, depConfs);
        }
        return depConfs;
    }

    protected Set<String> getRootModuleConfigurations() {
        return this.rootModuleConfs.keySet();
    }

    public void updateDataFrom(Collection<IvyNodeUsage> usages, String rootModuleConf) {
        for (IvyNodeUsage usage : usages) {
            this.updateDataFrom(usage, rootModuleConf);
        }
    }

    private void updateDataFrom(IvyNodeUsage usage, String rootModuleConf) {
        this.updateMapOfSet(usage.requiredConfs, this.requiredConfs);
        this.updateMapOfSetForKey(usage.rootModuleConfs, this.rootModuleConfs, rootModuleConf);
        this.updateMapOfSetForKey(usage.dependers, this.dependers, rootModuleConf);
    }

    private <K, V> void updateMapOfSet(Map<K, Set<V>> from, Map<K, Set<V>> to) {
        for (K key : from.keySet()) {
            this.updateMapOfSetForKey(from, to, key);
        }
    }

    private <K, V> void updateMapOfSetForKey(Map<K, Set<V>> from, Map<K, Set<V>> to, K key) {
        Set<V> set = from.get(key);
        if (set != null) {
            Set<V> toupdate = to.get(key);
            if (toupdate != null) {
                toupdate.addAll(set);
            } else {
                to.put(key, new HashSet<V>(set));
            }
        }
    }

    private <K, V> void addObjectsForConf(K rootModuleConf, V objectToAdd, Map<K, Set<V>> map2) {
        Set<V> set = map2.get(rootModuleConf);
        if (set == null) {
            set = new HashSet<V>();
            map2.put(rootModuleConf, set);
        }
        set.add(objectToAdd);
    }

    public void addUsage(String rootModuleConf, DependencyDescriptor dd, String parentConf) {
        this.addObjectsForConf(rootModuleConf, new Depender(dd, parentConf), this.dependers);
    }

    protected Set<DependencyArtifactDescriptor> getDependencyArtifactsSet(String rootModuleConf) {
        if (this.node.getDescriptor() instanceof WorkspaceModuleDescriptor) {
            return null;
        }
        Collection dependersInConf = this.dependers.get(rootModuleConf);
        if (dependersInConf == null) {
            return null;
        }
        HashSet<DependencyArtifactDescriptor> dependencyArtifacts = new HashSet<DependencyArtifactDescriptor>();
        for (Depender depender : dependersInConf) {
            DependencyArtifactDescriptor[] dads = depender.dd.getDependencyArtifacts(depender.dependerConf);
            dependencyArtifacts.addAll(Arrays.asList(dads));
        }
        return dependencyArtifacts;
    }

    protected Set<IncludeRule> getDependencyIncludesSet(String rootModuleConf) {
        Collection dependersInConf = this.dependers.get(rootModuleConf);
        if (dependersInConf == null) {
            return null;
        }
        HashSet<IncludeRule> dependencyIncludes = new HashSet<IncludeRule>();
        boolean atLeastOneDependerNeedsAllArtifacts = false;
        boolean atLeastOneDependerHasSpecificArtifactSelection = false;
        for (Depender depender : dependersInConf) {
            boolean hasIncludeRule;
            DependencyArtifactDescriptor[] dads = depender.dd.getDependencyArtifacts(depender.dd.getModuleConfigurations());
            boolean declaresArtifacts = dads != null && dads.length > 0;
            IncludeRule[] rules = depender.dd.getIncludeRules(depender.dependerConf);
            boolean bl = hasIncludeRule = rules != null && rules.length > 0;
            if (hasIncludeRule) {
                dependencyIncludes.addAll(Arrays.asList(rules));
            }
            if (declaresArtifacts || hasIncludeRule) {
                atLeastOneDependerHasSpecificArtifactSelection = true;
            }
            if (hasIncludeRule || declaresArtifacts) continue;
            atLeastOneDependerNeedsAllArtifacts = true;
        }
        if (atLeastOneDependerHasSpecificArtifactSelection && atLeastOneDependerNeedsAllArtifacts) {
            dependencyIncludes.add(IvyNodeUsage.includeAllArtifacts());
        }
        return dependencyIncludes;
    }

    protected void removeRootModuleConf(String rootModuleConf) {
        this.rootModuleConfs.remove(rootModuleConf);
    }

    protected void blacklist(IvyNodeBlacklist bdata) {
        this.blacklisted.put(bdata.getRootModuleConf(), bdata);
    }

    protected boolean isBlacklisted(String rootModuleConf) {
        return this.blacklisted.containsKey(rootModuleConf);
    }

    protected IvyNodeBlacklist getBlacklistData(String rootModuleConf) {
        return this.blacklisted.get(rootModuleConf);
    }

    protected IvyNode getNode() {
        return this.node;
    }

    public boolean hasTransitiveDepender(String rootModuleConf) {
        Set<Depender> dependersSet = this.dependers.get(rootModuleConf);
        if (dependersSet == null) {
            return false;
        }
        for (Depender depender : dependersSet) {
            if (!depender.dd.isTransitive()) continue;
            return true;
        }
        return false;
    }

    private static IncludeRule includeAllArtifacts() {
        ArtifactId aid = new ArtifactId(new ModuleId("*", "*"), "*", "*", "*");
        return new DefaultIncludeRule(aid, ExactPatternMatcher.INSTANCE, null);
    }

    private static final class Depender {
        private DependencyDescriptor dd;
        private String dependerConf;

        public Depender(DependencyDescriptor dd, String dependerConf) {
            this.dd = dd;
            this.dependerConf = dependerConf;
        }

        public String toString() {
            return this.dd + " [" + this.dependerConf + "]";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Depender)) {
                return false;
            }
            Depender other = (Depender)obj;
            return other.dd == this.dd && other.dependerConf.equals(this.dependerConf);
        }

        public int hashCode() {
            int hash = 33;
            hash += this.dd.hashCode() * 13;
            return hash += this.dependerConf.hashCode() * 13;
        }
    }

    private static final class NodeConf {
        private IvyNode node;
        private String conf;

        public NodeConf(IvyNode node, String conf) {
            if (node == null) {
                throw new NullPointerException("node must not null");
            }
            if (conf == null) {
                throw new NullPointerException("conf must not null");
            }
            this.node = node;
            this.conf = conf;
        }

        public final String getConf() {
            return this.conf;
        }

        public final IvyNode getNode() {
            return this.node;
        }

        public boolean equals(Object obj) {
            return obj instanceof NodeConf && this.getNode().equals(((NodeConf)obj).getNode()) && this.getConf().equals(((NodeConf)obj).getConf());
        }

        public int hashCode() {
            int hash = 33;
            hash += this.getNode().hashCode() * 17;
            return hash += this.getConf().hashCode() * 17;
        }

        public String toString() {
            return "NodeConf(" + this.conf + ")";
        }
    }
}

