/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000b\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"functionPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "functionalPackages", "", "Lorg/jetbrains/kotlin/name/FqName;", "kotlinFqn", "isBuiltInFunction", "", "value", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.serialization.common"})
public final class FunctionalInterfacesUtilsKt {
    private static final Pattern functionPattern = Pattern.compile("^K?(Suspend)?Function\\d+$");
    private static final FqName kotlinFqn = new FqName("kotlin");
    private static final List<FqName> functionalPackages;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBuiltInFunction(@NotNull IrDeclaration value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        IrDeclaration irDeclaration2 = value2;
        if (irDeclaration2 instanceof IrSimpleFunction) {
            if (!Intrinsics.areEqual(((IrSimpleFunction)value2).getName(), OperatorNameConventions.INVOKE)) return false;
            IrDeclarationParent irDeclarationParent = value2.getParent();
            if (!(irDeclarationParent instanceof IrClass)) {
                irDeclarationParent = null;
            }
            IrClass irClass = (IrClass)irDeclarationParent;
            if (irClass == null) return false;
            IrClass irClass2 = irClass;
            boolean bl = false;
            boolean bl2 = false;
            IrClass it = irClass2;
            boolean bl3 = false;
            if (!FunctionalInterfacesUtilsKt.isBuiltInFunction(it)) return false;
            return true;
        }
        if (!(irDeclaration2 instanceof IrClass)) return false;
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)value2);
        if (!CollectionsKt.contains((Iterable)functionalPackages, fqName2 != null ? fqName2.parent() : null)) return false;
        String string2 = ((IrClass)value2).getName().asString();
        boolean bl = false;
        boolean bl4 = false;
        String it = string2;
        boolean bl5 = false;
        if (!functionPattern.matcher(it).find()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBuiltInFunction(@NotNull DeclarationDescriptor value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        DeclarationDescriptor declarationDescriptor = value2;
        if (!(declarationDescriptor instanceof FunctionInvokeDescriptor)) {
            FqName it;
            if (!(declarationDescriptor instanceof ClassDescriptor)) return false;
            DeclarationDescriptor declarationDescriptor2 = ((ClassDescriptor)value2).getContainingDeclaration();
            if (!(declarationDescriptor2 instanceof PackageFragmentDescriptor)) {
                declarationDescriptor2 = null;
            }
            PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor2;
            FqName fqn = packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null;
            Iterable $this$any$iv = functionalPackages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (FqName)element$iv;
                boolean bl = false;
            } while (!Intrinsics.areEqual(it, fqn));
            boolean bl = true;
            if (!bl) return false;
            String string2 = ((ClassDescriptor)value2).getName().asString();
            boolean bl2 = false;
            boolean bl3 = false;
            String it2 = string2;
            boolean bl4 = false;
            if (!functionPattern.matcher(it2).find()) return false;
            return true;
        }
        DeclarationDescriptor declarationDescriptor3 = ((FunctionInvokeDescriptor)value2).getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "value.containingDeclaration");
        boolean bl = FunctionalInterfacesUtilsKt.isBuiltInFunction(declarationDescriptor3);
        return bl;
    }

    static {
        FqName[] fqNameArray = new FqName[3];
        fqNameArray[0] = kotlinFqn;
        FqName fqName2 = kotlinFqn.child(Name.identifier("coroutines"));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "kotlinFqn.child(Name.identifier(\"coroutines\"))");
        fqNameArray[1] = fqName2;
        FqName fqName3 = kotlinFqn.child(Name.identifier("reflect"));
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "kotlinFqn.child(Name.identifier(\"reflect\"))");
        fqNameArray[2] = fqName3;
        functionalPackages = CollectionsKt.listOf(fqNameArray);
    }
}

