/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.AllocTableView;
import org.netbeans.lib.profiler.ui.memory.AllocTreeTableView;
import org.netbeans.lib.profiler.ui.memory.LivenessTableView;
import org.netbeans.lib.profiler.ui.memory.LivenessTreeTableView;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.memory.SampledTableView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;

public abstract class LiveMemoryView
extends JPanel {
    private MemoryView dataView;
    private long lastupdate;
    private volatile boolean refreshIsRunning;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private MemoryResultsSnapshot snapshot;
    private MemoryResultsSnapshot refSnapshot;
    private GenericFilter filter;

    public LiveMemoryView(Set<ClientUtils.SourceCodeSelection> set) {
        this.selection = set;
        this.initUI();
    }

    public boolean isRefreshRunning() {
        return this.refreshIsRunning;
    }

    public long getLastUpdate() {
        return this.lastupdate;
    }

    public void setData(final MemoryResultsSnapshot memoryResultsSnapshot, final GenericFilter genericFilter) {
        if (this.refreshIsRunning) {
            return;
        }
        this.refreshIsRunning = true;
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                try {
                    LiveMemoryView.this.updateDataView(memoryResultsSnapshot);
                    LiveMemoryView.this.snapshot = memoryResultsSnapshot;
                    LiveMemoryView.this.filter = genericFilter;
                    if (LiveMemoryView.this.dataView != null && LiveMemoryView.this.snapshot != null) {
                        if (LiveMemoryView.this.refSnapshot == null) {
                            LiveMemoryView.this.dataView.setData(LiveMemoryView.this.snapshot, LiveMemoryView.this.filter, 1);
                        } else {
                            LiveMemoryView.this.dataView.setData(LiveMemoryView.this.refSnapshot.createDiff(LiveMemoryView.this.snapshot), LiveMemoryView.this.filter, 1);
                        }
                    }
                }
                finally {
                    LiveMemoryView.this.refreshIsRunning = false;
                    LiveMemoryView.this.lastupdate = System.currentTimeMillis();
                }
            }
        });
    }

    public boolean setDiffView(boolean bl) {
        if (this.snapshot == null) {
            return false;
        }
        this.refSnapshot = bl ? this.snapshot : null;
        this.setData(this.snapshot, this.filter);
        return true;
    }

    public void resetData() {
        if (this.dataView != null) {
            this.dataView.resetData();
        }
        this.snapshot = null;
        this.refSnapshot = null;
        this.filter = null;
    }

    public void showSelectionColumn() {
        if (this.dataView != null) {
            this.dataView.showSelectionColumn();
        }
    }

    public void refreshSelection() {
        if (this.dataView != null) {
            this.dataView.showSelectionColumn();
        }
    }

    protected boolean profileClassSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void updateDataView(MemoryResultsSnapshot memoryResultsSnapshot) {
        if (memoryResultsSnapshot == null || memoryResultsSnapshot instanceof SampledMemoryResultsSnapshot) {
            if (this.dataView instanceof SampledTableView) {
                return;
            }
            this.dataView = new SampledTableView(this.selection){

                @Override
                protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                    if (LiveMemoryView.this.showSourceSupported()) {
                        LiveMemoryView.this.showSource(sourceCodeSelection);
                    }
                }

                @Override
                protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                    LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, jPopupMenu, object, sourceCodeSelection);
                }

                @Override
                protected void popupShowing() {
                    LiveMemoryView.this.popupShowing();
                }

                @Override
                protected void popupHidden() {
                    LiveMemoryView.this.popupHidden();
                }

                @Override
                protected boolean hasBottomFilterFindMargin() {
                    return true;
                }
            };
        } else if (memoryResultsSnapshot instanceof AllocMemoryResultsSnapshot) {
            if (memoryResultsSnapshot.containsStacks()) {
                if (this.dataView instanceof AllocTreeTableView) {
                    return;
                }
                this.dataView = new AllocTreeTableView(this.selection){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(sourceCodeSelection);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, jPopupMenu, object, sourceCodeSelection);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }

                    @Override
                    HideableBarRenderer.BarDiffMode barDiffMode() {
                        return HideableBarRenderer.BarDiffMode.MODE_BAR_NORMAL;
                    }
                };
            } else {
                if (this.dataView instanceof AllocTableView) {
                    return;
                }
                this.dataView = new AllocTableView(this.selection){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(sourceCodeSelection);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, jPopupMenu, object, sourceCodeSelection);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }

                    @Override
                    HideableBarRenderer.BarDiffMode barDiffMode() {
                        return HideableBarRenderer.BarDiffMode.MODE_BAR_NORMAL;
                    }
                };
            }
        } else if (memoryResultsSnapshot instanceof LivenessMemoryResultsSnapshot) {
            if (memoryResultsSnapshot.containsStacks()) {
                if (this.dataView instanceof LivenessTreeTableView) {
                    return;
                }
                this.dataView = new LivenessTreeTableView(this.selection, false){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(sourceCodeSelection);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, jPopupMenu, object, sourceCodeSelection);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            } else {
                if (this.dataView instanceof LivenessTableView) {
                    return;
                }
                this.dataView = new LivenessTableView(this.selection, false){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(sourceCodeSelection);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, jPopupMenu, object, sourceCodeSelection);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            }
        } else {
            this.dataView = null;
        }
        this.removeAll();
        this.resetData();
        if (this.dataView != null) {
            this.add((Component)this.dataView, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    private void populatePopup(final DataView dataView, JPopupMenu jPopupMenu, Object object, final ClientUtils.SourceCodeSelection sourceCodeSelection) {
        JMenuItem[] jMenuItemArray;
        if (this.showSourceSupported()) {
            jPopupMenu.add(new JMenuItem(MemoryView.ACTION_GOTOSOURCE){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    LiveMemoryView.this.showSource(sourceCodeSelection);
                }
            });
            jPopupMenu.addSeparator();
        }
        if (this.profileClassSupported()) {
            jPopupMenu.add(new JMenuItem(MemoryView.ACTION_PROFILE_CLASS){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    LiveMemoryView.this.selectForProfiling(sourceCodeSelection);
                }
            });
        }
        if (this.profileClassSupported()) {
            jPopupMenu.addSeparator();
        }
        if ((jMenuItemArray = dataView.createCustomMenuItems(this, object, sourceCodeSelection)) != null) {
            for (JMenuItem jMenuItem : jMenuItemArray) {
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.addSeparator();
        }
        this.customizeNodePopup(dataView, jPopupMenu, object, sourceCodeSelection);
        if (this.snapshot.containsStacks()) {
            final ProfilerTreeTable profilerTreeTable = (ProfilerTreeTable)this.dataView.getResultsComponent();
            JMenu jMenu = new JMenu(MemoryView.EXPAND_MENU);
            jPopupMenu.add(jMenu);
            jMenu.add(new JMenuItem(MemoryView.EXPAND_PLAIN_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    profilerTreeTable.expandPlainPath(profilerTreeTable.getSelectedRow(), 1);
                }
            });
            jMenu.add(new JMenuItem(MemoryView.EXPAND_TOPMOST_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    profilerTreeTable.expandFirstPath(profilerTreeTable.getSelectedRow());
                }
            });
            jMenu.addSeparator();
            jMenu.add(new JMenuItem(MemoryView.COLLAPSE_CHILDREN_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    profilerTreeTable.collapseChildren(profilerTreeTable.getSelectedRow());
                }
            });
            jMenu.add(new JMenuItem(MemoryView.COLLAPSE_ALL_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    profilerTreeTable.collapseAll();
                }
            });
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(dataView.createCopyMenuItem());
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateFilter();
            }
        });
        jPopupMenu.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateSearch();
            }
        });
    }

    protected void customizeNodePopup(DataView dataView, JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
    }

    private void initUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.updateDataView(null);
        this.registerActions();
    }

    private void registerActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LiveMemoryView.this.dataView.activateFilter();
            }
        });
        actionMap.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LiveMemoryView.this.dataView.activateSearch();
            }
        });
    }
}

