/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.filters;

import java.util.Arrays;
import java.util.Properties;
import org.netbeans.lib.profiler.filters.GenericFilter;

public class JavaTypeFilter
extends GenericFilter {
    protected static final int MODE_STARTS_WITH_EX = 1025;
    private transient Boolean isAll;
    private transient Boolean isExact;
    private transient Boolean hasArray;

    public JavaTypeFilter() {
    }

    public JavaTypeFilter(GenericFilter genericFilter) {
        super(genericFilter);
    }

    public JavaTypeFilter(String string, int n) {
        super(null, string, n);
    }

    public JavaTypeFilter(Properties properties, String string) {
        super(properties, string);
    }

    public void copyFrom(JavaTypeFilter javaTypeFilter) {
        super.copyFrom(javaTypeFilter);
        this.isAll = javaTypeFilter.isAll;
        this.isExact = javaTypeFilter.isExact;
        this.hasArray = javaTypeFilter.hasArray;
    }

    @Override
    public final boolean isAll() {
        if (super.isAll()) {
            return true;
        }
        if (this.isAll == null) {
            this.computeFlags();
        }
        return this.isAll;
    }

    public final boolean isExact() {
        if (this.isExact == null) {
            this.computeFlags();
        }
        return this.isExact;
    }

    private void computeFlags() {
        for (String string : this.getValues()) {
            if ("*".equals(string) || "**".equals(string)) {
                this.isAll = true;
                this.isExact = false;
                break;
            }
            if (string.charAt(string.length() - 1) != '*') continue;
            this.isExact = false;
        }
        if (this.isAll == null) {
            this.isAll = false;
        }
        if (this.isExact == null) {
            this.isExact = true;
        }
    }

    public final boolean hasArray() {
        if (this.hasArray == null) {
            this.hasArray = this.getValue().indexOf(91) > -1;
        }
        return this.hasArray;
    }

    @Override
    protected void valueChanged() {
        super.valueChanged();
        this.isAll = null;
        this.isExact = null;
        this.hasArray = null;
    }

    @Override
    protected String[] computeValues(String string) {
        return super.computeValues(string.replace('.', '/'));
    }

    @Override
    protected int[] computeModes(String[] stringArray) {
        int n = stringArray.length;
        int[] nArray = new int[n];
        Arrays.fill(nArray, 1000);
        for (int i = 0; i < n; ++i) {
            int n2;
            String string = stringArray[i];
            int n3 = n2 = string == null ? 0 : string.length();
            if (n2 <= 0 || '*' != string.charAt(n2 - 1)) continue;
            if (n2 > 1 && '*' == string.charAt(n2 - 2)) {
                string = string.substring(0, n2 - 2);
                nArray[i] = 1020;
            } else {
                string = string.substring(0, n2 - 1);
                nArray[i] = 1025;
            }
            stringArray[i] = string;
        }
        return nArray;
    }

    @Override
    protected boolean matches(String string, String string2, int n) {
        if (string2.isEmpty()) {
            return true;
        }
        if (n == 1025) {
            if (!string.startsWith(string2)) {
                return false;
            }
            for (int i = string2.length(); i < string.length(); ++i) {
                if ('/' != string.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return super.matches(string, string2, n);
    }
}

