/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.threaddump;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.model.ModelProvider;
import com.sun.tools.visualvm.core.snapshot.RegisteredSnapshotCategories;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import com.sun.tools.visualvm.core.ui.PluggableDataSourceViewProvider;
import com.sun.tools.visualvm.coredump.CoreDump;
import com.sun.tools.visualvm.threaddump.ThreadDump;
import com.sun.tools.visualvm.threaddump.impl.ThreadDumpCategory;
import com.sun.tools.visualvm.threaddump.impl.ThreadDumpDescriptorProvider;
import com.sun.tools.visualvm.threaddump.impl.ThreadDumpProvider;
import com.sun.tools.visualvm.threaddump.impl.ThreadDumpViewProvider;

public final class ThreadDumpSupport {
    private static ThreadDumpSupport instance;
    private final SnapshotCategory category = new ThreadDumpCategory();
    private final ThreadDumpProvider threadDumpProvider;
    private final ThreadDumpViewProvider threadDumpViewProvider;

    public static synchronized ThreadDumpSupport getInstance() {
        if (instance == null) {
            instance = new ThreadDumpSupport();
        }
        return instance;
    }

    public SnapshotCategory getCategory() {
        return this.category;
    }

    public boolean supportsThreadDump(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        return JvmFactory.getJVMFor((Application)application).isTakeThreadDumpSupported();
    }

    public void takeThreadDump(Application application, boolean openView) {
        this.threadDumpProvider.createThreadDump(application, openView);
    }

    public void takeThreadDump(CoreDump coreDump, boolean openView) {
        this.threadDumpProvider.createThreadDump(coreDump, openView);
    }

    public PluggableDataSourceViewProvider<ThreadDump> getThreadDumpView() {
        return this.threadDumpViewProvider;
    }

    private ThreadDumpSupport() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new ThreadDumpDescriptorProvider());
        this.threadDumpProvider = new ThreadDumpProvider();
        this.threadDumpProvider.initialize();
        this.threadDumpViewProvider = new ThreadDumpViewProvider();
        RegisteredSnapshotCategories.sharedInstance().registerCategory(this.category);
        this.threadDumpViewProvider.initialize();
    }
}

