/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ceb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Oras sa Central Africa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Tamdanang Oras sa Moscow",
               "",
               "Oras sa Tag-init sa Moscow",
               "",
               "Oras sa Moscow",
               "",
            };
        final String[] Japan = new String[] {
               "Tamdanang Oras sa Japan",
               "",
               "Oras sa Adlawan sa Japan",
               "",
               "Oras sa Japan",
               "",
            };
        final String[] Pakistan = new String[] {
               "Tamdanang Oras sa Pakistan",
               "",
               "Oras sa Tag-init sa Pakistan",
               "",
               "Oras sa Pakistan",
               "",
            };
        final String[] Taipei = new String[] {
               "Tamdanang Oras sa Taipei",
               "",
               "Oras sa Adlawan sa Taipei",
               "",
               "Oras sa Taipei",
               "",
            };
        final String[] Hovd = new String[] {
               "Tamdanang Oras sa Hovd",
               "",
               "Oras sa Tag-init sa Hovd",
               "",
               "Oras sa Hovd",
               "",
            };
        final String[] Magadan = new String[] {
               "Tamdanang Oras sa Magadan",
               "",
               "Oras sa Tag-init sa Magadan",
               "",
               "Oras sa Magadan",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Tamdanang Oras sa Central Western Australia",
               "",
               "Oras sa Adlawan sa Central Western Australia",
               "",
               "Oras sa Central Western Australia",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Sukdanang Oras sa Europa sa Taliwala sa Adlaw",
               "",
               "Oras sa Europa Taliwala sa Adlaw sa Tag-init",
               "",
               "Oras sa Europa sa Taliwala sa Adlaw",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Tamdanang Oras sa Sakhalin",
               "",
               "Oras sa Tag-init sa Sakhalin",
               "",
               "Oras sa Sakhalin",
               "",
            };
        final String[] Paraguay = new String[] {
               "Tamdanang Oras sa Paraguay",
               "",
               "Oras sa Tag-init sa Paraguay",
               "",
               "Oras sa Paraguay",
               "",
            };
        final String[] Malaysia = new String[] {
               "Oras sa Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Norte Amerika Sukdanang Oras",
               "",
               "Norte Amerika Oras sa Sidlakan sa Kahayag sa Adlaw",
               "",
               "Norte Amerika Oras sa Sidlakan",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Tamdanang Oras sa Lord Howe",
               "",
               "Oras sa Adlawan sa Lord Howe",
               "",
               "Oras sa Lord Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Tamdanang Oras sa New Zealand",
               "",
               "Oras sa Adlawan sa New Zealand",
               "",
               "Oras sa New Zealand",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Oras sa Indian Ocean",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Tamdanang Oras sa Yakutsk",
               "",
               "Oras sa Tag-init sa Yakutsk",
               "",
               "Oras sa Yakutsk",
               "",
            };
        final String[] Mauritius = new String[] {
               "Tamdanang Oras sa Mauritius",
               "",
               "Oras sa Tag-init sa Mauritius",
               "",
               "Oras sa Mauritius",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Oras sa East Africa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "Oras sa East Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Oras sa Solomon Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Oras sa Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Oras sa Marshall Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Sukdanang Oras sa Taga-Oryente sa Europa",
               "",
               "Oras sa Taga-Oryente sa Europa sa Tag-int",
               "",
               "Oras sa Taga-Oryente sa Europa",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Tamdanang Oras sa Newfoundland",
               "",
               "Oras sa Adlawan sa Newfoundland",
               "",
               "Oras sa Newfoundland",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Oras sa Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Tamdanang Oras sa Hong Kong",
               "",
               "Oras sa Tag-init sa Hong Kong",
               "",
               "Oras sa Hong Kong",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "Tamdanang Oras sa Western Argentina",
               "",
               "Oras sa Tag-init sa Western Argentina",
               "",
               "Oras sa Western Argentina",
               "",
            };
        final String[] Atlantic = new String[] {
               "Norte Amerika Sukdanang Oras sa Atlantiko",
               "",
               "Norte Amerika Oras sa Kahayag sa Adlaw sa Atlantiko",
               "",
               "Norte Amerika Oras sa Atlantiko",
               "",
            };
        final String[] Ponape = new String[] {
               "Oras sa Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Oras sa Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Tamdanang Oras sa St. Pierre & Miquelon",
               "",
               "Oras sa Adlawan sa St. Pierre & Miquelon",
               "",
               "Oras sa St. Pierre & Miquelon",
               "",
            };
        final String[] Indochina = new String[] {
               "Oras sa Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Tamdanang Oras sa Yekaterinburg",
               "",
               "Oras sa Tag-init sa Yekaterinburg",
               "",
               "Oras sa Yekaterinburg",
               "",
            };
        final String[] Maldives = new String[] {
               "Oras sa Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Oras sa Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Tamdanang Oras sa Israel",
               "",
               "Oras sa Adlawan sa Israel",
               "",
               "Oras sa Israel",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Oras sa Central Indonesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Oras sa Wallis & Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Tamdanang Oras sa South Africa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Oras sa Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Oras sa Line Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Tamdanang Oras sa Uzbekistan",
               "",
               "Oras sa Tag-init sa Uzbekistan",
               "",
               "Oras sa Uzbekistan",
               "",
            };
        final String[] Omsk = new String[] {
               "Tamdanang Oras sa Omsk",
               "",
               "Oras sa Tag-init sa Omsk",
               "",
               "Oras sa Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "Oras sa Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Tamdanang Oras sa Uruguay",
               "",
               "Oras sa Tag-init sa Uruguay",
               "",
               "Oras sa Uruguay",
               "",
            };
        final String[] Nepal = new String[] {
               "Oras sa Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Tamdanang Oras sa Ulaanbaatar",
               "",
               "Oras sa Tag-init sa Ulaanbaatar",
               "",
               "Oras sa Ulaanbaatar",
               "",
            };
        final String[] America_Central = new String[] {
               "Taliwala nga Sukdanang Oras Norte Amerika",
               "",
               "Taliwala sa Kahayag sa Adlawng Oras Norte Amerika",
               "",
               "Taliwala nga Oras Norte Amerika",
               "",
            };
        final String[] Truk = new String[] {
               "Oras sa Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Niue = new String[] {
               "Oras sa Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Oras sa Wake Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Tamdanang Oras sa Falkland Islands",
               "",
               "Oras sa Tag-init sa Falkland Islands",
               "",
               "Oras sa Falkland Islands",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Tamdanang Oras sa Vanuatu",
               "",
               "Oras sa Tag-init sa Vanuatu",
               "",
               "Oras sa Vanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Tamdanang Oras sa Novosibirsk",
               "",
               "Oras sa Tag-init sa Novosibirsk",
               "",
               "Oras sa Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "Tamdanang Oras sa Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Tamdanang Oras sa Azores",
               "",
               "Oras sa Tag-init sa Azores",
               "",
               "Oras sa Azores",
               "",
            };
        final String[] Apia = new String[] {
               "Tamdanang Oras sa Apia",
               "",
               "Oras sa Adlawan sa Apia",
               "",
               "Oras sa Apia",
               "",
            };
        final String[] Bhutan = new String[] {
               "Oras sa Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Oras sa Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Oras sa Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Tamdanang Oras sa Krasnoyarsk",
               "",
               "Oras sa Tag-init sa Krasnoyarsk",
               "",
               "Oras sa Krasnoyarsk",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Oras sa West Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Myanmar = new String[] {
               "Oras sa Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Oras sa Christmas Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Tamdanang Oras sa Amazon",
               "",
               "Oras sa Tag-init sa Amazon",
               "",
               "Oras sa Amazon",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Oras sa East Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Tamdanang Oras sa Fiji",
               "",
               "Oras sa Tag-init sa Fiji",
               "",
               "Oras sa Fiji",
               "",
            };
        final String[] Reunion = new String[] {
               "Oras sa Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Oras sa Cocos Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Tamdanang Oras sa Chatham",
               "",
               "Oras sa Adlawan sa Chatham",
               "",
               "Oras sa Chatham",
               "",
            };
        final String[] Vostok = new String[] {
               "Oras sa Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Tamdanang Oras sa Argentina",
               "",
               "Oras sa Tag-init sa Argentina",
               "",
               "Oras sa Argentina",
               "",
            };
        final String[] Gambier = new String[] {
               "Oras sa Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Oras sa Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Oras sa Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Oras sa Macquarie Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Oras sa Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Tamdanang Oras sa Hawaii-Aleutian",
               "",
               "Oras sa Adlawan sa Hawaii-Aleutian",
               "",
               "Oras sa Hawaii-Aleutian",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Tamdanang Oras sa Central Australia",
               "",
               "Oras sa Adlawan sa Central Australia",
               "",
               "Oras sa Central Australia",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Norte Amerika Sukdanang Oras sa Pasipiko",
               "",
               "Norte Amerika Oras sa Kahayag sa Adlaw sa Pasipiko",
               "",
               "Norte Amerika Oras sa Pasipiko",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Oras sa Phoenix Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Tamdanang Oras sa Turkmenistan",
               "",
               "Oras sa Tag-init sa Turkmenistan",
               "",
               "Oras sa Turkmenistan",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Sukadanang Oras sa Kasadpanon sa Europa",
               "",
               "Oras sa Kasadpanon sa Europa sa Tag-init",
               "",
               "Oras sa Kasadpanon sa Europa",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Tamdanang Oras sa Cape Verde",
               "",
               "Oras sa Tag-init sa Cape Verde",
               "",
               "Oras sa Cape Verde",
               "",
            };
        final String[] Norfolk = new String[] {
               "Oras sa Norfolk Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Guyana = new String[] {
               "Oras sa Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Oras sa Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Oras sa Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Tamdanang Oras sa Samoa",
               "",
               "Oras sa Adlawan sa Samoa",
               "",
               "Oras sa Samoa",
               "",
            };
        final String[] Palau = new String[] {
               "Oras sa Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Tamdanang Oras sa Azerbaijan",
               "",
               "Oras sa Tag-init sa Azerbaijan",
               "",
               "Oras sa Azerbaijan",
               "",
            };
        final String[] Mawson = new String[] {
               "Oras sa Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Tamdanang Oras sa Mexican Pacific",
               "",
               "Oras sa Adlawan sa Mexican Pacific",
               "",
               "Oras sa Mexican Pacific",
               "",
            };
        final String[] Davis = new String[] {
               "Oras sa Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Tamdanang Oras sa Cuba",
               "",
               "Oras sa Adlawan sa Cuba",
               "",
               "Oras sa Cuba",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Tamdanang Oras sa West Africa",
               "",
               "Oras sa Tag-init sa West Africa",
               "",
               "Oras sa West Africa",
               "",
            };
        final String[] GMT = new String[] {
               "Kasarangang Oras sa Greenwich",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Tamdanang Oras sa Pilipinas",
               "",
               "Oras sa Tag-init sa Pilipinas",
               "",
               "Oras sa Pilipinas",
               "",
            };
        final String[] French_Southern = new String[] {
               "Oras sa French Southern ug Antarctic",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Oras sa South Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Tamdanang Oras sa New Caledonia",
               "",
               "Oras sa Tag-init sa New Caledonia",
               "",
               "Oras sa New Caledonia",
               "",
            };
        final String[] Volgograd = new String[] {
               "Tamdanang Oras sa Volgograd",
               "",
               "Oras sa Tag-init sa Volgograd",
               "",
               "Oras sa Volgograd",
               "",
            };
        final String[] Brunei = new String[] {
               "Oras sa Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Tamdanang Oras sa Iran",
               "",
               "Oras sa Adlawan sa Iran",
               "",
               "Oras sa Iran",
               "",
            };
        final String[] Easter = new String[] {
               "Tamdanang Oras sa Easter Island",
               "",
               "Oras sa Tag-init sa Easter Island",
               "",
               "Oras sa Easter Island",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Tamdanang Oras sa Northwest Mexico",
               "",
               "Oras sa Adlawan sa Northwest Mexico",
               "",
               "Oras sa Northwest Mexico",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Oras sa Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Oras sa Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tamdanang Oras sa Tonga",
               "",
               "Oras sa Tag-init sa Tonga",
               "",
               "Oras sa Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Tamdanang Oras sa Bangladesh",
               "",
               "Oras sa Tag-init sa Bangladesh",
               "",
               "Oras sa Bangladesh",
               "",
            };
        final String[] Peru = new String[] {
               "Tamdanang Oras sa Peru",
               "",
               "Oras sa Tag-init sa Peru",
               "",
               "Oras sa Peru",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Tamdanang Oras sa West Greenland",
               "",
               "Oras sa Tag-init sa West Greenland",
               "",
               "Oras sa West Greenland",
               "",
            };
        final String[] Ecuador = new String[] {
               "Oras sa Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Tamdanang Oras sa East Greenland",
               "",
               "Oras sa Tag-init sa East Greenland",
               "",
               "Oras sa East Greenland",
               "",
            };
        final String[] Gulf = new String[] {
               "Tamdanang Oras sa Gulf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Oras sa Eastern Indonesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Tamdanang Oras sa Korea",
               "",
               "Oras sa Adlawan sa Korea",
               "",
               "Oras sa Korea",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Tamdanang Oras sa Western Australia",
               "",
               "Oras sa Adlawan sa Western Australia",
               "",
               "Oras sa Western Australia",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Oras sa Kyrgyzstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Oras sa Western Indonesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Tamdanang Oras sa Eastern Australia",
               "",
               "Oras sa Adlawan sa Eastern Australia",
               "",
               "Oras sa Eastern Australia",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Oras sa French Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Tamdanang Oras sa Colombia",
               "",
               "Oras sa Tag-init sa Colombia",
               "",
               "Oras sa Colombia",
               "",
            };
        final String[] Chile = new String[] {
               "Tamdanang Oras sa Chile",
               "",
               "Oras sa Tag-init sa Chile",
               "",
               "Oras sa Chile",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Oras sa Gilbert Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Norte Amerika Sukdanang Oras sa Kabukiran",
               "",
               "Norte Amerika Oras sa Kahayag sa Adlaw sa Kabukiran",
               "",
               "Norte Amerika Oras sa Kabukiran",
               "",
            };
        final String[] Marquesas = new String[] {
               "Oras sa Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Tamdanang Oras sa Arabia",
               "",
               "Oras sa Adlawan sa Arabia",
               "",
               "Oras sa Arabia",
               "",
            };
        final String[] Alaska = new String[] {
               "Tamdanang Oras sa Alaska",
               "",
               "Oras sa Adlawan sa Alaska",
               "",
               "Oras sa Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Tamdanang Oras sa Vladivostok",
               "",
               "Oras sa Tag-init sa Vladivostok",
               "",
               "Oras sa Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "Tamdanang Oras sa Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Tamdanang Oras sa Irkutsk",
               "",
               "Oras sa Tag-init sa Irkutsk",
               "",
               "Oras sa Irkutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "Tamdanang Oras sa Georgia",
               "",
               "Oras sa Tag-init sa Georgia",
               "",
               "Oras sa Georgia",
               "",
            };
        final String[] Tokelau = new String[] {
               "Oras sa Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Oras sa Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Tamdanang Oras sa Fernando de Noronha",
               "",
               "Oras sa Tag-init sa Fernando de Noronha",
               "",
               "Oras sa Fernando de Noronha",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Tamdanang Oras sa Choibalsan",
               "",
               "Oras sa Tag-init sa Choibalsan",
               "",
               "Oras sa Choibalsan",
               "",
            };
        final String[] Brasilia = new String[] {
               "Tamdanang Oras sa Brasilia",
               "",
               "Oras sa Tag-init sa Brasilia",
               "",
               "Oras sa Brasilia",
               "",
            };
        final String[] China = new String[] {
               "Tamdanang Oras sa China",
               "",
               "Oras sa Adlawan sa China",
               "",
               "Oras sa China",
               "",
            };
        final String[] Armenia = new String[] {
               "Tamdanang Oras sa Armenia",
               "",
               "Oras sa Tag-init sa Armenia",
               "",
               "Oras sa Armenia",
               "",
            };
        final String[] India = new String[] {
               "Tamdanang Oras sa India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Tamdanang Oras sa Cook Islands",
               "",
               "Katungang Oras sa Tag-init sa Cook Islands",
               "",
               "Oras sa Cook Islands",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Kasarangang Oras sa Greenwich",
                    "",
                    "Oras sa Tag-init sa British",
                    "",
                    "",
                    "",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Etc/GMT", GMT },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Etc/Unknown", "Wala Mailhing Siyudad" },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "SystemV/MST7", America_Mountain },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Kasarangang Oras sa Greenwich",
                    "",
                    "Tamdanang Oras sa Irish",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "SystemV/CST6", America_Central },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Africa/El_Aaiun",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "SystemV/EST5", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Kasarangang Oras sa Greenwich",
                    "",
                    "Oras sa Tag-init sa British",
                    "",
                    "",
                    "",
                }
            },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "SystemV/YST9YDT", Alaska },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "Koordinado nga Unibersohanong Oras",
                    "UTC",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "SystemV/AST4ADT", Atlantic },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
