/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.api.ProfilerStorage;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.oql.repository.api.OQLQueryCategory;
import org.netbeans.modules.profiler.oql.repository.api.OQLQueryDefinition;
import org.netbeans.modules.profiler.oql.repository.api.OQLQueryRepository;

public final class OQLSupport {
    private static final String SAVED_OQL_QUERIES_FILENAME = "oqlqueries";
    private static final String SNAPSHOT_VERSION = "oqlqueries_version_1";
    private static final String PROP_QUERY_NAME_KEY = "query-name";
    private static final String PROP_QUERY_DESCR_KEY = "query-descr";
    private static final String PROP_QUERY_SCRIPT_KEY = "query-script";

    public static OQLTreeModel createModel() {
        return new OQLTreeModel();
    }

    public static void loadModel(OQLTreeModel oQLTreeModel) {
        Object object;
        RootNode rootNode = (RootNode)oQLTreeModel.getRoot();
        try {
            object = new Properties();
            ProfilerStorage.loadGlobalProperties((Properties)object, (String)SAVED_OQL_QUERIES_FILENAME);
            if (!((Properties)object).isEmpty()) {
                OQLSupport.propertiesToModel((Properties)object, oQLTreeModel);
            }
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
        }
        object = OQLQueryRepository.getInstance().listCategories();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            OQLQueryCategory oQLQueryCategory = (OQLQueryCategory)iterator.next();
            OQLCategoryNode oQLCategoryNode = new OQLCategoryNode(oQLQueryCategory);
            rootNode.add(oQLCategoryNode);
            List list = oQLQueryCategory.listQueries();
            for (OQLQueryDefinition oQLQueryDefinition : list) {
                oQLCategoryNode.add(new OQLQueryNode(new Query(oQLQueryDefinition)));
            }
        }
        oQLTreeModel.reload();
    }

    public static void saveModel(OQLTreeModel oQLTreeModel) {
        Object var1_1 = null;
        try {
            Properties properties = OQLSupport.modelToProperties(oQLTreeModel);
            if (!properties.isEmpty()) {
                ProfilerStorage.saveGlobalProperties((Properties)properties, (String)SAVED_OQL_QUERIES_FILENAME);
            }
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
        }
        finally {
            if (var1_1 != null) {
                var1_1.releaseLock();
            }
        }
    }

    private static void propertiesToModel(Properties properties, OQLTreeModel oQLTreeModel) {
        OQLCategoryNode oQLCategoryNode = oQLTreeModel.customCategory;
        int n = -1;
        while (properties.containsKey("query-name-" + ++n)) {
            String string = properties.getProperty("query-name-" + n).trim();
            String string2 = properties.getProperty("query-descr-" + n, "").trim();
            String string3 = properties.getProperty("query-script-" + n, "").trim();
            if (string == null || string3 == null) continue;
            oQLCategoryNode.add(new OQLQueryNode(new Query(string3, string, string2)));
        }
    }

    private static Properties modelToProperties(OQLTreeModel oQLTreeModel) {
        Properties properties = new Properties();
        if (oQLTreeModel.hasCustomQueries()) {
            int n = -1;
            Enumeration<TreeNode> enumeration = oQLTreeModel.customCategory.children();
            while (enumeration.hasMoreElements()) {
                Query query = (Query)((OQLQueryNode)enumeration.nextElement()).getUserObject();
                properties.put("query-name-" + ++n, query.getName().trim());
                properties.put("query-script-" + n, query.getScript().trim());
                if (query.getDescription() == null) continue;
                properties.put("query-descr-" + n, query.getDescription().trim());
            }
        }
        return properties;
    }

    public static final class Query {
        private String script;
        private String name;
        private String description;

        public Query(OQLQueryDefinition oQLQueryDefinition) {
            this(oQLQueryDefinition.getContent(), oQLQueryDefinition.getName(), oQLQueryDefinition.getDescription());
        }

        public Query(String string, String string2, String string3) {
            this.setScript(string);
            this.setName(string2);
            this.setDescription(string3);
        }

        public void setScript(String string) {
            if (string == null) {
                throw new IllegalArgumentException("Script cannot be null");
            }
            this.script = string;
        }

        public String getScript() {
            return this.script;
        }

        public void setName(String string) {
            this.name = Query.normalizeString(string);
            if (this.name == null) {
                throw new IllegalArgumentException("Name cannot be null");
            }
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String string) {
            this.description = Query.normalizeString(string);
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        private static String normalizeString(String string) {
            String string2 = null;
            if (string != null && (string2 = string.trim()).length() == 0) {
                string2 = null;
            }
            return string2;
        }
    }

    private static class NoCustomQueriesNode
    extends SpecialNode {
        private NoCustomQueriesNode() {
        }

        @Override
        public String toString() {
            return Bundle.OQLSupport_NoCustomQueryName();
        }

        @Override
        public String getDescription() {
            return Bundle.OQLSupport_NoCustomQueryDescr();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    private static class RootNode
    extends SpecialNode {
        private RootNode() {
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    public static class OQLQueryNode
    extends OQLNode<Query> {
        public OQLQueryNode(Query query) {
            super(query);
        }

        @Override
        public boolean supportsOpen() {
            return true;
        }

        @Override
        public boolean supportsDelete() {
            return this.isCustomQuery();
        }

        @Override
        public boolean isReadOnly() {
            return !this.isCustomQuery();
        }

        @Override
        public String toString() {
            return ((Query)this.getUserObject()).getName();
        }

        @Override
        public String getCaption() {
            return Bundle.OQLSupport_QueryCaption();
        }

        @Override
        public String getDescription() {
            return ((Query)this.getUserObject()).getDescription();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        private boolean isCustomQuery() {
            return this.getParent() instanceof CustomCategoryNode;
        }
    }

    private static class CustomCategoryNode
    extends OQLCategoryNode {
        private CustomCategoryNode() {
            super(null);
        }

        @Override
        public String toString() {
            return Bundle.OQLSupport_CustomCategoryName();
        }

        @Override
        public String getDescription() {
            return Bundle.OQLSupport_CustomCategoryDescr();
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    public static class OQLCategoryNode
    extends OQLNode<OQLQueryCategory> {
        private final NoCustomQueriesNode noQueries = new NoCustomQueriesNode();

        public OQLCategoryNode(OQLQueryCategory oQLQueryCategory) {
            super(oQLQueryCategory);
            super.insert(this.noQueries, 0);
        }

        @Override
        public String toString() {
            return ((OQLQueryCategory)this.getUserObject()).getName();
        }

        @Override
        public String getCaption() {
            return Bundle.OQLSupport_CategoryCaption();
        }

        @Override
        public String getDescription() {
            return ((OQLQueryCategory)this.getUserObject()).getDescription();
        }

        @Override
        public boolean supportsProperties() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public void insert(MutableTreeNode mutableTreeNode, int n) {
            super.insert(mutableTreeNode, n);
            if (this.isNodeChild(this.noQueries)) {
                super.remove(0);
            }
        }

        @Override
        public void remove(int n) {
            super.remove(n);
            if (this.getChildCount() == 0) {
                super.insert(this.noQueries, 0);
            }
        }
    }

    private static abstract class SpecialNode
    extends OQLNode<Object> {
        public SpecialNode() {
            super(null);
        }

        @Override
        public boolean supportsProperties() {
            return false;
        }
    }

    public static abstract class OQLNode<T>
    extends DefaultMutableTreeNode {
        public OQLNode(T t) {
            super(t);
        }

        public final T getUserObject() {
            return (T)super.getUserObject();
        }

        public String getDescription() {
            return null;
        }

        public String getCaption() {
            return "";
        }

        public boolean supportsProperties() {
            return true;
        }

        public boolean isReadOnly() {
            return true;
        }

        public boolean supportsDelete() {
            return false;
        }

        public boolean supportsOpen() {
            return false;
        }
    }

    public static final class OQLTreeModel
    extends DefaultTreeModel {
        private final OQLCategoryNode customCategory = new CustomCategoryNode();

        public OQLTreeModel() {
            super(new RootNode());
            this.root().add(this.customCategory);
        }

        public boolean hasCustomQueries() {
            return this.customCategory.getChildCount() > 1 || !(this.customCategory.getChildAt(0) instanceof NoCustomQueriesNode);
        }

        public boolean hasDefinedCategories() {
            return this.root.getChildCount() > 1 || !(this.root.getChildAt(0) instanceof CustomCategoryNode);
        }

        public OQLCategoryNode customCategory() {
            return this.customCategory;
        }

        private OQLNode root() {
            return (OQLNode)this.root;
        }
    }
}

