/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.help.HelpTOCLoader;
import org.gjt.sp.jedit.help.HelpViewerInterface;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.ThreadUtilities;

public class HelpTOCPanel
extends JPanel {
    private HelpViewerInterface helpViewer;
    private DefaultTreeModel tocModel;
    private JTree toc;
    private Map<String, DefaultMutableTreeNode> nodes;

    public HelpTOCPanel(HelpViewerInterface helpViewerInterface) {
        super(new BorderLayout());
        this.helpViewer = helpViewerInterface;
        this.nodes = new HashMap<String, DefaultMutableTreeNode>();
        this.toc = new TOCTree();
        if (!OperatingSystem.isMacOSLF()) {
            this.toc.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.toc.setRowHeight(0);
        this.toc.setCellRenderer(new TOCCellRenderer());
        this.toc.setEditable(false);
        this.toc.setShowsRootHandles(true);
        this.add("Center", new JScrollPane(this.toc));
        this.load();
    }

    public void selectNode(String string) {
        if (this.tocModel == null) {
            return;
        }
        final DefaultMutableTreeNode defaultMutableTreeNode = this.nodes.get(string);
        if (defaultMutableTreeNode == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath treePath = new TreePath(HelpTOCPanel.this.tocModel.getPathToRoot(defaultMutableTreeNode));
                HelpTOCPanel.this.toc.expandPath(treePath);
                HelpTOCPanel.this.toc.setSelectionPath(treePath);
                HelpTOCPanel.this.toc.scrollPathToVisible(treePath);
            }
        });
    }

    public void load() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(jEdit.getProperty("helpviewer.toc.loading")));
        this.toc.setModel(defaultTreeModel);
        this.toc.setRootVisible(true);
        ThreadUtilities.runInBackground(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode defaultMutableTreeNode = new HelpTOCLoader(HelpTOCPanel.this.nodes, HelpTOCPanel.this.helpViewer.getBaseURL()).createTOC();
                HelpTOCPanel.this.tocModel = new DefaultTreeModel(defaultMutableTreeNode);
                HelpTOCPanel.this.toc.setModel(HelpTOCPanel.this.tocModel);
                HelpTOCPanel.this.toc.setRootVisible(false);
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                    HelpTOCPanel.this.toc.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                }
                if (HelpTOCPanel.this.helpViewer.getShortURL() != null) {
                    HelpTOCPanel.this.selectNode(HelpTOCPanel.this.helpViewer.getShortURL());
                }
            }
        });
    }

    static class TOCCellRenderer
    extends EnhancedTreeCellRenderer {
        EmptyBorder border = new EmptyBorder(1, 0, 1, 1);

        TOCCellRenderer() {
        }

        @Override
        protected TreeCellRenderer newInstance() {
            return new TOCCellRenderer();
        }

        @Override
        protected void configureTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setIcon(bl3 ? FileCellRenderer.fileIcon : (bl2 ? FileCellRenderer.openDirIcon : FileCellRenderer.dirIcon));
            this.setBorder(this.border);
        }
    }

    class TOCTree
    extends JTree {
        TOCTree() {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.selectionModel.setSelectionMode(1);
        }

        @Override
        public final String getToolTipText(MouseEvent mouseEvent) {
            Rectangle rectangle;
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && (rectangle = this.getPathBounds(treePath)) != null && !this.cellRectIsVisible(rectangle)) {
                return treePath.getLastPathComponent().toString();
            }
            return null;
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            if (401 == keyEvent.getID() && 10 == keyEvent.getKeyCode()) {
                TreePath treePath = this.getSelectionPath();
                this.expandOrGotoPath(treePath);
                keyEvent.consume();
            } else {
                super.processKeyEvent(keyEvent);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 500: {
                    TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    this.expandOrGotoPath(treePath);
                    super.processMouseEvent(mouseEvent);
                    break;
                }
                default: {
                    super.processMouseEvent(mouseEvent);
                }
            }
        }

        private boolean cellRectIsVisible(Rectangle rectangle) {
            Rectangle rectangle2 = this.getVisibleRect();
            return rectangle2.contains(rectangle.x, rectangle.y) && rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }

        private void expandOrGotoPath(TreePath treePath) {
            if (treePath != null) {
                Object object;
                if (!this.isPathSelected(treePath)) {
                    this.setSelectionPath(treePath);
                }
                if ((object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof HelpTOCLoader.HelpNode) {
                    HelpTOCLoader.HelpNode helpNode = (HelpTOCLoader.HelpNode)object;
                    HelpTOCPanel.this.helpViewer.gotoURL(helpNode.href, true, 0);
                } else {
                    this.expandPath(treePath);
                }
            }
        }
    }
}

