/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.server;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.logging.CacheEvent;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRemoteCacheService<K, V>
implements ICacheServiceNonLocal<K, V> {
    private transient ICacheEventLogger cacheEventLogger;
    private ICompositeCacheManager cacheManager;
    private String eventLogSourceName = "AbstractRemoteCacheService";
    private int puts = 0;
    private final int logInterval = 100;
    private static final Log log = LogFactory.getLog(AbstractRemoteCacheService.class);

    public AbstractRemoteCacheService(ICompositeCacheManager cacheManager, ICacheEventLogger cacheEventLogger) {
        this.cacheManager = cacheManager;
        this.cacheEventLogger = cacheEventLogger;
    }

    @Override
    public void update(ICacheElement<K, V> item) throws IOException {
        this.update(item, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ICacheElement<K, V> item, long requesterId) throws IOException {
        ICacheEvent<ICacheElement<K, V>> cacheEvent = this.createICacheEvent(item, requesterId, "update");
        try {
            this.logUpdateInfo(item);
            this.processUpdate(item, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract void processUpdate(ICacheElement<K, V> var1, long var2) throws IOException;

    private void logUpdateInfo(ICacheElement<K, V> item) {
        if (log.isInfoEnabled()) {
            ++this.puts;
            if (this.puts % 100 == 0) {
                log.info("puts = " + this.puts);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("In update, put [" + item.getKey() + "] in [" + item.getCacheName() + "]");
        }
    }

    @Override
    public ICacheElement<K, V> get(String cacheName, K key) throws IOException {
        return this.get(cacheName, key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheElement<K, V> get(String cacheName, K key, long requesterId) throws IOException {
        ICacheElement<K, V> element = null;
        ICacheEvent<K> cacheEvent = this.createICacheEvent(cacheName, key, requesterId, "get");
        try {
            element = this.processGet(cacheName, key, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
        return element;
    }

    abstract ICacheElement<K, V> processGet(String var1, K var2, long var3) throws IOException;

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern) throws IOException {
        return this.getMatching(cacheName, pattern, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern, long requesterId) throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(cacheName, pattern, requesterId, "getMatching");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMatching(cacheName, pattern, requesterId);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract Map<K, ICacheElement<K, V>> processGetMatching(String var1, String var2, long var3) throws IOException;

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys) throws IOException {
        return this.getMultiple(cacheName, keys, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys, long requesterId) throws IOException {
        ICacheEvent<Serializable> cacheEvent = this.createICacheEvent(cacheName, (Serializable)((Object)keys), requesterId, "getMultiple");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMultiple(cacheName, keys, requesterId);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract Map<K, ICacheElement<K, V>> processGetMultiple(String var1, Set<K> var2, long var3) throws IOException;

    @Override
    public Set<K> getKeySet(String cacheName) {
        return this.processGetKeySet(cacheName);
    }

    public Set<K> processGetKeySet(String cacheName) {
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        return cache.getKeySet();
    }

    @Override
    public void remove(String cacheName, K key) throws IOException {
        this.remove(cacheName, key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String cacheName, K key, long requesterId) throws IOException {
        ICacheEvent<K> cacheEvent = this.createICacheEvent(cacheName, key, requesterId, "remove");
        try {
            this.processRemove(cacheName, key, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract void processRemove(String var1, K var2, long var3) throws IOException;

    @Override
    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(String cacheName, long requesterId) throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(cacheName, "all", requesterId, "removeAll");
        try {
            this.processRemoveAll(cacheName, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract void processRemoveAll(String var1, long var2) throws IOException;

    @Override
    public void dispose(String cacheName) throws IOException {
        this.dispose(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(String cacheName, long requesterId) throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(cacheName, "none", requesterId, "dispose");
        try {
            this.processDispose(cacheName, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract void processDispose(String var1, long var2) throws IOException;

    public String getStats() throws IOException {
        return this.cacheManager.getStats();
    }

    protected ICacheEvent<ICacheElement<K, V>> createICacheEvent(ICacheElement<K, V> item, long requesterId, String eventName) {
        if (this.cacheEventLogger == null) {
            return new CacheEvent<ICacheElement<K, V>>();
        }
        String ipAddress = this.getExtraInfoForRequesterId(requesterId);
        return this.cacheEventLogger.createICacheEvent(this.getEventLogSourceName(), item.getCacheName(), eventName, ipAddress, item);
    }

    protected <T> ICacheEvent<T> createICacheEvent(String cacheName, T key, long requesterId, String eventName) {
        if (this.cacheEventLogger == null) {
            return new CacheEvent();
        }
        String ipAddress = this.getExtraInfoForRequesterId(requesterId);
        return this.cacheEventLogger.createICacheEvent(this.getEventLogSourceName(), cacheName, eventName, ipAddress, key);
    }

    protected void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logApplicationEvent(source, eventName, optionalDetails);
        }
    }

    protected <T> void logICacheEvent(ICacheEvent<T> cacheEvent) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logICacheEvent(cacheEvent);
        }
    }

    protected abstract String getExtraInfoForRequesterId(long var1);

    public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        this.cacheEventLogger = cacheEventLogger;
    }

    protected void setCacheManager(ICompositeCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected ICompositeCacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected void setEventLogSourceName(String eventLogSourceName) {
        this.eventLogSourceName = eventLogSourceName;
    }

    protected String getEventLogSourceName() {
        return this.eventLogSourceName;
    }
}

