/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class NameFinder {
    public static final String NOMINATIM_URL = "https://nominatim.openstreetmap.org/search?format=xml&q=";
    public static final StringProperty NOMINATIM_URL_PROP = new StringProperty("nominatim-url", "https://nominatim.openstreetmap.org/search?format=xml&q=");

    private NameFinder() {
    }

    public static List<SearchResult> queryNominatim(String searchExpression) throws IOException {
        return NameFinder.query(new URL(NOMINATIM_URL_PROP.get() + Utils.encodeUrl(searchExpression)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<SearchResult> query(URL url) throws IOException {
        HttpClient connection = HttpClient.create(url).setAccept("application/xml, */*;q=0.8");
        HttpClient.Response response = connection.connect();
        if (response.getResponseCode() >= 400) {
            throw new IOException(response.getResponseMessage() + ": " + response.fetchContent());
        }
        try (BufferedReader reader = response.getContentReader();){
            List<SearchResult> list = NameFinder.parseSearchResults(reader);
            return list;
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new UncheckedParseException(ex);
        }
    }

    public static List<SearchResult> parseSearchResults(Reader reader) throws IOException, ParserConfigurationException, SAXException {
        InputSource inputSource = new InputSource(reader);
        NameFinderResultParser parser = new NameFinderResultParser();
        XmlUtils.parseSafeSAX(inputSource, parser);
        return parser.getResult();
    }

    private static class NameFinderResultParser
    extends DefaultHandler {
        private SearchResult currentResult;
        private StringBuilder description;
        private int depth;
        private final List<SearchResult> data = new LinkedList<SearchResult>();

        private NameFinderResultParser() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            ++this.depth;
            try {
                if (!"searchresults".equals(qName)) {
                    if (this.depth == 2 && "named".equals(qName)) {
                        this.currentResult = new SearchResult();
                        this.currentResult.name = atts.getValue("name");
                        this.currentResult.info = atts.getValue("info");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info, new Object[0]);
                        }
                        this.currentResult.lat = Double.parseDouble(atts.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(atts.getValue("lon"));
                        this.currentResult.zoom = Integer.parseInt(atts.getValue("zoom"));
                        this.data.add(this.currentResult);
                    } else if (this.depth == 3 && "description".equals(qName)) {
                        this.description = new StringBuilder();
                    } else if (this.depth == 4 && "named".equals(qName)) {
                        String info = atts.getValue("info");
                        if ("city".equals(info) || "town".equals(info) || "village".equals(info)) {
                            this.currentResult.nearestPlace = atts.getValue("name");
                        }
                    } else if ("place".equals(qName) && atts.getValue("lat") != null) {
                        this.currentResult = new SearchResult();
                        this.currentResult.name = atts.getValue("display_name");
                        this.currentResult.description = this.currentResult.name;
                        this.currentResult.info = atts.getValue("class");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info, new Object[0]);
                        }
                        this.currentResult.nearestPlace = I18n.tr(atts.getValue("type"), new Object[0]);
                        this.currentResult.lat = Double.parseDouble(atts.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(atts.getValue("lon"));
                        String[] bbox = atts.getValue("boundingbox").split(",");
                        this.currentResult.bounds = new Bounds(Double.parseDouble(bbox[0]), Double.parseDouble(bbox[2]), Double.parseDouble(bbox[1]), Double.parseDouble(bbox[3]));
                        String osmId = atts.getValue("osm_id");
                        String osmType = atts.getValue("osm_type");
                        if (osmId != null && osmType != null) {
                            this.currentResult.osmId = new SimplePrimitiveId(Long.parseLong(osmId), OsmPrimitiveType.from(osmType));
                        }
                        this.data.add(this.currentResult);
                    }
                }
            }
            catch (NumberFormatException ex) {
                Logging.error(ex);
                throw new SAXException(ex.getMessage(), ex);
            }
            catch (NullPointerException ex) {
                Logging.error(ex);
                throw new SAXException(I18n.tr("Null pointer exception, possibly some missing tags.", new Object[0]), ex);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.description != null && "description".equals(qName)) {
                this.currentResult.description = this.description.toString();
                this.description = null;
            }
            --this.depth;
        }

        @Override
        public void characters(char[] data, int start, int length) throws SAXException {
            if (this.description != null) {
                this.description.append(data, start, length);
            }
        }

        public List<SearchResult> getResult() {
            return Collections.unmodifiableList(this.data);
        }
    }

    public static class SearchResult {
        private String name;
        private String info;
        private String nearestPlace;
        private String description;
        private double lat;
        private double lon;
        private int zoom;
        private Bounds bounds;
        private PrimitiveId osmId;

        public final String getName() {
            return this.name;
        }

        public final String getInfo() {
            return this.info;
        }

        public final String getNearestPlace() {
            return this.nearestPlace;
        }

        public final String getDescription() {
            return this.description;
        }

        public final double getLat() {
            return this.lat;
        }

        public final double getLon() {
            return this.lon;
        }

        public final int getZoom() {
            return this.zoom;
        }

        public final Bounds getBounds() {
            return this.bounds;
        }

        public final PrimitiveId getOsmId() {
            return this.osmId;
        }

        public Bounds getDownloadArea() {
            return this.bounds != null ? this.bounds : OsmUrlToBounds.positionToBounds(this.lat, this.lon, this.zoom);
        }
    }
}

