/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceChaCha20Poly1305
implements TlsAEADCipherImpl {
    private static final int BUF_SIZE = 32768;
    private static final byte[] ZEROES = new byte[15];
    protected final Cipher cipher;
    protected final Mac mac;
    protected final int cipherMode;
    protected SecretKey cipherKey;
    protected byte[] additionalData;

    public JceChaCha20Poly1305(JcaJceHelper jcaJceHelper, boolean bl) throws GeneralSecurityException {
        this.cipher = jcaJceHelper.createCipher("ChaCha7539");
        this.mac = jcaJceHelper.createMac("Poly1305");
        this.cipherMode = bl ? 1 : 2;
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IOException {
        try {
            int n4;
            if (this.cipherMode == 1) {
                int n5;
                int n6 = n2;
                byte[] byArray3 = new byte[64 + n6];
                System.arraycopy(byArray, n, byArray3, 64, n6);
                for (n5 = 0; n5 < byArray3.length - 32768; n5 += this.cipher.update(byArray3, n5, 32768, byArray3, n5)) {
                }
                int n7 = this.cipher.update(byArray3, n5, byArray3.length - n5, byArray3, n5);
                if (byArray3.length != n5 + (n7 += this.cipher.doFinal(byArray3, n7))) {
                    throw new IllegalStateException();
                }
                System.arraycopy(byArray3, 64, byArray2, n3, n6);
                this.initMAC(byArray3);
                this.updateMAC(this.additionalData, 0, this.additionalData.length);
                this.updateMAC(byArray3, 64, n6);
                byte[] byArray4 = new byte[16];
                Pack.longToLittleEndian((long)((long)this.additionalData.length & 0xFFFFFFFFL), (byte[])byArray4, (int)0);
                Pack.longToLittleEndian((long)((long)n6 & 0xFFFFFFFFL), (byte[])byArray4, (int)8);
                this.mac.update(byArray4, 0, 16);
                this.mac.doFinal(byArray2, n3 + n6);
                return n6 + 16;
            }
            int n8 = n2 - 16;
            byte[] byArray5 = new byte[64 + n8];
            System.arraycopy(byArray, n, byArray5, 64, n8);
            for (n4 = 0; n4 < byArray5.length - 32768; n4 += this.cipher.update(byArray5, n4, 32768, byArray5, n4)) {
            }
            int n9 = this.cipher.update(byArray5, n4, byArray5.length - n4, byArray5, n4);
            if (byArray5.length != n4 + (n9 += this.cipher.doFinal(byArray5, n9))) {
                throw new IllegalStateException();
            }
            this.initMAC(byArray5);
            this.updateMAC(this.additionalData, 0, this.additionalData.length);
            this.updateMAC(byArray, n, n8);
            byte[] byArray6 = new byte[16];
            Pack.longToLittleEndian((long)((long)this.additionalData.length & 0xFFFFFFFFL), (byte[])byArray6, (int)0);
            Pack.longToLittleEndian((long)((long)n8 & 0xFFFFFFFFL), (byte[])byArray6, (int)8);
            this.mac.update(byArray6, 0, 16);
            this.mac.doFinal(byArray6, 0);
            byte[] byArray7 = Arrays.copyOfRange((byte[])byArray, (int)(n + n8), (int)(n + n2));
            if (!Arrays.constantTimeAreEqual((byte[])byArray6, (byte[])byArray7)) {
                throw new TlsFatalAlert(20);
            }
            System.arraycopy(byArray5, 64, byArray2, n3, n8);
            return n8;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }

    @Override
    public int getOutputSize(int n) {
        return this.cipherMode == 1 ? n + 16 : n - 16;
    }

    @Override
    public void init(byte[] byArray, int n, byte[] byArray2) throws IOException {
        if (byArray == null || byArray.length != 12 || n != 16) {
            throw new TlsFatalAlert(80);
        }
        try {
            this.cipher.init(this.cipherMode, (Key)this.cipherKey, new IvParameterSpec(byArray));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
        this.additionalData = byArray2;
    }

    @Override
    public void setKey(byte[] byArray, int n, int n2) throws IOException {
        this.cipherKey = new SecretKeySpec(byArray, n, n2, "ChaCha7539");
    }

    protected void initMAC(byte[] byArray) throws InvalidKeyException {
        this.mac.init(new SecretKeySpec(byArray, 0, 32, "Poly1305"));
        for (int i = 0; i < 64; ++i) {
            byArray[i] = 0;
        }
    }

    protected void updateMAC(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
        int n3 = n2 % 16;
        if (n3 != 0) {
            this.mac.update(ZEROES, 0, 16 - n3);
        }
    }
}

