/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class TextAreaFIFO
extends JTextArea
implements DocumentListener {
    private int maxChars;
    private int trimMaxChars;
    private int updateCount;
    private boolean doTrim;

    public TextAreaFIFO(int max) {
        this.maxChars = max;
        this.trimMaxChars = max / 2;
        this.updateCount = 0;
        this.doTrim = true;
        this.getDocument().addDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (++this.updateCount > 150 && this.doTrim) {
            this.updateCount = 0;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextAreaFIFO.this.trimDocument();
                }
            });
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void trimDocument() {
        int len = 0;
        len = this.getDocument().getLength();
        if (len > this.trimMaxChars) {
            int n = len - this.trimMaxChars;
            try {
                this.getDocument().remove(0, n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void appendNoTrim(String s) {
        int free = this.maxChars - this.getDocument().getLength();
        if (free <= 0) {
            return;
        }
        if (s.length() > free) {
            this.append(s.substring(0, free));
        } else {
            this.append(s);
        }
        this.doTrim = false;
    }

    public void appendTrim(String str) {
        this.append(str);
        this.doTrim = true;
    }
}

