/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.elasticsearch.analysis.common.CharMatcher;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class CharGroupTokenizerFactory
extends AbstractTokenizerFactory {
    private final Set<Integer> tokenizeOnChars = new HashSet<Integer>();
    private boolean tokenizeOnSpace = false;
    private boolean tokenizeOnLetter = false;
    private boolean tokenizeOnDigit = false;
    private boolean tokenizeOnPunctuation = false;
    private boolean tokenizeOnSymbol = false;

    public CharGroupTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, settings, name);
        block14: for (String c : settings.getAsList("tokenize_on_chars")) {
            if (c == null || c.length() == 0) {
                throw new RuntimeException("[tokenize_on_chars] cannot contain empty characters");
            }
            if (c.length() == 1) {
                this.tokenizeOnChars.add(Integer.valueOf(c.charAt(0)));
                continue;
            }
            if (c.charAt(0) == '\\') {
                this.tokenizeOnChars.add(Integer.valueOf(this.parseEscapedChar(c)));
                continue;
            }
            switch (c) {
                case "letter": {
                    this.tokenizeOnLetter = true;
                    continue block14;
                }
                case "digit": {
                    this.tokenizeOnDigit = true;
                    continue block14;
                }
                case "whitespace": {
                    this.tokenizeOnSpace = true;
                    continue block14;
                }
                case "punctuation": {
                    this.tokenizeOnPunctuation = true;
                    continue block14;
                }
                case "symbol": {
                    this.tokenizeOnSymbol = true;
                    continue block14;
                }
            }
            throw new RuntimeException("Invalid escaped char in [" + c + "]");
        }
    }

    private char parseEscapedChar(String s) {
        int len = s.length();
        char c = s.charAt(0);
        if (c == '\\') {
            if (1 >= len) {
                throw new RuntimeException("Invalid escaped char in [" + s + "]");
            }
            c = s.charAt(1);
            switch (c) {
                case '\\': {
                    return '\\';
                }
                case 'n': {
                    return '\n';
                }
                case 't': {
                    return '\t';
                }
                case 'r': {
                    return '\r';
                }
                case 'b': {
                    return '\b';
                }
                case 'f': {
                    return '\f';
                }
                case 'u': {
                    if (len > 6) {
                        throw new RuntimeException("Invalid escaped char in [" + s + "]");
                    }
                    return (char)Integer.parseInt(s.substring(2), 16);
                }
            }
            throw new RuntimeException("Invalid escaped char " + c + " in [" + s + "]");
        }
        throw new RuntimeException("Invalid escaped char [" + s + "]");
    }

    public Tokenizer create() {
        return new CharTokenizer(){

            protected boolean isTokenChar(int c) {
                if (CharGroupTokenizerFactory.this.tokenizeOnSpace && Character.isWhitespace(c)) {
                    return false;
                }
                if (CharGroupTokenizerFactory.this.tokenizeOnLetter && Character.isLetter(c)) {
                    return false;
                }
                if (CharGroupTokenizerFactory.this.tokenizeOnDigit && Character.isDigit(c)) {
                    return false;
                }
                if (CharGroupTokenizerFactory.this.tokenizeOnPunctuation && CharMatcher.Basic.PUNCTUATION.isTokenChar(c)) {
                    return false;
                }
                if (CharGroupTokenizerFactory.this.tokenizeOnSymbol && CharMatcher.Basic.SYMBOL.isTokenChar(c)) {
                    return false;
                }
                return !CharGroupTokenizerFactory.this.tokenizeOnChars.contains(c);
            }
        };
    }
}

