/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.Context;
import esmska.data.Icons;
import esmska.data.Queue;
import esmska.gui.Actions;
import esmska.gui.MainFrame;
import esmska.utils.L10N;
import esmska.utils.RuntimeUtils;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class NotificationIcon {
    private static NotificationIcon instance;
    private static boolean installed;
    private static final Logger logger;
    private static final ResourceBundle l10n;
    private static final Queue queue;
    private static final String pauseQueue;
    private static final String unpauseQueue;
    private static final String showWindow;
    private static final String hideWindow;
    private static Boolean supported;
    private static Image trayImageDefault;
    private PopupMenu popup = null;
    private TrayIcon trayIcon = null;
    private MenuItem toggleItem = new MenuItem(l10n.getString("Show/hide_program"));
    private MenuItem pauseQueueItem;
    private MenuItem historyItem;
    private MenuItem configItem;
    private MenuItem quitItem;
    private MenuItem separatorItem;

    private NotificationIcon() {
        this.toggleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationIcon.toggleMainFrameVisibility();
            }
        });
        this.pauseQueueItem = new MenuItem(l10n.getString("NotificationIcon.Pause/unpause_sending"));
        this.pauseQueueItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                queue.setPaused(!queue.isPaused());
            }
        });
        this.historyItem = new MenuItem(l10n.getString("History"));
        this.historyItem.addActionListener(Actions.getHistoryAction());
        this.configItem = new MenuItem(l10n.getString("Preferences"));
        this.configItem.addActionListener(Actions.getConfigAction());
        this.quitItem = new MenuItem(l10n.getString("Quit"));
        this.quitItem.addActionListener(Actions.getQuitAction());
        this.separatorItem = new MenuItem("-");
        this.popup = new PopupMenu();
        Context.mainFrame.add(this.popup);
        this.popup.add(this.toggleItem);
        this.popup.add(this.pauseQueueItem);
        this.popup.add(this.historyItem);
        this.popup.add(this.configItem);
        this.popup.add(this.separatorItem);
        this.popup.add(this.quitItem);
        switch (RuntimeUtils.detectOS()) {
            case MAC_OS_X: {
                this.popup.remove(this.toggleItem);
                this.popup.remove(this.configItem);
                this.popup.remove(this.separatorItem);
                this.popup.remove(this.quitItem);
            }
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && !e.isPopupTrigger()) {
                    NotificationIcon.toggleMainFrameVisibility();
                }
                NotificationIcon.this.updateItems();
            }
        };
        String logo = "esmska.png";
        if (NotificationIcon.isSupported()) {
            Dimension size = SystemTray.getSystemTray().getTrayIconSize();
            if (size.getWidth() <= 16.0 && size.getHeight() <= 16.0) {
                logo = "esmska-16.png";
            } else if (size.getWidth() <= 32.0 && size.getHeight() <= 32.0) {
                logo = "esmska-32.png";
            } else if (size.getWidth() <= 64.0 && size.getHeight() <= 64.0) {
                logo = "esmska-64.png";
            }
        }
        trayImageDefault = Icons.get(logo).getImage();
        this.trayIcon = new TrayIcon(trayImageDefault, "Esmska", this.popup);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addMouseListener(mouseAdapter);
    }

    public static NotificationIcon getInstance() {
        if (!NotificationIcon.isSupported()) {
            return null;
        }
        if (instance == null) {
            instance = new NotificationIcon();
        }
        return instance;
    }

    public static void toggleMainFrameVisibility() {
        if (!installed) {
            return;
        }
        logger.fine("Toggling mainframe visibility...");
        MainFrame frame = Context.mainFrame;
        if ((frame.getExtendedState() & 1) != 0) {
            int state = frame.getExtendedState() & 0xFFFFFFFE;
            frame.setExtendedState(state);
            return;
        }
        frame.setVisible(!frame.isVisible());
    }

    private void updateItems() {
        MainFrame frame = Context.mainFrame;
        boolean queuePaused = queue.isPaused();
        this.pauseQueueItem.setLabel(queuePaused ? unpauseQueue : pauseQueue);
        boolean visible = frame.isVisible() && (frame.getExtendedState() & 1) == 0;
        this.toggleItem.setLabel(visible ? hideWindow : showWindow);
    }

    public static void install() {
        logger.fine("Installing notification icon...");
        if (!NotificationIcon.isSupported()) {
            logger.fine("Notification icon not supported");
            return;
        }
        NotificationIcon.getInstance();
        SystemTray tray = SystemTray.getSystemTray();
        try {
            tray.remove(NotificationIcon.instance.trayIcon);
            tray.add(NotificationIcon.instance.trayIcon);
            installed = true;
        }
        catch (AWTException ex) {
            logger.log(Level.WARNING, "Can't install program icon in the notification area", ex);
        }
    }

    public static void uninstall() {
        logger.fine("Uninstalling notification icon...");
        if (!NotificationIcon.isSupported()) {
            logger.fine("Notification icon not supported");
            return;
        }
        NotificationIcon.getInstance();
        if (!Context.mainFrame.isVisible()) {
            NotificationIcon.toggleMainFrameVisibility();
        }
        SystemTray tray = SystemTray.getSystemTray();
        tray.remove(NotificationIcon.instance.trayIcon);
        installed = false;
    }

    public static boolean isSupported() {
        if (supported == null) {
            supported = SystemTray.isSupported();
            if (RuntimeUtils.isGnome3Desktop()) {
                supported = false;
            }
        }
        return supported;
    }

    public static boolean isInstalled() {
        return installed;
    }

    public PopupMenu getPopup() {
        return this.popup;
    }

    static {
        logger = Logger.getLogger(NotificationIcon.class.getName());
        l10n = L10N.l10nBundle;
        queue = Queue.getInstance();
        pauseQueue = l10n.getString("Pause_sms_queue");
        unpauseQueue = l10n.getString("Unpause_sms_queue");
        showWindow = l10n.getString("Show_program");
        hideWindow = l10n.getString("Hide_program");
        supported = null;
    }
}

