/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.impl.FormattingAndParsingUtils;

public final class ArraysParser {
    public static <T> T[] parseArray(Class<T[]> arrayTypeClass, String input) throws IllegalArgumentException {
        if (input == null) {
            return null;
        }
        Class<?> componentType = arrayTypeClass.getComponentType();
        if (input.equalsIgnoreCase("<empty>")) {
            Object[] result = (Object[])Array.newInstance(componentType, 0);
            return result;
        }
        ArrayList<String> values = new ArrayList<String>();
        try {
            int r;
            StringReader reader = new StringReader(input + ' ');
            block6: while ((r = reader.read()) != -1) {
                char c = (char)r;
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '(': 
                    case ')': 
                    case ',': 
                    case '[': 
                    case ']': {
                        continue block6;
                    }
                    case '\"': 
                    case '\'': {
                        values.add(FormattingAndParsingUtils.parseLiteral(reader, c));
                        continue block6;
                    }
                }
                reader.skip(-1L);
                String value = FormattingAndParsingUtils.parseValue(reader);
                if (value.equals("null")) {
                    value = null;
                }
                values.add(value);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected expection while parsing array value", ex);
        }
        Object[] result = (Object[])Array.newInstance(componentType, values.size());
        for (int i = 0; i < values.size(); ++i) {
            result[i] = values.get(i) != null ? FormattingAndParsingUtils.convertValue(componentType, (String)values.get(i)) : null;
        }
        return result;
    }

    public static <T> Object parseArrayAsPrimitiveArray(Class<T[]> arrayTypeClass, String input) throws IllegalArgumentException {
        Object[] array = ArraysParser.parseArray(arrayTypeClass, input);
        return AttributeUtils.getPrimitiveArray(array);
    }
}

