/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model.types;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ToMany;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;

public abstract class Basic<T extends Property>
extends ToMany<T> {
    private CustomTypeMarshaller customTypeMarshaller;
    private Class componentType;

    public Basic(PersistentEntity owner, MappingContext context, PropertyDescriptor descriptor) {
        super(owner, context, descriptor);
        this.initializeComponentType();
    }

    public Basic(PersistentEntity owner, MappingContext context, String name, Class type) {
        super(owner, context, name, type);
        this.initializeComponentType();
    }

    private void initializeComponentType() {
        Class type = this.getType();
        Class ownerClass = this.getOwner().getJavaClass();
        if (Map.class.isAssignableFrom(type)) {
            this.componentType = MappingUtils.getGenericTypeForMapProperty(ownerClass, this.getName(), false);
        } else if (Collection.class.isAssignableFrom(type)) {
            this.componentType = MappingUtils.getGenericTypeForProperty(ownerClass, this.getName());
        } else if (type.isArray()) {
            this.componentType = type.getComponentType();
        }
        if (this.componentType == null) {
            List<Map> maps = ClassPropertyFetcher.getStaticPropertyValuesFromInheritanceHierarchy(ownerClass, "hasMany", Map.class);
            for (Map map : maps) {
                Object o;
                if (!map.containsKey(this.getName()) || !((o = map.get(this.getName())) instanceof Class)) continue;
                this.componentType = (Class)o;
                break;
            }
            if (this.componentType == null) {
                this.componentType = Object.class;
            }
        }
    }

    public Class getComponentType() {
        return this.componentType;
    }

    @Override
    public Association getInverseSide() {
        return null;
    }

    @Override
    public boolean isOwningSide() {
        return true;
    }

    @Override
    public void setOwningSide(boolean owningSide) {
    }

    @Override
    public PersistentEntity getAssociatedEntity() {
        return null;
    }

    public CustomTypeMarshaller getCustomTypeMarshaller() {
        return this.customTypeMarshaller;
    }

    public void setCustomTypeMarshaller(CustomTypeMarshaller customTypeMarshaller) {
        this.customTypeMarshaller = customTypeMarshaller;
    }
}

