#! /bin/sh
#
# Copyright by The HDF Group.
# All rights reserved.
#
# This file is part of HDF5.  The full HDF5 copyright notice, including
# terms governing use, modification, and redistribution, is contained in
# the COPYING file, which can be found at the root of the source code
# distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.
# If you do not have access to either file, you may request a copy from
# help@hdfgroup.org.

#
#  This file:  run-hlfortran-ex.sh
# Written by:  Larry Knox
#       Date:  May 11, 2010
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#                                                                               #
# This script will compile and run the fortran examples from source files       #
# installed in ${DESTDIR}/${prefix}/share/doc/hdf5/examples/fortran using h5fc or h5pfc.  The        #
# order for running programs with RunTest in the MAIN section below is taken    #
# from the Makefile.  The order is important since some of the test programs    #
# use data files created by earlier test programs.  Any future additions should #
# be placed accordingly.                                                        #
#                                                                               #
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

# Initializations
EXIT_SUCCESS=0
EXIT_FAILURE=1

#
# Try to derive the path to the installation $prefix established
# by ./configure relative to the examples directory established by
# ./configure.  If successful, set `prefix_relto_examplesdir` to the
# relative path.  Otherwise, set `prefix_relto_examplesdir` to the
# absolute installation $prefix.
#
# This script uses the value of `prefix` in the user's environment, if
# it is set, below.  The content of $() is evaluated in a sub-shell, so
# if `prefix` is set in the user's environment, the shell statements in
# $() won't clobbered it.
#
prefix_relto_examplesdir=$(
prefix=/usr
examplesdir=${DESTDIR}/${prefix}/share/doc/hdf5/examples
if [ ${examplesdir##${prefix}/} != ${examplesdir} ]; then
	echo $(echo ${examplesdir##${prefix}/} | \
	    sed 's,[^/][^/]*,..,g')
else
	echo $prefix
fi
)

# Where the tool is installed.
# default is relative path to installed location of the tools
prefix="${prefix:-../${prefix_relto_examplesdir}}"
PARALLEL=yes             # Am I in parallel mode?
AR="ar"
RANLIB="ranlib"
if [ "$PARALLEL" = no ]; then
    H5TOOL="h5fc"               # The tool name
else
    H5TOOL="h5pfc"               # The tool name
fi
H5TOOL_BIN="${prefix}/bin/${H5TOOL}"   # The path of the tool binary


#### Run test ####
RunTest()
{
    TEST_EXEC=$1
    Test=$1".f90"

    echo
    echo "#################  $1  #################"
    ${H5TOOL_BIN} -o $TEST_EXEC $Test
    if [ $? -ne 0 ]
    then
        echo "messed up compiling $Test"
        exit 1
    fi
    ./$TEST_EXEC
}

##################  MAIN  ##################

# Run tests
if [ $? -eq 0 ]
then
    if (RunTest h5_crtdat &&\
        rm h5_crtdat &&\
        RunTest h5_rdwt &&\
        rm h5_rdwt &&\
        RunTest h5_crtatt &&\
        rm h5_crtatt &&\
        RunTest h5_crtgrp &&\
        rm h5_crtgrp &&\
        RunTest h5_crtgrpar &&\
        rm h5_crtgrpar &&\
        RunTest h5_crtgrpd &&\
        rm h5_crtgrpd &&\
        RunTest h5_extend &&\
        rm h5_extend &&\
        RunTest h5_subset &&\
        rm h5_subset &&\
        RunTest h5_cmprss &&\
        rm h5_cmprss &&\
        RunTest hyperslab &&\
        rm hyperslab &&\
        RunTest selectele &&\
        rm selectele &&\
        RunTest refobjexample &&\
        rm refobjexample &&\
        RunTest refregexample &&\
        rm refregexample &&\
        RunTest mountexample &&\
        rm mountexample &&\
        RunTest compound &&\
        rm compound &&\
        RunTest rwdset_fortran2003 &&\
        rm rwdset_fortran2003 &&\
        RunTest nested_derived_type &&\
        rm nested_derived_type &&\
        RunTest compound_fortran2003 &&\
        rm compound_fortran2003 &&\
        RunTest compound_complex_fortran2003 &&\
        rm compound_complex_fortran2003); then
        EXIT_VALUE=${EXIT_SUCCESS}
    else
        EXIT_VALUE=${EXIT_FAILURE}
    fi
fi

# Cleanup
rm *.o
rm *.h5
echo

exit $EXIT_VALUE

