/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;

public class Quat {
    public float q0 = 1.0f;
    public float q1;
    public float q2;
    public float q3;
    private M3 mat;
    private static final P4 qZero = new P4();
    private static final double RAD_PER_DEG = Math.PI / 180;

    public static Quat newQ(Quat q) {
        Quat q1 = new Quat();
        q1.set(q);
        return q1;
    }

    public static Quat newVA(T3 v, float theta) {
        Quat q = new Quat();
        q.setTA(v, theta);
        return q;
    }

    public static Quat newM(M3 mat) {
        Quat q = new Quat();
        q.setM(M3.newM3(mat));
        return q;
    }

    public static Quat newAA(A4 a) {
        Quat q = new Quat();
        q.setAA(a);
        return q;
    }

    public static Quat newP4(P4 pt) {
        Quat q = new Quat();
        q.setP4(pt);
        return q;
    }

    public static Quat new4(float q1, float q2, float q3, float q0) {
        Quat q = new Quat();
        if (q0 < -1.0f) {
            q.q0 = -1.0f;
            return q;
        }
        if (q0 > 1.0f) {
            q.q0 = 1.0f;
            return q;
        }
        q.q0 = q0;
        q.q1 = q1;
        q.q2 = q2;
        q.q3 = q3;
        return q;
    }

    public void set(Quat q) {
        this.q0 = q.q0;
        this.q1 = q.q1;
        this.q2 = q.q2;
        this.q3 = q.q3;
    }

    private void setP4(P4 pt) {
        float factor;
        float f = factor = pt == null ? 0.0f : pt.distance4(qZero);
        if (factor == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        this.q0 = pt.w / factor;
        this.q1 = pt.x / factor;
        this.q2 = pt.y / factor;
        this.q3 = pt.z / factor;
    }

    public void setTA(T3 pt, float theta) {
        if (pt.x == 0.0f && pt.y == 0.0f && pt.z == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        double fact = Math.sin((double)(theta / 2.0f) * (Math.PI / 180)) / Math.sqrt(pt.x * pt.x + pt.y * pt.y + pt.z * pt.z);
        this.q0 = (float)Math.cos((double)(theta / 2.0f) * (Math.PI / 180));
        this.q1 = (float)((double)pt.x * fact);
        this.q2 = (float)((double)pt.y * fact);
        this.q3 = (float)((double)pt.z * fact);
    }

    public void setAA(A4 a) {
        A4 aa = A4.newAA(a);
        if (aa.angle == 0.0f) {
            aa.y = 1.0f;
        }
        this.setM(new M3().setAA(aa));
    }

    private void setM(M3 mat) {
        double z;
        double y;
        double x;
        double w;
        this.mat = mat;
        double trace = mat.m00 + mat.m11 + mat.m22;
        if (trace >= 0.5) {
            w = Math.sqrt(1.0 + trace);
            x = (double)(mat.m21 - mat.m12) / w;
            y = (double)(mat.m02 - mat.m20) / w;
            z = (double)(mat.m10 - mat.m01) / w;
        } else {
            double d;
            double temp = (double)(mat.m00 + mat.m00) - trace;
            if (d >= 0.5) {
                x = Math.sqrt(1.0 + temp);
                w = (double)(mat.m21 - mat.m12) / x;
                y = (double)(mat.m10 + mat.m01) / x;
                z = (double)(mat.m20 + mat.m02) / x;
            } else {
                temp = (double)(mat.m11 + mat.m11) - trace;
                if (temp >= 0.5 || mat.m11 > mat.m22) {
                    y = Math.sqrt(1.0 + temp);
                    w = (double)(mat.m02 - mat.m20) / y;
                    x = (double)(mat.m10 + mat.m01) / y;
                    z = (double)(mat.m21 + mat.m12) / y;
                } else {
                    z = Math.sqrt(1.0 + (double)mat.m22 + (double)mat.m22 - trace);
                    w = (double)(mat.m10 - mat.m01) / z;
                    x = (double)(mat.m20 + mat.m02) / z;
                    y = (double)(mat.m21 + mat.m12) / z;
                }
            }
        }
        this.q0 = (float)(w * 0.5);
        this.q1 = (float)(x * 0.5);
        this.q2 = (float)(y * 0.5);
        this.q3 = (float)(z * 0.5);
    }

    public void setRef(Quat qref) {
        if (qref == null) {
            this.mul(this.getFixFactor());
            return;
        }
        if (this.dot(qref) >= 0.0f) {
            return;
        }
        this.q0 *= -1.0f;
        this.q1 *= -1.0f;
        this.q2 *= -1.0f;
        this.q3 *= -1.0f;
    }

    public static final Quat getQuaternionFrame(P3 center, T3 x, T3 xy) {
        V3 vA = V3.newV(x);
        V3 vB = V3.newV(xy);
        if (center != null) {
            vA.sub(center);
            vB.sub(center);
        }
        return Quat.getQuaternionFrameV(vA, vB, null, false);
    }

    public static final Quat getQuaternionFrameV(V3 vA, V3 vB, V3 vC, boolean yBased) {
        if (vC == null) {
            vC = new V3();
            vC.cross(vA, vB);
            if (yBased) {
                vA.cross(vB, vC);
            }
        }
        V3 vBprime = new V3();
        vBprime.cross(vC, vA);
        vA.normalize();
        vBprime.normalize();
        vC.normalize();
        M3 mat = new M3();
        mat.setColumnV(0, vA);
        mat.setColumnV(1, vBprime);
        mat.setColumnV(2, vC);
        Quat q = Quat.newM(mat);
        return q;
    }

    public M3 getMatrix() {
        if (this.mat == null) {
            this.setMatrix();
        }
        return this.mat;
    }

    private void setMatrix() {
        this.mat = new M3();
        this.mat.m00 = this.q0 * this.q0 + this.q1 * this.q1 - this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m01 = 2.0f * this.q1 * this.q2 - 2.0f * this.q0 * this.q3;
        this.mat.m02 = 2.0f * this.q1 * this.q3 + 2.0f * this.q0 * this.q2;
        this.mat.m10 = 2.0f * this.q1 * this.q2 + 2.0f * this.q0 * this.q3;
        this.mat.m11 = this.q0 * this.q0 - this.q1 * this.q1 + this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m12 = 2.0f * this.q2 * this.q3 - 2.0f * this.q0 * this.q1;
        this.mat.m20 = 2.0f * this.q1 * this.q3 - 2.0f * this.q0 * this.q2;
        this.mat.m21 = 2.0f * this.q2 * this.q3 + 2.0f * this.q0 * this.q1;
        this.mat.m22 = this.q0 * this.q0 - this.q1 * this.q1 - this.q2 * this.q2 + this.q3 * this.q3;
    }

    public Quat add(float x) {
        return Quat.newVA(this.getNormal(), this.getTheta() + x);
    }

    public Quat mul(float x) {
        return x == 1.0f ? Quat.new4(this.q1, this.q2, this.q3, this.q0) : Quat.newVA(this.getNormal(), this.getTheta() * x);
    }

    public Quat mulQ(Quat p) {
        return Quat.new4(this.q0 * p.q1 + this.q1 * p.q0 + this.q2 * p.q3 - this.q3 * p.q2, this.q0 * p.q2 + this.q2 * p.q0 + this.q3 * p.q1 - this.q1 * p.q3, this.q0 * p.q3 + this.q3 * p.q0 + this.q1 * p.q2 - this.q2 * p.q1, this.q0 * p.q0 - this.q1 * p.q1 - this.q2 * p.q2 - this.q3 * p.q3);
    }

    public Quat div(Quat p) {
        return this.mulQ(p.inv());
    }

    public Quat divLeft(Quat p) {
        return this.inv().mulQ(p);
    }

    public float dot(Quat q) {
        return this.q0 * q.q0 + this.q1 * q.q1 + this.q2 * q.q2 + this.q3 * q.q3;
    }

    public Quat inv() {
        return Quat.new4(-this.q1, -this.q2, -this.q3, this.q0);
    }

    public Quat negate() {
        return Quat.new4(-this.q1, -this.q2, -this.q3, -this.q0);
    }

    private float getFixFactor() {
        return this.q0 < 0.0f || this.q0 == 0.0f && (this.q1 < 0.0f || this.q1 == 0.0f && (this.q2 < 0.0f || this.q2 == 0.0f && this.q3 < 0.0f)) ? -1 : 1;
    }

    public V3 getVector(int i) {
        return this.getVectorScaled(i, 1.0f);
    }

    public V3 getVectorScaled(int i, float scale) {
        if (i == -1) {
            return V3.new3(this.q1 * (scale *= this.getFixFactor()), this.q2 * scale, this.q3 * scale);
        }
        if (this.mat == null) {
            this.setMatrix();
        }
        V3 v = new V3();
        this.mat.getColumnV(i, v);
        if (scale != 1.0f) {
            v.scale(scale);
        }
        return v;
    }

    public V3 getNormal() {
        V3 v = Quat.getRawNormal(this);
        v.scale(this.getFixFactor());
        return v;
    }

    private static V3 getRawNormal(Quat q) {
        V3 v = V3.new3(q.q1, q.q2, q.q3);
        if (v.length() == 0.0f) {
            return V3.new3(0.0f, 0.0f, 1.0f);
        }
        v.normalize();
        return v;
    }

    public float getTheta() {
        return (float)(Math.acos(Math.abs(this.q0)) * 2.0 * 180.0 / Math.PI);
    }

    public float getThetaRadians() {
        return (float)(Math.acos(Math.abs(this.q0)) * 2.0);
    }

    public V3 getNormalDirected(V3 v0) {
        V3 v = this.getNormal();
        if (v.x * v0.x + v.y * v0.y + v.z * v0.z < 0.0f) {
            v.scale(-1.0f);
        }
        return v;
    }

    public V3 get3dProjection(V3 v3d) {
        v3d.set(this.q1, this.q2, this.q3);
        return v3d;
    }

    public P4 getThetaDirected(P4 axisAngle) {
        float theta = this.getTheta();
        V3 v = this.getNormal();
        if (axisAngle.x * this.q1 + axisAngle.y * this.q2 + axisAngle.z * this.q3 < 0.0f) {
            v.scale(-1.0f);
            theta = -theta;
        }
        axisAngle.set4(v.x, v.y, v.z, theta);
        return axisAngle;
    }

    public float getThetaDirectedV(V3 vector) {
        float theta = this.getTheta();
        V3 v = this.getNormal();
        if (vector.x * this.q1 + vector.y * this.q2 + vector.z * this.q3 < 0.0f) {
            v.scale(-1.0f);
            theta = -theta;
        }
        return theta;
    }

    public P4 toPoint4f() {
        return P4.new4(this.q1, this.q2, this.q3, this.q0);
    }

    public A4 toAxisAngle4f() {
        double theta = 2.0 * Math.acos(Math.abs(this.q0));
        double sinTheta2 = Math.sin(theta / 2.0);
        V3 v = this.getNormal();
        if (sinTheta2 < 0.0) {
            v.scale(-1.0f);
            theta = Math.PI - theta;
        }
        return A4.newVA(v, (float)theta);
    }

    public T3 transform2(T3 pt, T3 ptNew) {
        if (this.mat == null) {
            this.setMatrix();
        }
        this.mat.rotate2(pt, ptNew);
        return ptNew;
    }

    public Quat leftDifference(Quat q2) {
        Quat q2adjusted = this.dot(q2) < 0.0f ? q2.negate() : q2;
        return this.inv().mulQ(q2adjusted);
    }

    public Quat rightDifference(Quat q2) {
        Quat q2adjusted = this.dot(q2) < 0.0f ? q2.negate() : q2;
        return this.mulQ(q2adjusted.inv());
    }

    public String toString() {
        return "{" + this.q1 + " " + this.q2 + " " + this.q3 + " " + this.q0 + "}";
    }

    public static Quat[] div(Quat[] data1, Quat[] data2, int nMax, boolean isRelative) {
        int n;
        if (data1 == null || data2 == null || (n = Math.min(data1.length, data2.length)) == 0) {
            return null;
        }
        if (nMax > 0 && n > nMax) {
            n = nMax;
        }
        Quat[] dqs = new Quat[n];
        for (int i = 0; i < n; ++i) {
            if (data1[i] == null || data2[i] == null) {
                return null;
            }
            dqs[i] = isRelative ? data1[i].divLeft(data2[i]) : data1[i].div(data2[i]);
        }
        return dqs;
    }

    public static Quat sphereMean(Quat[] data, float[] retStddev, float criterion) {
        if (data == null || data.length == 0) {
            return new Quat();
        }
        if (retStddev == null) {
            retStddev = new float[1];
        }
        if (data.length == 1) {
            retStddev[0] = 0.0f;
            return Quat.newQ(data[0]);
        }
        float diff = Float.MAX_VALUE;
        float lastStddev = Float.MAX_VALUE;
        Quat qMean = Quat.simpleAverage(data);
        int maxIter = 100;
        int iter = 0;
        while (diff > criterion && lastStddev != 0.0f && iter < maxIter) {
            qMean = Quat.newMean(data, qMean);
            retStddev[0] = Quat.stdDev(data, qMean);
            diff = Math.abs(retStddev[0] - lastStddev);
            lastStddev = retStddev[0];
        }
        return qMean;
    }

    private static Quat simpleAverage(Quat[] ndata) {
        V3 mean = V3.new3(0.0f, 0.0f, 1.0f);
        V3 v = ndata[0].getNormal();
        mean.add(v);
        int i = ndata.length;
        while (--i >= 0) {
            mean.add(ndata[i].getNormalDirected(mean));
        }
        mean.sub(v);
        mean.normalize();
        float f = 0.0f;
        int i2 = ndata.length;
        while (--i2 >= 0) {
            f += Math.abs(ndata[i2].get3dProjection(v).dot(mean));
        }
        if (f != 0.0f) {
            mean.scale(f / (float)ndata.length);
        }
        if (Float.isNaN(f = (float)Math.sqrt(1.0f - mean.lengthSquared()))) {
            f = 0.0f;
        }
        return Quat.newP4(P4.new4(mean.x, mean.y, mean.z, f));
    }

    private static Quat newMean(Quat[] data, Quat mean) {
        V3 sum = new V3();
        int i = data.length;
        while (--i >= 0) {
            Quat q = data[i];
            Quat dq = q.div(mean);
            V3 v = dq.getNormal();
            v.scale(dq.getTheta());
            sum.add(v);
        }
        sum.scale(1.0f / (float)data.length);
        Quat dqMean = Quat.newVA(sum, sum.length());
        return dqMean.mulQ(mean);
    }

    private static float stdDev(Quat[] data, Quat mean) {
        int n;
        double sum2 = 0.0;
        int i = n = data.length;
        while (--i >= 0) {
            float theta = data[i].div(mean).getTheta();
            sum2 += (double)(theta * theta);
        }
        return (float)Math.sqrt(sum2 / (double)n);
    }

    public float[] getEulerZYZ() {
        if (this.q1 == 0.0f && this.q2 == 0.0f) {
            float theta = this.getTheta();
            return new float[]{this.q3 < 0.0f ? -theta : theta, 0.0f, 0.0f};
        }
        double rA = Math.atan2(2.0f * (this.q2 * this.q3 + this.q0 * this.q1), 2.0f * (-this.q1 * this.q3 + this.q0 * this.q2));
        double rB = Math.acos(this.q3 * this.q3 - this.q2 * this.q2 - this.q1 * this.q1 + this.q0 * this.q0);
        double rG = Math.atan2(2.0f * (this.q2 * this.q3 - this.q0 * this.q1), 2.0f * (this.q0 * this.q2 + this.q1 * this.q3));
        return new float[]{(float)(rA / (Math.PI / 180)), (float)(rB / (Math.PI / 180)), (float)(rG / (Math.PI / 180))};
    }

    public float[] getEulerZXZ() {
        if (this.q1 == 0.0f && this.q2 == 0.0f) {
            float theta = this.getTheta();
            return new float[]{this.q3 < 0.0f ? -theta : theta, 0.0f, 0.0f};
        }
        double rA = Math.atan2(2.0f * (this.q1 * this.q3 - this.q0 * this.q2), 2.0f * (this.q0 * this.q1 + this.q2 * this.q3));
        double rB = Math.acos(this.q3 * this.q3 - this.q2 * this.q2 - this.q1 * this.q1 + this.q0 * this.q0);
        double rG = Math.atan2(2.0f * (this.q1 * this.q3 + this.q0 * this.q2), 2.0f * (-this.q2 * this.q3 + this.q0 * this.q1));
        return new float[]{(float)(rA / (Math.PI / 180)), (float)(rB / (Math.PI / 180)), (float)(rG / (Math.PI / 180))};
    }
}

