/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.fir;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.lightTree.fir.modifier.Modifier;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirQualifierPartImpl;
import org.jetbrains.kotlin.fir.types.impl.FirUserTypeRefImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\tH\u0002J\u0006\u0010\u001f\u001a\u00020\tJ\u0006\u0010 \u001a\u00020\tJ\b\u0010!\u001a\u00020\tH\u0002J\u0006\u0010\"\u001a\u00020\tJ\b\u0010#\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/fir/ClassWrapper;", "", "className", "Lorg/jetbrains/kotlin/name/Name;", "modifiers", "Lorg/jetbrains/kotlin/fir/lightTree/fir/modifier/Modifier;", "classKind", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "hasPrimaryConstructor", "", "hasSecondaryConstructor", "delegatedSelfTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "delegatedSuperTypeRef", "superTypeCallEntry", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/fir/lightTree/fir/modifier/Modifier;Lorg/jetbrains/kotlin/descriptors/ClassKind;ZZLorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Ljava/util/List;)V", "getDelegatedSelfTypeRef", "()Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "getDelegatedSuperTypeRef", "getHasPrimaryConstructor", "()Z", "getHasSecondaryConstructor", "getSuperTypeCallEntry", "()Ljava/util/List;", "defaultConstructorVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "getFirUserTypeFromClassName", "Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;", "isEnum", "isInner", "isInterface", "isObject", "isObjectLiteral", "isSealed", "lightTree"})
public final class ClassWrapper {
    private final Name className;
    private final Modifier modifiers;
    private final ClassKind classKind;
    private final boolean hasPrimaryConstructor;
    private final boolean hasSecondaryConstructor;
    @NotNull
    private final FirTypeRef delegatedSelfTypeRef;
    @NotNull
    private final FirTypeRef delegatedSuperTypeRef;
    @NotNull
    private final List<FirExpression> superTypeCallEntry;

    public final boolean isObjectLiteral() {
        return Intrinsics.areEqual(this.className, SpecialNames.NO_NAME_PROVIDED) && this.isObject();
    }

    private final boolean isObject() {
        return this.classKind == ClassKind.OBJECT;
    }

    private final boolean isSealed() {
        return this.modifiers.hasModality(Modality.SEALED);
    }

    private final boolean isEnum() {
        return this.modifiers.isEnum();
    }

    public final boolean isInterface() {
        return this.classKind == ClassKind.INTERFACE;
    }

    public final boolean isInner() {
        return this.modifiers.isInner();
    }

    @NotNull
    public final Visibility defaultConstructorVisibility() {
        Visibility visibility;
        if (this.isObject() || this.isEnum()) {
            Visibility visibility2 = Visibilities.PRIVATE;
            visibility = visibility2;
            Intrinsics.checkExpressionValueIsNotNull(visibility2, "Visibilities.PRIVATE");
        } else if (this.isSealed()) {
            Visibility visibility3 = Visibilities.PUBLIC;
            visibility = visibility3;
            Intrinsics.checkExpressionValueIsNotNull(visibility3, "Visibilities.PUBLIC");
        } else {
            Visibility visibility4 = Visibilities.UNKNOWN;
            visibility = visibility4;
            Intrinsics.checkExpressionValueIsNotNull(visibility4, "Visibilities.UNKNOWN");
        }
        return visibility;
    }

    @NotNull
    public final FirUserTypeRef getFirUserTypeFromClassName() {
        FirQualifierPartImpl qualifier = new FirQualifierPartImpl(this.className);
        FirUserTypeRefImpl firUserTypeRefImpl = new FirUserTypeRefImpl(null, false);
        boolean bl = false;
        boolean bl2 = false;
        FirUserTypeRefImpl $this$apply = firUserTypeRefImpl;
        boolean bl3 = false;
        $this$apply.getQualifier().add(qualifier);
        return firUserTypeRefImpl;
    }

    public final boolean getHasPrimaryConstructor() {
        return this.hasPrimaryConstructor;
    }

    public final boolean getHasSecondaryConstructor() {
        return this.hasSecondaryConstructor;
    }

    @NotNull
    public final FirTypeRef getDelegatedSelfTypeRef() {
        return this.delegatedSelfTypeRef;
    }

    @NotNull
    public final FirTypeRef getDelegatedSuperTypeRef() {
        return this.delegatedSuperTypeRef;
    }

    @NotNull
    public final List<FirExpression> getSuperTypeCallEntry() {
        return this.superTypeCallEntry;
    }

    public ClassWrapper(@NotNull Name className2, @NotNull Modifier modifiers2, @NotNull ClassKind classKind, boolean hasPrimaryConstructor, boolean hasSecondaryConstructor, @NotNull FirTypeRef delegatedSelfTypeRef, @NotNull FirTypeRef delegatedSuperTypeRef, @NotNull List<FirExpression> superTypeCallEntry) {
        Intrinsics.checkParameterIsNotNull(className2, "className");
        Intrinsics.checkParameterIsNotNull(modifiers2, "modifiers");
        Intrinsics.checkParameterIsNotNull((Object)classKind, "classKind");
        Intrinsics.checkParameterIsNotNull(delegatedSelfTypeRef, "delegatedSelfTypeRef");
        Intrinsics.checkParameterIsNotNull(delegatedSuperTypeRef, "delegatedSuperTypeRef");
        Intrinsics.checkParameterIsNotNull(superTypeCallEntry, "superTypeCallEntry");
        this.className = className2;
        this.modifiers = modifiers2;
        this.classKind = classKind;
        this.hasPrimaryConstructor = hasPrimaryConstructor;
        this.hasSecondaryConstructor = hasSecondaryConstructor;
        this.delegatedSelfTypeRef = delegatedSelfTypeRef;
        this.delegatedSuperTypeRef = delegatedSuperTypeRef;
        this.superTypeCallEntry = superTypeCallEntry;
    }
}

