/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;

public abstract class AbstractDashRule
extends Rule {
    private final List<PatternRule> dashRules;

    public AbstractDashRule(List<PatternRule> dashRules) throws IOException {
        this.dashRules = Objects.requireNonNull(dashRules);
    }

    @Override
    public String getId() {
        return "DASH_RULE";
    }

    @Override
    public abstract String getDescription();

    @Override
    public int estimateContextForSureMatch() {
        return 2;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        for (PatternRule dashRule : this.dashRules) {
            for (RuleMatch match : dashRule.match(sentence)) {
                RuleMatch rm = new RuleMatch(this, match.getSentence(), match.getFromPos(), match.getToPos(), match.getMessage(), match.getShortMessage(), false, "");
                matches.add(rm);
            }
        }
        return matches.toArray(new RuleMatch[0]);
    }

    protected static List<PatternRule> loadCompoundFile(String path, String msg, Language lang) {
        ArrayList<PatternRule> rules = new ArrayList<PatternRule>();
        List<String> lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        int counter = 0;
        for (String line : lines) {
            ++counter;
            if (line.isEmpty() || line.charAt(0) == '#' || line.endsWith("+")) continue;
            if (line.endsWith("*")) {
                line = AbstractDashRule.removeLastCharacter(line);
            }
            ArrayList<PatternToken> tokList = new ArrayList<PatternToken>();
            String[] tokens = line.split("-");
            int tokenCounter = 0;
            for (String token : tokens) {
                tokList.add(new PatternToken(token, true, false, false));
                if (++tokenCounter >= tokens.length) continue;
                tokList.add(new PatternToken("[\u2014\u2013]", false, true, false));
            }
            PatternRule dashRule = new PatternRule("DASH_RULE" + counter, lang, tokList, "", msg + "<suggestion>" + line.replaceAll("[\u2013\u2014]", "-") + "</suggestion>.", line.replaceAll("[\u2013\u2014]", "-"));
            rules.add(dashRule);
        }
        return rules;
    }

    private static String removeLastCharacter(String str) {
        return str.substring(0, str.length() - 1);
    }
}

