/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.synthesis.ManualSynthesizer;
import org.languagetool.synthesis.Soros;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.SynthesizerTools;

public class BaseSynthesizer
implements Synthesizer {
    protected volatile List<String> possibleTags;
    private final String tagFileName;
    private final String resourceFileName;
    private final IStemmer stemmer;
    private final ManualSynthesizer manualSynthesizer;
    private final ManualSynthesizer removalSynthesizer;
    private final String sorosFileName;
    private final Soros numberSpeller;
    public final String SPELLNUMBER_TAG = "_spell_number_";
    private volatile Dictionary dictionary;

    public BaseSynthesizer(String sorosFileName, String resourceFileName, String tagFileName, Language lang) {
        block29: {
            this.SPELLNUMBER_TAG = "_spell_number_";
            this.resourceFileName = resourceFileName;
            this.tagFileName = tagFileName;
            this.stemmer = this.createStemmer();
            this.sorosFileName = sorosFileName;
            this.numberSpeller = this.createNumberSpeller(lang.getShortCode());
            try {
                String path = "/" + lang.getShortCode() + "/added.txt";
                if (JLanguageTool.getDataBroker().resourceExists(path)) {
                    try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(path);){
                        this.manualSynthesizer = new ManualSynthesizer(stream);
                    }
                } else {
                    this.manualSynthesizer = null;
                }
                String removalPath = "/" + lang.getShortCode() + "/removed.txt";
                if (JLanguageTool.getDataBroker().resourceExists(removalPath)) {
                    try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(removalPath);){
                        this.removalSynthesizer = new ManualSynthesizer(stream);
                        break block29;
                    }
                }
                this.removalSynthesizer = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public BaseSynthesizer(String resourceFileName, String tagFileName, Language lang) {
        this(null, resourceFileName, tagFileName, lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dictionary getDictionary() throws IOException {
        Dictionary dict = this.dictionary;
        if (dict == null) {
            BaseSynthesizer baseSynthesizer = this;
            synchronized (baseSynthesizer) {
                dict = this.dictionary;
                if (dict == null) {
                    URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(this.resourceFileName);
                    this.dictionary = dict = Dictionary.read((URL)url);
                }
            }
        }
        return dict;
    }

    protected IStemmer createStemmer() {
        try {
            return new DictionaryLookup(this.getDictionary());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load dictionary", e);
        }
    }

    private Soros createNumberSpeller(String langcode) {
        Soros s = null;
        try {
            URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(this.sorosFileName);
            BufferedReader f = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            StringBuffer st = new StringBuffer();
            String line = null;
            while ((line = f.readLine()) != null) {
                st.append(line);
                st.append("\n");
            }
            s = new Soros(new String(st), langcode);
        }
        catch (Exception e) {
            return null;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookup(String lemma, String posTag, List<String> results) {
        List<String> removeForms;
        List<String> manualForms;
        BaseSynthesizer baseSynthesizer = this;
        synchronized (baseSynthesizer) {
            List wordForms = this.stemmer.lookup((CharSequence)(lemma + "|" + posTag));
            for (WordData wd : wordForms) {
                results.add(wd.getStem().toString());
            }
        }
        if (this.manualSynthesizer != null && (manualForms = this.manualSynthesizer.lookup(lemma, posTag)) != null) {
            results.addAll(manualForms);
        }
        if (this.removalSynthesizer != null && (removeForms = this.removalSynthesizer.lookup(lemma, posTag)) != null) {
            results.removeAll(removeForms);
        }
    }

    @Override
    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        if (posTag.equals("_spell_number_")) {
            String[] strArray = new String[]{this.getSpelledNumber(token.getToken())};
            return strArray;
        }
        ArrayList<String> wordForms = new ArrayList<String>();
        this.lookup(token.getLemma(), posTag, wordForms);
        return wordForms.toArray(new String[0]);
    }

    @Override
    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        if (posTagRegExp) {
            this.initPossibleTags();
            Pattern p = Pattern.compile(posTag);
            ArrayList<String> results = new ArrayList<String>();
            for (String tag : this.possibleTags) {
                Matcher m = p.matcher(tag);
                if (!m.matches()) continue;
                this.lookup(token.getLemma(), tag, results);
            }
            return results.toArray(new String[0]);
        }
        return this.synthesize(token, posTag);
    }

    @Override
    public String getPosTagCorrection(String posTag) {
        return posTag;
    }

    public IStemmer getStemmer() {
        return this.stemmer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPossibleTags() throws IOException {
        List<String> tags = this.possibleTags;
        if (tags == null) {
            BaseSynthesizer baseSynthesizer = this;
            synchronized (baseSynthesizer) {
                tags = this.possibleTags;
                if (tags == null) {
                    try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(this.tagFileName);){
                        this.possibleTags = SynthesizerTools.loadWords(stream);
                    }
                }
                if (this.manualSynthesizer != null) {
                    for (String tag : this.manualSynthesizer.getPossibleTags()) {
                        if (this.possibleTags.contains(tag)) continue;
                        this.possibleTags.add(tag);
                    }
                }
            }
        }
    }

    @Override
    public String getSpelledNumber(String arabicNumeral) {
        if (this.numberSpeller != null) {
            return this.numberSpeller.run(arabicNumeral);
        }
        return arabicNumeral;
    }
}

