/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import org.hsqldb.Database;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.scriptio.ScriptWriterText;

public abstract class ScriptReaderBase {
    public static final int ANY_STATEMENT = 1;
    public static final int DELETE_STATEMENT = 2;
    public static final int INSERT_STATEMENT = 3;
    public static final int COMMIT_STATEMENT = 4;
    public static final int SESSION_ID = 5;
    public static final int SET_SCHEMA_STATEMENT = 6;
    public static final int SET_FILES_CHECK_STATEMENT = 7;
    Database database;
    String fileNamePath;
    long lineCount;
    int statementType;
    int sessionNumber;
    boolean sessionChanged;
    Object[] rowData;
    long sequenceValue;
    String rawStatement;
    String statement;
    Table currentTable;
    PersistentStore currentStore;
    NumberSequence currentSequence;
    String currentSchema;
    ScriptWriterText scrwriter;

    ScriptReaderBase(Database database, String string) {
        this.database = database;
        this.fileNamePath = string;
    }

    public void readAll(Session session) {
        this.readDDL(session);
        this.readExistingData(session);
    }

    protected abstract void readDDL(Session var1);

    protected abstract void readExistingData(Session var1);

    public abstract boolean readLoggedStatement(Session var1);

    public String getFileNamePath() {
        return this.fileNamePath;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public int getSessionNumber() {
        return this.sessionNumber;
    }

    public Object[] getData() {
        return this.rowData;
    }

    public String getLoggedStatement() {
        return this.statement;
    }

    public Table getCurrentTable() {
        return this.currentTable;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public long getLineNumber() {
        return this.lineCount;
    }

    public abstract void close();
}

