/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.LoadableInt;
import com.gitlab.pdftk_java.LoadableRectangle;
import pdftk.com.lowagie.text.Rectangle;

class PdfPageMedia {
    static final String PREFIX = "PageMedia";
    static final String BEGIN_MARK = "PageMediaBegin";
    static final String NUMBER_LABEL = "PageMediaNumber:";
    static final String ROTATION_LABEL = "PageMediaRotation:";
    static final String RECT_LABEL = "PageMediaRect:";
    static final String DIMENSIONS_LABEL = "PageMediaDimensions:";
    static final String CROP_LABEL = "PageMediaCropRect:";
    int m_number = -1;
    int m_rotation = -1;
    Rectangle m_rect = null;
    Rectangle m_crop = null;

    PdfPageMedia() {
    }

    boolean valid() {
        if (this.m_rotation >= 0 && this.m_rotation % 90 != 0) {
            return false;
        }
        return this.m_number > 0 && (this.m_rotation >= 0 || this.m_rect != null || this.m_crop != null);
    }

    public String toString() {
        StringBuilder ss = new StringBuilder();
        ss.append(BEGIN_MARK + System.lineSeparator());
        ss.append("PageMediaNumber: " + this.m_number + System.lineSeparator());
        if (this.m_rotation != -1) {
            ss.append("PageMediaRotation: " + this.m_rotation + System.lineSeparator());
        }
        if (this.m_rect != null) {
            ss.append("PageMediaRect: " + LoadableRectangle.position(this.m_rect) + System.lineSeparator());
            ss.append("PageMediaDimensions: " + LoadableRectangle.dimensions(this.m_rect) + System.lineSeparator());
            if (this.m_crop != null && !LoadableRectangle.equalPosition(this.m_rect, this.m_crop)) {
                ss.append("PageMediaCropRect: " + LoadableRectangle.position(this.m_crop) + System.lineSeparator());
            }
        }
        return ss.toString();
    }

    boolean loadNumber(String buff) {
        LoadableInt loader = new LoadableInt(this.m_number);
        boolean success = loader.LoadInt(buff, NUMBER_LABEL);
        this.m_number = loader.ii;
        return success;
    }

    boolean loadRotation(String buff) {
        LoadableInt loader = new LoadableInt(this.m_rotation);
        boolean success = loader.LoadInt(buff, ROTATION_LABEL);
        this.m_rotation = (loader.ii % 360 + 360) % 360;
        return success;
    }

    boolean loadRect(String buff) {
        LoadableRectangle loader = new LoadableRectangle(this.m_rect);
        boolean success = loader.LoadRectangle(buff, RECT_LABEL);
        this.m_rect = loader.rr;
        return success;
    }

    boolean loadCrop(String buff) {
        LoadableRectangle loader = new LoadableRectangle(this.m_crop);
        boolean success = loader.LoadRectangle(buff, CROP_LABEL);
        this.m_crop = loader.rr;
        return success;
    }
}

