/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.inference;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ui.util.Resettable;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class ReasonerProgressUI
implements ReasonerProgressMonitor,
Disposable,
Resettable {
    public static final long CLOSE_PROGRESS_TIMEOUT = 1000L;
    public static final int PADDING = 5;
    public static final String DEFAULT_MESSAGE = "Classifying...";
    private OWLEditorKit owlEditorKit;
    private JLabel taskLabel;
    private JProgressBar progressBar;
    private JDialog window;
    private Action cancelledAction;
    private boolean taskIsRunning = false;

    public ReasonerProgressUI(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.progressBar = new JProgressBar();
    }

    public void initWindow() {
        if (this.window != null) {
            return;
        }
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)this.progressBar, "South");
        this.taskLabel = new JLabel(DEFAULT_MESSAGE);
        panel.add((Component)this.taskLabel, "North");
        Frame parent = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this.owlEditorKit.getWorkspace()));
        this.window = new JDialog(parent, "Reasoner progress", true);
        this.window.setDefaultCloseOperation(0);
        this.cancelledAction = new AbstractAction("Cancel"){
            private static final long serialVersionUID = 3688085823398242640L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ReasonerProgressUI.this.setCancelled();
            }
        };
        JButton cancelledButton = new JButton(this.cancelledAction);
        JPanel buttonHolder = new JPanel(new FlowLayout(2, 0, 0));
        buttonHolder.add(cancelledButton);
        JPanel holderPanel = new JPanel(new BorderLayout(5, 5));
        holderPanel.add((Component)panel, "North");
        holderPanel.add((Component)buttonHolder, "South");
        holderPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.window.getContentPane().setLayout(new BorderLayout());
        this.window.getContentPane().add((Component)holderPanel, "North");
        this.window.pack();
        Dimension windowSize = this.window.getPreferredSize();
        this.window.setSize(400, windowSize.height);
        this.window.setResizable(false);
    }

    public void setCancelled() {
        SwingUtilities.invokeLater(() -> {
            this.initWindow();
            this.taskLabel.setText("Cancelled.  Waiting for reasoner to terminate...");
            this.cancelledAction.setEnabled(false);
        });
        this.owlEditorKit.getOWLModelManager().getOWLReasonerManager().killCurrentClassification();
    }

    public void reasonerTaskBusy() {
        SwingUtilities.invokeLater(() -> this.progressBar.setIndeterminate(true));
    }

    public void reasonerTaskProgressChanged(int value, int max) {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMaximum(max);
            this.progressBar.setValue(value);
        });
    }

    public void reasonerTaskStarted(String taskName) {
        if (this.taskIsRunning) {
            return;
        }
        this.taskIsRunning = true;
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(0);
        });
        this.showWindow(taskName);
    }

    public void reasonerTaskStopped() {
        if (!this.taskIsRunning) {
            return;
        }
        this.taskIsRunning = false;
        SwingUtilities.invokeLater(() -> {
            if (this.taskIsRunning) {
                return;
            }
            this.initWindow();
            if (!this.window.isVisible()) {
                return;
            }
            this.taskLabel.setText("");
            this.window.setVisible(false);
        });
    }

    private void showWindow(String message) {
        SwingUtilities.invokeLater(() -> {
            if (!this.taskIsRunning) {
                return;
            }
            this.initWindow();
            this.taskLabel.setText(message);
            if (this.window.isVisible()) {
                return;
            }
            this.cancelledAction.setEnabled(true);
            this.window.setLocationRelativeTo(this.window.getOwner());
            this.window.setVisible(true);
        });
    }

    public void reset() {
        SwingUtilities.invokeLater(() -> {
            this.initWindow();
            this.window.dispose();
        });
    }

    public void dispose() throws Exception {
        this.reset();
    }
}

