/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.facet.DocValuesAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetSortableMerger;
import org.apache.solr.search.facet.FuncSlotAcc;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UnInvertedFieldAcc;
import org.apache.solr.search.function.FieldNameValueSource;

public class PercentileAgg
extends SimpleAggValueSource {
    List<Double> percentiles;

    public PercentileAgg(ValueSource vs, List<Double> percentiles) {
        super("percentile", vs);
        this.percentiles = percentiles;
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        ValueSource vs = this.getArg();
        if (vs instanceof FieldNameValueSource) {
            String field = ((FieldNameValueSource)vs).getFieldName();
            SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(field);
            if (sf.getType().getNumberType() == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.name() + " aggregation not supported for " + sf.getType().getTypeName());
            }
            if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
                if (sf.hasDocValues()) {
                    if (sf.getType().isPointField()) {
                        return new PercentileSortedNumericAcc(fcontext, sf, numSlots);
                    }
                    return new PercentileSortedSetAcc(fcontext, sf, numSlots);
                }
                if (sf.getType().isPointField()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.name() + " aggregation not supported for PointField w/o docValues");
                }
                return new PercentileUnInvertedFieldAcc(fcontext, sf, numSlots);
            }
            vs = sf.getType().getValueSource(sf, null);
        }
        return new Acc(vs, fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PercentileAgg)) {
            return false;
        }
        PercentileAgg other = (PercentileAgg)((Object)o);
        return this.arg.equals((Object)other.arg) && this.percentiles.equals(other.percentiles);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.percentiles.hashCode();
    }

    protected Object getValueFromDigest(AVLTreeDigest digest) {
        if (digest == null) {
            return null;
        }
        if (this.percentiles.size() == 1) {
            return digest.quantile(this.percentiles.get(0) * 0.01);
        }
        ArrayList<Double> lst = new ArrayList<Double>(this.percentiles.size());
        for (Double percentile : this.percentiles) {
            double val = digest.quantile(percentile * 0.01);
            lst.add(val);
        }
        return lst;
    }

    class PercentileSortedNumericAcc
    extends BasePercentileDVAcc {
        SortedNumericDocValues values;

        public PercentileSortedNumericAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots);
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            AVLTreeDigest digest = this.digests[slot];
            if (digest == null) {
                this.digests[slot] = digest = new AVLTreeDigest(100.0);
            }
            int count = this.values.docValueCount();
            for (int i = 0; i < count; ++i) {
                double val = this.getDouble(this.values.nextValue());
                digest.add(val);
            }
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            super.setNextReader(readerContext);
            this.values = DocValues.getSortedNumeric((LeafReader)readerContext.reader(), (String)this.sf.getName());
        }

        @Override
        protected boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }

        protected double getDouble(long val) {
            switch (this.sf.getType().getNumberType()) {
                case INTEGER: 
                case LONG: 
                case DATE: {
                    return val;
                }
                case FLOAT: {
                    return NumericUtils.sortableIntToFloat((int)((int)val));
                }
                case DOUBLE: {
                    return NumericUtils.sortableLongToDouble((long)val);
                }
            }
            return 0.0;
        }
    }

    class PercentileSortedSetAcc
    extends BasePercentileDVAcc {
        SortedSetDocValues values;

        public PercentileSortedSetAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots);
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            long ord;
            AVLTreeDigest digest = this.digests[slot];
            if (digest == null) {
                this.digests[slot] = digest = new AVLTreeDigest(100.0);
            }
            while ((ord = this.values.nextOrd()) != -1L) {
                BytesRef term = this.values.lookupOrd(ord);
                Object obj = this.sf.getType().toObject(this.sf, term);
                double val = obj instanceof Date ? (double)((Date)obj).getTime() : ((Number)obj).doubleValue();
                digest.add(val);
            }
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            super.setNextReader(readerContext);
            this.values = DocValues.getSortedSet((LeafReader)readerContext.reader(), (String)this.sf.getName());
        }

        @Override
        protected boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }
    }

    class PercentileUnInvertedFieldAcc
    extends UnInvertedFieldAcc {
        protected AVLTreeDigest[] digests;
        protected ByteBuffer buf;
        protected double[] sortvals;
        private int currentSlot;

        public PercentileUnInvertedFieldAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots);
            this.digests = new AVLTreeDigest[numSlots];
        }

        @Override
        public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            this.currentSlot = slot;
            this.docToTerm.getBigTerms(doc + this.currentDocBase, this);
            this.docToTerm.getSmallTerms(doc + this.currentDocBase, this);
        }

        @Override
        public int compare(int slotA, int slotB) {
            if (this.sortvals == null) {
                this.fillSortVals();
            }
            return Double.compare(this.sortvals[slotA], this.sortvals[slotB]);
        }

        private void fillSortVals() {
            this.sortvals = new double[this.digests.length];
            double sortp = PercentileAgg.this.percentiles.get(0) * 0.01;
            for (int i = 0; i < this.digests.length; ++i) {
                AVLTreeDigest digest = this.digests[i];
                this.sortvals[i] = digest == null ? Double.NEGATIVE_INFINITY : digest.quantile(sortp);
            }
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            if (this.fcontext.isShard()) {
                return this.getShardValue(slotNum);
            }
            if (this.sortvals != null && PercentileAgg.this.percentiles.size() == 1) {
                return this.digests[slotNum] != null ? Double.valueOf(this.sortvals[slotNum]) : null;
            }
            return PercentileAgg.this.getValueFromDigest(this.digests[slotNum]);
        }

        public Object getShardValue(int slot) throws IOException {
            AVLTreeDigest digest = this.digests[slot];
            if (digest == null) {
                return null;
            }
            digest.compress();
            int sz = digest.byteSize();
            if (this.buf == null || this.buf.capacity() < sz) {
                this.buf = ByteBuffer.allocate(sz + (sz >> 1));
            } else {
                this.buf.clear();
            }
            digest.asSmallBytes(this.buf);
            byte[] arr = Arrays.copyOf(this.buf.array(), this.buf.position());
            return arr;
        }

        @Override
        public void reset() {
            this.digests = new AVLTreeDigest[this.digests.length];
            this.sortvals = null;
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.digests = resizer.resize(this.digests, null);
        }

        @Override
        public void call(int ord) {
            AVLTreeDigest digest = this.digests[this.currentSlot];
            if (digest == null) {
                this.digests[this.currentSlot] = digest = new AVLTreeDigest(100.0);
            }
            try {
                BytesRef term = this.docToTerm.lookupOrd(ord);
                Object obj = this.sf.getType().toObject(this.sf, term);
                double val = obj instanceof Date ? (double)((Date)obj).getTime() : ((Number)obj).doubleValue();
                digest.add(val);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    class Acc
    extends FuncSlotAcc {
        protected AVLTreeDigest[] digests;
        protected ByteBuffer buf;
        protected double[] sortvals;

        public Acc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots);
            this.digests = new AVLTreeDigest[numSlots];
        }

        @Override
        public void collect(int doc, int slotNum, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            if (!this.values.exists(doc)) {
                return;
            }
            double val = this.values.doubleVal(doc);
            AVLTreeDigest digest = this.digests[slotNum];
            if (digest == null) {
                this.digests[slotNum] = digest = new AVLTreeDigest(100.0);
            }
            digest.add(val);
        }

        @Override
        public int compare(int slotA, int slotB) {
            if (this.sortvals == null) {
                this.fillSortVals();
            }
            return Double.compare(this.sortvals[slotA], this.sortvals[slotB]);
        }

        private void fillSortVals() {
            this.sortvals = new double[this.digests.length];
            double sortp = PercentileAgg.this.percentiles.get(0) * 0.01;
            for (int i = 0; i < this.digests.length; ++i) {
                AVLTreeDigest digest = this.digests[i];
                this.sortvals[i] = digest == null ? Double.NEGATIVE_INFINITY : digest.quantile(sortp);
            }
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            if (this.fcontext.isShard()) {
                return this.getShardValue(slotNum);
            }
            if (this.sortvals != null && PercentileAgg.this.percentiles.size() == 1) {
                return this.digests[slotNum] != null ? Double.valueOf(this.sortvals[slotNum]) : null;
            }
            return PercentileAgg.this.getValueFromDigest(this.digests[slotNum]);
        }

        public Object getShardValue(int slot) throws IOException {
            AVLTreeDigest digest = this.digests[slot];
            if (digest == null) {
                return null;
            }
            digest.compress();
            int sz = digest.byteSize();
            if (this.buf == null || this.buf.capacity() < sz) {
                this.buf = ByteBuffer.allocate(sz + (sz >> 1));
            } else {
                this.buf.clear();
            }
            digest.asSmallBytes(this.buf);
            byte[] arr = Arrays.copyOf(this.buf.array(), this.buf.position());
            return arr;
        }

        @Override
        public void reset() {
            this.digests = new AVLTreeDigest[this.digests.length];
            this.sortvals = null;
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.digests = resizer.resize(this.digests, null);
        }
    }

    class Merger
    extends FacetSortableMerger {
        protected AVLTreeDigest digest;
        protected Double sortVal;

        Merger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            byte[] arr = (byte[])facetResult;
            if (arr == null) {
                return;
            }
            AVLTreeDigest subDigest = AVLTreeDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(arr));
            if (this.digest == null) {
                this.digest = subDigest;
            } else {
                this.digest.add((TDigest)subDigest);
            }
        }

        @Override
        public Object getMergedResult() {
            if (PercentileAgg.this.percentiles.size() == 1 && this.digest != null) {
                return this.getSortVal();
            }
            return PercentileAgg.this.getValueFromDigest(this.digest);
        }

        @Override
        public int compareTo(FacetSortableMerger other, FacetRequest.SortDirection direction) {
            return Double.compare(this.getSortVal(), ((Merger)other).getSortVal());
        }

        private Double getSortVal() {
            if (this.sortVal == null) {
                this.sortVal = this.digest == null ? Double.NEGATIVE_INFINITY : this.digest.quantile(PercentileAgg.this.percentiles.get(0) * 0.01);
            }
            return this.sortVal;
        }
    }

    abstract class BasePercentileDVAcc
    extends DocValuesAcc {
        AVLTreeDigest[] digests;
        protected ByteBuffer buf;
        double[] sortvals;

        public BasePercentileDVAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf);
            this.digests = new AVLTreeDigest[numSlots];
        }

        @Override
        public int compare(int slotA, int slotB) {
            if (this.sortvals == null) {
                this.fillSortVals();
            }
            return Double.compare(this.sortvals[slotA], this.sortvals[slotB]);
        }

        private void fillSortVals() {
            this.sortvals = new double[this.digests.length];
            double sortp = PercentileAgg.this.percentiles.get(0) * 0.01;
            for (int i = 0; i < this.digests.length; ++i) {
                AVLTreeDigest digest = this.digests[i];
                this.sortvals[i] = digest == null ? Double.NEGATIVE_INFINITY : digest.quantile(sortp);
            }
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            if (this.fcontext.isShard()) {
                return this.getShardValue(slotNum);
            }
            if (this.sortvals != null && PercentileAgg.this.percentiles.size() == 1) {
                return this.digests[slotNum] != null ? Double.valueOf(this.sortvals[slotNum]) : null;
            }
            return PercentileAgg.this.getValueFromDigest(this.digests[slotNum]);
        }

        public Object getShardValue(int slot) throws IOException {
            AVLTreeDigest digest = this.digests[slot];
            if (digest == null) {
                return null;
            }
            digest.compress();
            int sz = digest.byteSize();
            if (this.buf == null || this.buf.capacity() < sz) {
                this.buf = ByteBuffer.allocate(sz + (sz >> 1));
            } else {
                this.buf.clear();
            }
            digest.asSmallBytes(this.buf);
            byte[] arr = Arrays.copyOf(this.buf.array(), this.buf.position());
            return arr;
        }

        @Override
        public void reset() {
            this.digests = new AVLTreeDigest[this.digests.length];
            this.sortvals = null;
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.digests = resizer.resize(this.digests, null);
        }
    }

    public static class Parser
    extends ValueSourceParser {
        @Override
        public ValueSource parse(FunctionQParser fp) throws SyntaxError {
            ArrayList<Double> percentiles = new ArrayList<Double>();
            ValueSource vs = fp.parseValueSource();
            while (fp.hasMoreArguments()) {
                double val = fp.parseDouble();
                if (val < 0.0 || val > 100.0) {
                    throw new SyntaxError("requested percentile must be between 0 and 100.  got " + val);
                }
                percentiles.add(val);
            }
            if (percentiles.isEmpty()) {
                throw new SyntaxError("expected percentile(valsource,percent1[,percent2]*)  EXAMPLE:percentile(myfield,50)");
            }
            return new PercentileAgg(vs, percentiles);
        }
    }
}

