/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockEncoder;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class FSTDictionary
implements IndexDictionary {
    private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(FSTDictionary.class);
    protected final FST<Long> dictionary;

    protected FSTDictionary(FST<Long> dictionary) {
        this.dictionary = dictionary;
    }

    public long ramBytesUsed() {
        return BASE_RAM_USAGE + this.dictionary.ramBytesUsed();
    }

    @Override
    public void write(DataOutput output, BlockEncoder blockEncoder) throws IOException {
        if (blockEncoder == null) {
            this.dictionary.save(output);
        } else {
            ByteBuffersDataOutput bytesDataOutput = ByteBuffersDataOutput.newResettableInstance();
            this.dictionary.save((DataOutput)bytesDataOutput);
            BlockEncoder.WritableBytes encodedBytes = blockEncoder.encode((DataInput)bytesDataOutput.toDataInput(), bytesDataOutput.size());
            output.writeVLong(encodedBytes.size());
            encodedBytes.writeTo(output);
        }
    }

    protected static FSTDictionary read(DataInput input, BlockDecoder blockDecoder) throws IOException {
        DataInput fstDataInput;
        if (blockDecoder == null) {
            fstDataInput = input;
        } else {
            long numBytes = input.readVLong();
            BytesRef decodedBytes = blockDecoder.decode(input, numBytes);
            fstDataInput = new ByteArrayDataInput(decodedBytes.bytes, 0, decodedBytes.length);
        }
        PositiveIntOutputs fstOutputs = PositiveIntOutputs.getSingleton();
        FST dictionary = new FST(fstDataInput, (Outputs)fstOutputs);
        return new FSTDictionary((FST<Long>)dictionary);
    }

    @Override
    public Browser browser() {
        return new Browser();
    }

    protected class Browser
    implements IndexDictionary.Browser {
        protected final BytesRefFSTEnum<Long> fstEnum;

        protected Browser() {
            this.fstEnum = new BytesRefFSTEnum(FSTDictionary.this.dictionary);
        }

        @Override
        public long seekBlock(BytesRef term) throws IOException {
            BytesRefFSTEnum.InputOutput seekFloor = this.fstEnum.seekFloor(term);
            return seekFloor == null ? -1L : (Long)seekFloor.output;
        }
    }

    public static class Builder
    implements IndexDictionary.Builder {
        protected final org.apache.lucene.util.fst.Builder<Long> fstBuilder;
        protected final IntsRefBuilder scratchInts;

        public Builder() {
            PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
            this.fstBuilder = new org.apache.lucene.util.fst.Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
            this.scratchInts = new IntsRefBuilder();
        }

        @Override
        public void add(BytesRef blockKey, long blockFilePointer) throws IOException {
            this.fstBuilder.add(Util.toIntsRef((BytesRef)blockKey, (IntsRefBuilder)this.scratchInts), (Object)blockFilePointer);
        }

        @Override
        public FSTDictionary build() throws IOException {
            return new FSTDictionary((FST<Long>)this.fstBuilder.finish());
        }
    }

    public static class BrowserSupplier
    implements IndexDictionary.BrowserSupplier {
        protected final IndexInput dictionaryInput;
        protected final BlockDecoder blockDecoder;
        protected IndexDictionary dictionary;

        public BrowserSupplier(IndexInput dictionaryInput, long startFilePointer, BlockDecoder blockDecoder) throws IOException {
            this.dictionaryInput = dictionaryInput.clone();
            this.dictionaryInput.seek(startFilePointer);
            this.blockDecoder = blockDecoder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexDictionary.Browser get() throws IOException {
            if (this.dictionary == null) {
                BrowserSupplier browserSupplier = this;
                synchronized (browserSupplier) {
                    if (this.dictionary == null) {
                        this.dictionary = FSTDictionary.read((DataInput)this.dictionaryInput, this.blockDecoder);
                    }
                }
            }
            return this.dictionary.browser();
        }

        public long ramBytesUsed() {
            return this.dictionary == null ? 0L : this.dictionary.ramBytesUsed();
        }
    }
}

