/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Pair;
import org.apache.solr.handler.sql.SolrAggregate;
import org.apache.solr.handler.sql.SolrRel;
import org.apache.solr.handler.sql.SolrRules;

class SolrFilter
extends Filter
implements SolrRel {
    SolrFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
        assert (this.getConvention() == SolrRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    public SolrFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new SolrFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implement(SolrRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        if (this.getInput() instanceof SolrAggregate) {
            HavingTranslator translator = new HavingTranslator(SolrRules.solrFieldNames(this.getRowType()), implementor.reverseAggMappings);
            String havingPredicate = translator.translateMatch(this.condition);
            implementor.setHavingPredicate(havingPredicate);
        } else {
            Translator translator = new Translator(SolrRules.solrFieldNames(this.getRowType()));
            String query = translator.translateMatch(this.condition);
            implementor.addQuery(query);
            implementor.setNegativeQuery(translator.negativeQuery);
        }
    }

    private static class HavingTranslator {
        private final List<String> fieldNames;
        private Map<String, String> reverseAggMappings;

        HavingTranslator(List<String> fieldNames, Map<String, String> reverseAggMappings) {
            this.fieldNames = fieldNames;
            this.reverseAggMappings = reverseAggMappings;
        }

        private String translateMatch(RexNode condition) {
            if (condition.getKind().belongsTo((Collection)SqlKind.COMPARISON)) {
                return this.translateComparison(condition);
            }
            if (condition.isA(SqlKind.AND)) {
                return this.translateAnd(condition);
            }
            if (condition.isA(SqlKind.OR)) {
                return this.translateOr(condition);
            }
            return null;
        }

        private String translateOr(RexNode condition) {
            ArrayList<String> ors = new ArrayList<String>();
            for (RexNode node : RelOptUtil.disjunctions((RexNode)condition)) {
                ors.add(this.translateMatch(node));
            }
            StringBuilder builder = new StringBuilder();
            builder.append("or(");
            int i = 0;
            for (i = 0; i < ors.size(); ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append((String)ors.get(i));
            }
            builder.append(")");
            return builder.toString();
        }

        private String translateAnd(RexNode node0) {
            ArrayList<String> andStrings = new ArrayList<String>();
            ArrayList<String> notStrings = new ArrayList<String>();
            ArrayList ands = new ArrayList();
            ArrayList nots = new ArrayList();
            RelOptUtil.decomposeConjunction((RexNode)node0, ands, nots);
            for (RexNode node : ands) {
                andStrings.add(this.translateMatch(node));
            }
            StringBuilder builder = new StringBuilder();
            builder.append("and(");
            for (int i = 0; i < andStrings.size(); ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append((String)andStrings.get(i));
            }
            builder.append(")");
            if (nots.size() > 0) {
                for (RexNode node : nots) {
                    notStrings.add(this.translateMatch(node));
                }
                StringBuilder notBuilder = new StringBuilder();
                for (int i = 0; i < notStrings.size(); ++i) {
                    if (i > 0) {
                        notBuilder.append(",");
                    }
                    notBuilder.append("not(");
                    notBuilder.append((String)notStrings.get(i));
                    notBuilder.append(")");
                }
                return "and(" + builder.toString() + "," + notBuilder.toString() + ")";
            }
            return builder.toString();
        }

        private String translateComparison(RexNode node) {
            Pair<String, RexLiteral> binaryTranslated = null;
            if (((RexCall)node).getOperands().size() == 2) {
                binaryTranslated = this.translateBinary((RexCall)node);
            }
            switch (node.getKind()) {
                case EQUALS: {
                    String terms = ((RexLiteral)binaryTranslated.getValue()).toString().trim();
                    String clause = "eq(" + (String)binaryTranslated.getKey() + "," + terms + ")";
                    return clause;
                }
                case NOT_EQUALS: {
                    return "not(eq(" + (String)binaryTranslated.getKey() + "," + binaryTranslated.getValue() + "))";
                }
                case LESS_THAN: {
                    return "lt(" + (String)binaryTranslated.getKey() + "," + binaryTranslated.getValue() + ")";
                }
                case LESS_THAN_OR_EQUAL: {
                    return "lteq(" + (String)binaryTranslated.getKey() + "," + binaryTranslated.getValue() + ")";
                }
                case GREATER_THAN: {
                    return "gt(" + (String)binaryTranslated.getKey() + "," + binaryTranslated.getValue() + ")";
                }
                case GREATER_THAN_OR_EQUAL: {
                    return "gteq(" + (String)binaryTranslated.getKey() + "," + binaryTranslated.getValue() + ")";
                }
            }
            throw new AssertionError((Object)("cannot translate " + node));
        }

        private Pair<String, RexLiteral> translateBinary(RexCall call) {
            RexNode right;
            List operands = call.getOperands();
            if (operands.size() != 2) {
                throw new AssertionError((Object)("Invalid number of arguments - " + operands.size()));
            }
            RexNode left = (RexNode)operands.get(0);
            Pair<String, RexLiteral> a = this.translateBinary2(left, right = (RexNode)operands.get(1));
            if (a != null) {
                if (this.reverseAggMappings.containsKey(a.getKey())) {
                    return new Pair((Object)this.reverseAggMappings.get(a.getKey()), (Object)((RexLiteral)a.getValue()));
                }
                return a;
            }
            Pair<String, RexLiteral> b = this.translateBinary2(right, left);
            if (b != null) {
                return b;
            }
            throw new AssertionError((Object)("cannot translate call " + call));
        }

        private Pair<String, RexLiteral> translateBinary2(RexNode left, RexNode right) {
            switch (right.getKind()) {
                case LITERAL: {
                    break;
                }
                default: {
                    return null;
                }
            }
            RexLiteral rightLiteral = (RexLiteral)right;
            switch (left.getKind()) {
                case INPUT_REF: {
                    RexInputRef left1 = (RexInputRef)left;
                    String name = this.fieldNames.get(left1.getIndex());
                    return new Pair((Object)name, (Object)rightLiteral);
                }
                case CAST: {
                    return this.translateBinary2((RexNode)((RexCall)left).operands.get(0), right);
                }
            }
            return null;
        }
    }

    private static class Translator {
        private final List<String> fieldNames;
        public boolean negativeQuery = true;

        Translator(List<String> fieldNames) {
            this.fieldNames = fieldNames;
        }

        private String translateMatch(RexNode condition) {
            if (condition.getKind().belongsTo((Collection)SqlKind.COMPARISON)) {
                return this.translateComparison(condition);
            }
            if (condition.isA(SqlKind.AND)) {
                return "(" + this.translateAnd(condition) + ")";
            }
            if (condition.isA(SqlKind.OR)) {
                return "(" + this.translateOr(condition) + ")";
            }
            return null;
        }

        private String translateOr(RexNode condition) {
            ArrayList<String> ors = new ArrayList<String>();
            for (RexNode node : RelOptUtil.disjunctions((RexNode)condition)) {
                ors.add(this.translateMatch(node));
            }
            return String.join((CharSequence)" OR ", ors);
        }

        private String translateAnd(RexNode node0) {
            ArrayList<String> andStrings = new ArrayList<String>();
            ArrayList<String> notStrings = new ArrayList<String>();
            ArrayList ands = new ArrayList();
            ArrayList nots = new ArrayList();
            RelOptUtil.decomposeConjunction((RexNode)node0, ands, nots);
            for (Object node : ands) {
                andStrings.add(this.translateMatch((RexNode)node));
            }
            String andString = String.join((CharSequence)" AND ", andStrings);
            if (nots.size() > 0) {
                for (RexNode node : nots) {
                    notStrings.add(this.translateMatch(node));
                }
                String notString = String.join((CharSequence)" NOT ", notStrings);
                return "(" + andString + ") NOT (" + notString + ")";
            }
            return andString;
        }

        private String translateComparison(RexNode node) {
            Pair<String, RexLiteral> binaryTranslated = null;
            if (((RexCall)node).getOperands().size() == 2) {
                binaryTranslated = this.translateBinary((RexCall)node);
            }
            switch (node.getKind()) {
                case NOT: {
                    return "-" + this.translateComparison((RexNode)((RexCall)node).getOperands().get(0));
                }
                case EQUALS: {
                    String terms = ((RexLiteral)binaryTranslated.getValue()).toString().trim();
                    terms = terms.replace("'", "");
                    if (!(terms.startsWith("(") || terms.startsWith("[") || terms.startsWith("{"))) {
                        terms = "\"" + terms + "\"";
                    }
                    String clause = (String)binaryTranslated.getKey() + ":" + terms;
                    this.negativeQuery = false;
                    return clause;
                }
                case NOT_EQUALS: {
                    return "-(" + (String)binaryTranslated.getKey() + ":" + binaryTranslated.getValue() + ")";
                }
                case LESS_THAN: {
                    this.negativeQuery = false;
                    return "(" + (String)binaryTranslated.getKey() + ": [ * TO " + binaryTranslated.getValue() + " })";
                }
                case LESS_THAN_OR_EQUAL: {
                    this.negativeQuery = false;
                    return "(" + (String)binaryTranslated.getKey() + ": [ * TO " + binaryTranslated.getValue() + " ])";
                }
                case GREATER_THAN: {
                    this.negativeQuery = false;
                    return "(" + (String)binaryTranslated.getKey() + ": { " + binaryTranslated.getValue() + " TO * ])";
                }
                case GREATER_THAN_OR_EQUAL: {
                    this.negativeQuery = false;
                    return "(" + (String)binaryTranslated.getKey() + ": [ " + binaryTranslated.getValue() + " TO * ])";
                }
            }
            throw new AssertionError((Object)("cannot translate " + node));
        }

        private Pair<String, RexLiteral> translateBinary(RexCall call) {
            RexNode right;
            List operands = call.getOperands();
            if (operands.size() != 2) {
                throw new AssertionError((Object)("Invalid number of arguments - " + operands.size()));
            }
            RexNode left = (RexNode)operands.get(0);
            Pair<String, RexLiteral> a = this.translateBinary2(left, right = (RexNode)operands.get(1));
            if (a != null) {
                return a;
            }
            Pair<String, RexLiteral> b = this.translateBinary2(right, left);
            if (b != null) {
                return b;
            }
            throw new AssertionError((Object)("cannot translate call " + call));
        }

        private Pair<String, RexLiteral> translateBinary2(RexNode left, RexNode right) {
            switch (right.getKind()) {
                case LITERAL: {
                    break;
                }
                default: {
                    return null;
                }
            }
            RexLiteral rightLiteral = (RexLiteral)right;
            switch (left.getKind()) {
                case INPUT_REF: {
                    RexInputRef left1 = (RexInputRef)left;
                    String name = this.fieldNames.get(left1.getIndex());
                    return new Pair((Object)name, (Object)rightLiteral);
                }
                case CAST: {
                    return this.translateBinary2((RexNode)((RexCall)left).operands.get(0), right);
                }
            }
            return null;
        }
    }
}

