/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.snapshot;

import com.sun.tools.visualvm.application.snapshot.ApplicationSnapshotCategory;
import com.sun.tools.visualvm.application.snapshot.ApplicationSnapshotDescriptorProvider;
import com.sun.tools.visualvm.application.snapshot.ApplicationSnapshotProvider;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.model.ModelProvider;
import com.sun.tools.visualvm.core.snapshot.RegisteredSnapshotCategories;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import com.sun.tools.visualvm.core.snapshot.SnapshotsContainer;
import java.io.File;

public final class ApplicationSnapshotsSupport {
    private static ApplicationSnapshotsSupport instance;
    private static final String SNAPSHOTS_STORAGE_DIRNAME = "snapshots";
    private static File snapshotsStorageDirectory;
    private static String snapshotsStorageDirectoryString;
    private ApplicationSnapshotProvider snapshotProvider;
    private ApplicationSnapshotCategory snapshotCategory = new ApplicationSnapshotCategory();

    public static synchronized ApplicationSnapshotsSupport getInstance() {
        if (instance == null) {
            instance = new ApplicationSnapshotsSupport();
        }
        return instance;
    }

    public SnapshotCategory getCategory() {
        return this.snapshotCategory;
    }

    ApplicationSnapshotCategory getApplicationSnapshotCategory() {
        return this.snapshotCategory;
    }

    ApplicationSnapshotProvider getSnapshotProvider() {
        return this.snapshotProvider;
    }

    static synchronized String getStorageDirectoryString() {
        if (snapshotsStorageDirectoryString == null) {
            snapshotsStorageDirectoryString = Storage.getPersistentStorageDirectoryString() + File.separator + SNAPSHOTS_STORAGE_DIRNAME;
        }
        return snapshotsStorageDirectoryString;
    }

    static synchronized File getStorageDirectory() {
        if (snapshotsStorageDirectory == null) {
            String snapshotsStorageString = ApplicationSnapshotsSupport.getStorageDirectoryString();
            snapshotsStorageDirectory = new File(snapshotsStorageString);
            if (snapshotsStorageDirectory.exists() && snapshotsStorageDirectory.isFile()) {
                throw new IllegalStateException("Cannot create snapshots storage directory " + snapshotsStorageString + ", file in the way");
            }
            if (!(!snapshotsStorageDirectory.exists() || snapshotsStorageDirectory.canRead() && snapshotsStorageDirectory.canWrite())) {
                throw new IllegalStateException("Cannot access snapshots storage directory " + snapshotsStorageString + ", read&write permission required");
            }
            if (!Utils.prepareDirectory((File)snapshotsStorageDirectory)) {
                throw new IllegalStateException("Cannot create snapshots storage directory " + snapshotsStorageString);
            }
        }
        return snapshotsStorageDirectory;
    }

    static boolean storageDirectoryExists() {
        return new File(ApplicationSnapshotsSupport.getStorageDirectoryString()).isDirectory();
    }

    private ApplicationSnapshotsSupport() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new ApplicationSnapshotDescriptorProvider());
        this.snapshotProvider = ApplicationSnapshotProvider.sharedInstance();
        RegisteredSnapshotCategories.sharedInstance().registerCategory((SnapshotCategory)this.snapshotCategory);
        SnapshotsContainer.sharedInstance();
        this.snapshotProvider.initialize();
    }
}

