/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;

public abstract class AbstractParallelFtilesBuilder {
    protected final double barHeight = 6.0;
    private final Rose rose = new Rose();
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    private final List<Ftile> list;
    private final Ftile middle;
    private final FtileGeometry middleDimension;

    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public final StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public AbstractParallelFtilesBuilder(ISkinParam skinParam, StringBounder stringBounder, List<Ftile> list, Ftile middle) {
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
        this.list = list;
        this.middle = middle;
        this.middleDimension = middle.calculateDimension(this.getStringBounder());
    }

    public final Ftile build() {
        Ftile step1 = this.doStep1();
        return this.doStep2(step1);
    }

    protected abstract Ftile doStep1();

    protected abstract Ftile doStep2(Ftile var1);

    protected StringBounder getStringBounder() {
        return this.stringBounder;
    }

    protected Rose getRose() {
        return this.rose;
    }

    protected ISkinParam skinParam() {
        return this.skinParam;
    }

    protected final TextBlock getTextBlock(Display display) {
        FontConfiguration fontConfiguration;
        if (Display.isNull(display)) {
            return null;
        }
        if (SkinParam.USE_STYLES()) {
            Style style = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
            fontConfiguration = style.getFontConfiguration(this.skinParam().getIHtmlColorSet());
        } else {
            fontConfiguration = new FontConfiguration(this.skinParam(), FontParam.ARROW, null);
        }
        return display.create7(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam(), CreoleMode.SIMPLE_LINE);
    }

    protected TextBlock getTextBlock(LinkRendering linkRendering) {
        Display display = linkRendering.getDisplay();
        return this.getTextBlock(display);
    }

    protected final List<Ftile> getList() {
        return Collections.unmodifiableList(this.list);
    }

    protected final Ftile getMiddle() {
        return this.middle;
    }

    protected final double getHeightOfMiddle() {
        return this.middleDimension.getHeight();
    }

    protected Swimlane swimlaneOutForStep2() {
        return this.list.get(this.list.size() - 1).getSwimlaneOut();
    }
}

