/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.api.MyRunnable;
import net.sourceforge.plantuml.api.TimeoutExecutor;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;

public class ProcessRunner {
    private final String[] cmd;
    private String error;
    private String out;
    private volatile ProcessState state = ProcessState.INIT();
    private final Lock changeState = new ReentrantLock();

    public ProcessRunner(String[] cmd) {
        this.cmd = cmd;
    }

    public ProcessState run(byte[] in, OutputStream redirection) {
        return this.run(in, redirection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessState run(byte[] in, OutputStream redirection, File dir) {
        if (this.state.differs(ProcessState.INIT())) {
            throw new IllegalStateException();
        }
        this.state = ProcessState.RUNNING();
        MainThread mainThread = new MainThread(this.cmd, dir, redirection, in);
        try {
            long timeoutMs = OptionFlags.getInstance().getTimeoutMs();
            boolean bl = new TimeoutExecutor(timeoutMs).executeNow(mainThread);
        }
        finally {
            this.changeState.lock();
            try {
                if (this.state.equals(ProcessState.RUNNING())) {
                    this.state = ProcessState.TIMEOUT();
                }
            }
            finally {
                this.changeState.unlock();
            }
        }
        if (this.state.equals(ProcessState.TERMINATED_OK())) {
            assert (mainThread != null);
            this.error = mainThread.getError();
            this.out = mainThread.getOut();
        }
        return this.state;
    }

    public final String getError() {
        return this.error;
    }

    public final String getOut() {
        return this.out;
    }

    private void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class MainThread
    implements MyRunnable {
        private final String[] cmd;
        private final File dir;
        private final OutputStream redirection;
        private final byte[] in;
        private volatile Process process;
        private volatile ThreadStream errorStream;
        private volatile ThreadStream outStream;

        public MainThread(String[] cmd, File dir, OutputStream redirection, byte[] in) {
            this.cmd = cmd;
            this.dir = dir;
            this.redirection = redirection;
            this.in = in;
        }

        public String getOut() {
            return this.outStream.getString();
        }

        public String getError() {
            return this.errorStream.getString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() throws InterruptedException {
            try {
                this.startThreads();
                if (ProcessRunner.this.state.equals(ProcessState.RUNNING())) {
                    int n = this.joinInternal();
                }
            }
            finally {
                ProcessRunner.this.changeState.lock();
                try {
                    if (ProcessRunner.this.state.equals(ProcessState.RUNNING())) {
                        ProcessRunner.this.state = ProcessState.TERMINATED_OK();
                    }
                }
                finally {
                    ProcessRunner.this.changeState.unlock();
                }
                if (this.process != null) {
                    this.process.destroy();
                    ProcessRunner.this.close(this.process.getErrorStream());
                    ProcessRunner.this.close(this.process.getOutputStream());
                    ProcessRunner.this.close(this.process.getInputStream());
                }
            }
        }

        @Override
        public void cancelJob() {
            if (this.process != null) {
                this.errorStream.cancel();
                this.outStream.cancel();
                this.process.destroy();
                ProcessRunner.this.close(this.process.getErrorStream());
                ProcessRunner.this.close(this.process.getOutputStream());
                ProcessRunner.this.close(this.process.getInputStream());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startThreads() {
            try {
                this.process = Runtime.getRuntime().exec(this.cmd, null, this.dir);
            }
            catch (IOException e) {
                e.printStackTrace();
                ProcessRunner.this.changeState.lock();
                try {
                    ProcessRunner.this.state = ProcessState.IO_EXCEPTION1(e);
                }
                finally {
                    ProcessRunner.this.changeState.unlock();
                }
                e.printStackTrace();
                return;
            }
            this.errorStream = new ThreadStream(this.process.getErrorStream(), null);
            this.outStream = new ThreadStream(this.process.getInputStream(), this.redirection);
            this.errorStream.start();
            this.outStream.start();
            if (this.in != null) {
                OutputStream os = this.process.getOutputStream();
                try {
                    try {
                        os.write(this.in);
                    }
                    finally {
                        os.close();
                    }
                }
                catch (IOException e) {
                    ProcessRunner.this.changeState.lock();
                    try {
                        ProcessRunner.this.state = ProcessState.IO_EXCEPTION2(e);
                    }
                    finally {
                        ProcessRunner.this.changeState.unlock();
                    }
                    e.printStackTrace();
                }
            }
        }

        public int joinInternal() throws InterruptedException {
            this.errorStream.join();
            this.outStream.join();
            int result = this.process.waitFor();
            return result;
        }
    }

    class ThreadStream
    extends Thread {
        private volatile InputStream streamToRead;
        private volatile OutputStream redirection;
        private volatile StringBuffer sb = new StringBuffer();

        ThreadStream(InputStream streamToRead, OutputStream redirection) {
            this.streamToRead = streamToRead;
            this.redirection = redirection;
        }

        public String getString() {
            if (this.sb == null) {
                return "";
            }
            return this.sb.toString();
        }

        public void cancel() {
            assert (ProcessRunner.this.state.equals(ProcessState.TIMEOUT()) || ProcessRunner.this.state.equals(ProcessState.RUNNING())) : ProcessRunner.access$000(ProcessRunner.this);
            this.interrupt();
            this.sb = null;
            this.streamToRead = null;
            this.redirection = null;
        }

        @Override
        public void run() {
            int read = 0;
            try {
                while ((read = this.streamToRead.read()) != -1) {
                    if (ProcessRunner.this.state.equals(ProcessState.TIMEOUT())) {
                        return;
                    }
                    if (this.redirection == null) {
                        this.sb.append((char)read);
                        continue;
                    }
                    this.redirection.write(read);
                }
            }
            catch (Throwable e) {
                System.err.println("ProcessRunnerA " + e);
                e.printStackTrace();
                this.sb.append('\n');
                this.sb.append(e.toString());
            }
        }
    }
}

