/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cute.CuteShapeFactory;
import net.sourceforge.plantuml.cute.Group;
import net.sourceforge.plantuml.cute.Positionned;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;

public class PSystemCute
extends AbstractPSystem {
    private final Group root;
    private Group currentGroup;

    public PSystemCute() {
        this.currentGroup = this.root = Group.createRoot();
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Cute)");
    }

    public void doCommandLine(String line) {
        if ((line = StringUtils.trin(line)).length() == 0 || line.startsWith("'")) {
            return;
        }
        if (line.startsWith("group ")) {
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            String groupName = st.nextToken();
            this.currentGroup = this.currentGroup.createChild(groupName);
        } else if (line.startsWith("}")) {
            this.currentGroup = this.currentGroup.getParent();
        } else {
            Positionned shape = new CuteShapeFactory(this.currentGroup.getChildren()).createCuteShapePositionned(line);
            this.currentGroup.add(shape);
        }
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        ImageBuilder builder = new ImageBuilder(new ColorMapperIdentity(), 1.0, null, null, null, 10.0, 10.0, null, false);
        builder.setUDrawable(this.root);
        return builder.writeImageTOBEMOVED(fileFormat, seed, os);
    }
}

