/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jasic;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Jasic {
    private final Map<String, Value> variables = new HashMap<String, Value>();
    private final Map<String, Integer> labels = new HashMap<String, Integer>();
    private final BufferedReader lineIn;
    private int currentStatement;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: jasic <script>");
            System.out.println("Where <script> is a relative path to a .jas script to run.");
            return;
        }
        String contents = Jasic.readFile(args[0]);
        Jasic jasic = new Jasic();
        jasic.interpret(contents);
    }

    private static List<Token> tokenize(String source) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        String token = "";
        TokenizeState state = TokenizeState.DEFAULT;
        String charTokens = "\n=+-*/<>()";
        TokenType[] tokenTypes = new TokenType[]{TokenType.LINE, TokenType.EQUALS, TokenType.OPERATOR, TokenType.OPERATOR, TokenType.OPERATOR, TokenType.OPERATOR, TokenType.OPERATOR, TokenType.OPERATOR, TokenType.LEFT_PAREN, TokenType.RIGHT_PAREN};
        block7: for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            switch (state) {
                case DEFAULT: {
                    if (charTokens.indexOf(c) != -1) {
                        tokens.add(new Token(Character.toString(c), tokenTypes[charTokens.indexOf(c)]));
                        continue block7;
                    }
                    if (Character.isLetter(c)) {
                        token = token + c;
                        state = TokenizeState.WORD;
                        continue block7;
                    }
                    if (Character.isDigit(c)) {
                        token = token + c;
                        state = TokenizeState.NUMBER;
                        continue block7;
                    }
                    if (c == '\"') {
                        state = TokenizeState.STRING;
                        continue block7;
                    }
                    if (c != '\'') continue block7;
                    state = TokenizeState.COMMENT;
                    continue block7;
                }
                case WORD: {
                    if (Character.isLetterOrDigit(c)) {
                        token = token + c;
                        continue block7;
                    }
                    if (c == ':') {
                        tokens.add(new Token(token, TokenType.LABEL));
                        token = "";
                        state = TokenizeState.DEFAULT;
                        continue block7;
                    }
                    tokens.add(new Token(token, TokenType.WORD));
                    token = "";
                    state = TokenizeState.DEFAULT;
                    --i;
                    continue block7;
                }
                case NUMBER: {
                    if (Character.isDigit(c)) {
                        token = token + c;
                        continue block7;
                    }
                    tokens.add(new Token(token, TokenType.NUMBER));
                    token = "";
                    state = TokenizeState.DEFAULT;
                    --i;
                    continue block7;
                }
                case STRING: {
                    if (c == '\"') {
                        tokens.add(new Token(token, TokenType.STRING));
                        token = "";
                        state = TokenizeState.DEFAULT;
                        continue block7;
                    }
                    token = token + c;
                    continue block7;
                }
                case COMMENT: {
                    if (c != '\n') continue block7;
                    state = TokenizeState.DEFAULT;
                }
            }
        }
        return tokens;
    }

    public Jasic() {
        InputStreamReader converter = new InputStreamReader(System.in);
        this.lineIn = new BufferedReader(converter);
    }

    public void interpret(String source) {
        List<Token> tokens = Jasic.tokenize(source);
        Parser parser = new Parser(tokens);
        List<Statement> statements = parser.parse(this.labels);
        this.currentStatement = 0;
        while (this.currentStatement < statements.size()) {
            int thisStatement = this.currentStatement++;
            statements.get(thisStatement).execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String path) {
        String string;
        FileInputStream stream = new FileInputStream(path);
        try {
            int read;
            InputStreamReader input = new InputStreamReader((InputStream)stream, Charset.defaultCharset());
            BufferedReader reader = new BufferedReader(input);
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            builder.append("\n");
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ex) {
                return null;
            }
        }
        stream.close();
        return string;
    }

    private static enum TokenizeState {
        DEFAULT,
        WORD,
        NUMBER,
        STRING,
        COMMENT;

    }

    private static enum TokenType {
        WORD,
        NUMBER,
        STRING,
        LABEL,
        LINE,
        EQUALS,
        OPERATOR,
        LEFT_PAREN,
        RIGHT_PAREN,
        EOF;

    }

    private static class Token {
        public final String text;
        public final TokenType type;

        public Token(String text, TokenType type) {
            this.text = text;
            this.type = type;
        }
    }

    private class Parser {
        private final List<Token> tokens;
        private int position;

        public Parser(List<Token> tokens) {
            this.tokens = tokens;
            this.position = 0;
        }

        public List<Statement> parse(Map<String, Integer> labels) {
            ArrayList<Statement> statements = new ArrayList<Statement>();
            while (true) {
                if (this.match(TokenType.LINE)) {
                    continue;
                }
                if (this.match(TokenType.LABEL)) {
                    labels.put(this.last((int)1).text, statements.size());
                    continue;
                }
                if (this.match(TokenType.WORD, TokenType.EQUALS)) {
                    String name = this.last((int)2).text;
                    Expression value = this.expression();
                    statements.add(new AssignStatement(name, value));
                    continue;
                }
                if (this.match("print")) {
                    statements.add(new PrintStatement(this.expression()));
                    continue;
                }
                if (this.match("input")) {
                    statements.add(new InputStatement(this.consume((TokenType)TokenType.WORD).text));
                    continue;
                }
                if (this.match("goto")) {
                    statements.add(new GotoStatement(this.consume((TokenType)TokenType.WORD).text));
                    continue;
                }
                if (!this.match("if")) break;
                Expression condition = this.expression();
                this.consume("then");
                String label = this.consume((TokenType)TokenType.WORD).text;
                statements.add(new IfThenStatement(condition, label));
            }
            return statements;
        }

        private Expression expression() {
            return this.operator();
        }

        private Expression operator() {
            Expression expression = this.atomic();
            while (this.match(TokenType.OPERATOR) || this.match(TokenType.EQUALS)) {
                char operator = this.last((int)1).text.charAt(0);
                Expression right = this.atomic();
                expression = new OperatorExpression(expression, operator, right);
            }
            return expression;
        }

        private Expression atomic() {
            if (this.match(TokenType.WORD)) {
                return new VariableExpression(this.last((int)1).text);
            }
            if (this.match(TokenType.NUMBER)) {
                return new NumberValue(Double.parseDouble(this.last((int)1).text));
            }
            if (this.match(TokenType.STRING)) {
                return new StringValue(this.last((int)1).text);
            }
            if (this.match(TokenType.LEFT_PAREN)) {
                Expression expression = this.expression();
                this.consume(TokenType.RIGHT_PAREN);
                return expression;
            }
            throw new Error("Couldn't parse :(");
        }

        private boolean match(TokenType type1, TokenType type2) {
            if (this.get((int)0).type != type1) {
                return false;
            }
            if (this.get((int)1).type != type2) {
                return false;
            }
            this.position += 2;
            return true;
        }

        private boolean match(TokenType type) {
            if (this.get((int)0).type != type) {
                return false;
            }
            ++this.position;
            return true;
        }

        private boolean match(String name) {
            if (this.get((int)0).type != TokenType.WORD) {
                return false;
            }
            if (!this.get((int)0).text.equals(name)) {
                return false;
            }
            ++this.position;
            return true;
        }

        private Token consume(TokenType type) {
            if (this.get((int)0).type != type) {
                throw new Error("Expected " + (Object)((Object)type) + ".");
            }
            return this.tokens.get(this.position++);
        }

        private Token consume(String name) {
            if (!this.match(name)) {
                throw new Error("Expected " + name + ".");
            }
            return this.last(1);
        }

        private Token last(int offset) {
            return this.tokens.get(this.position - offset);
        }

        private Token get(int offset) {
            if (this.position + offset >= this.tokens.size()) {
                return new Token("", TokenType.EOF);
            }
            return this.tokens.get(this.position + offset);
        }
    }

    public static interface Statement {
        public void execute();
    }

    public class StringValue
    implements Value {
        private final String value;

        public StringValue(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @Override
        public double toNumber() {
            return Double.parseDouble(this.value);
        }

        @Override
        public Value evaluate() {
            return this;
        }
    }

    public class NumberValue
    implements Value {
        private final double value;

        public NumberValue(double value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return Double.toString(this.value);
        }

        @Override
        public double toNumber() {
            return this.value;
        }

        @Override
        public Value evaluate() {
            return this;
        }
    }

    public static interface Value
    extends Expression {
        public String toString();

        public double toNumber();
    }

    public class OperatorExpression
    implements Expression {
        private final Expression left;
        private final char operator;
        private final Expression right;

        public OperatorExpression(Expression left, char operator, Expression right) {
            this.left = left;
            this.operator = operator;
            this.right = right;
        }

        @Override
        public Value evaluate() {
            Value leftVal = this.left.evaluate();
            Value rightVal = this.right.evaluate();
            switch (this.operator) {
                case '=': {
                    if (leftVal instanceof NumberValue) {
                        return new NumberValue(leftVal.toNumber() == rightVal.toNumber() ? 1.0 : 0.0);
                    }
                    return new NumberValue(leftVal.toString().equals(rightVal.toString()) ? 1.0 : 0.0);
                }
                case '+': {
                    if (leftVal instanceof NumberValue) {
                        return new NumberValue(leftVal.toNumber() + rightVal.toNumber());
                    }
                    return new StringValue(leftVal.toString() + rightVal.toString());
                }
                case '-': {
                    return new NumberValue(leftVal.toNumber() - rightVal.toNumber());
                }
                case '*': {
                    return new NumberValue(leftVal.toNumber() * rightVal.toNumber());
                }
                case '/': {
                    return new NumberValue(leftVal.toNumber() / rightVal.toNumber());
                }
                case '<': {
                    if (leftVal instanceof NumberValue) {
                        return new NumberValue(leftVal.toNumber() < rightVal.toNumber() ? 1.0 : 0.0);
                    }
                    return new NumberValue(leftVal.toString().compareTo(rightVal.toString()) < 0 ? 1.0 : 0.0);
                }
                case '>': {
                    if (leftVal instanceof NumberValue) {
                        return new NumberValue(leftVal.toNumber() > rightVal.toNumber() ? 1.0 : 0.0);
                    }
                    return new NumberValue(leftVal.toString().compareTo(rightVal.toString()) > 0 ? 1.0 : 0.0);
                }
            }
            throw new Error("Unknown operator.");
        }
    }

    public class VariableExpression
    implements Expression {
        private final String name;

        public VariableExpression(String name) {
            this.name = name;
        }

        @Override
        public Value evaluate() {
            if (Jasic.this.variables.containsKey(this.name)) {
                return (Value)Jasic.this.variables.get(this.name);
            }
            return new NumberValue(0.0);
        }
    }

    public class IfThenStatement
    implements Statement {
        private final Expression condition;
        private final String label;

        public IfThenStatement(Expression condition, String label) {
            this.condition = condition;
            this.label = label;
        }

        @Override
        public void execute() {
            double value;
            if (Jasic.this.labels.containsKey(this.label) && (value = this.condition.evaluate().toNumber()) != 0.0) {
                Jasic.this.currentStatement = (Integer)Jasic.this.labels.get(this.label);
            }
        }
    }

    public class GotoStatement
    implements Statement {
        private final String label;

        public GotoStatement(String label) {
            this.label = label;
        }

        @Override
        public void execute() {
            if (Jasic.this.labels.containsKey(this.label)) {
                Jasic.this.currentStatement = (Integer)Jasic.this.labels.get(this.label);
            }
        }
    }

    public class AssignStatement
    implements Statement {
        private final String name;
        private final Expression value;

        public AssignStatement(String name, Expression value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public void execute() {
            Jasic.this.variables.put(this.name, this.value.evaluate());
        }
    }

    public class InputStatement
    implements Statement {
        private final String name;

        public InputStatement(String name) {
            this.name = name;
        }

        @Override
        public void execute() {
            try {
                String input = Jasic.this.lineIn.readLine();
                try {
                    double value = Double.parseDouble(input);
                    Jasic.this.variables.put(this.name, new NumberValue(value));
                }
                catch (NumberFormatException e) {
                    Jasic.this.variables.put(this.name, new StringValue(input));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class PrintStatement
    implements Statement {
        private final Expression expression;

        public PrintStatement(Expression expression) {
            this.expression = expression;
        }

        @Override
        public void execute() {
            System.out.println(this.expression.evaluate().toString());
        }
    }

    public static interface Expression {
        public Value evaluate();
    }
}

