/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.project.GanttArrow;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.lang.Complement;
import net.sourceforge.plantuml.project.time.Wink;
import net.sourceforge.plantuml.project.timescale.TimeScale;

public class GanttConstraint
implements Complement {
    private final TaskInstant source;
    private final TaskInstant dest;

    public GanttConstraint(TaskInstant source, TaskInstant dest) {
        this.source = source;
        this.dest = dest;
    }

    public String toString() {
        return this.source.toString() + " --> " + this.dest.toString();
    }

    public UDrawable getUDrawable(TimeScale timeScale) {
        return new GanttArrow(timeScale, this.source, this.dest);
    }

    public boolean isHidden(Wink min, Wink max) {
        if (this.isHidden(this.source.getInstantPrecise(), min, max)) {
            return true;
        }
        return this.isHidden(this.dest.getInstantPrecise(), min, max);
    }

    private boolean isHidden(Wink now, Wink min, Wink max) {
        if (now.compareTo(min) < 0) {
            return true;
        }
        return now.compareTo(max) > 0;
    }
}

