/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.DaysAsDates;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.Complement;
import net.sourceforge.plantuml.project.lang.ComplementClose;
import net.sourceforge.plantuml.project.lang.ComplementColors;
import net.sourceforge.plantuml.project.lang.ComplementInColors2;
import net.sourceforge.plantuml.project.lang.ComplementOpen;
import net.sourceforge.plantuml.project.lang.ComplementPattern;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verb;
import net.sourceforge.plantuml.project.lang.VerbPattern;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class VerbIsOrAre
implements VerbPattern {
    @Override
    public Collection<ComplementPattern> getComplements() {
        return Arrays.asList(new ComplementClose(), new ComplementOpen(), new ComplementInColors2());
    }

    @Override
    public IRegex toRegex() {
        return new RegexLeaf("(is|are)");
    }

    @Override
    public Verb getVerb(final GanttDiagram project, RegexResult arg) {
        return new Verb(){

            @Override
            public CommandExecutionResult execute(Subject subject, Complement complement) {
                if (complement instanceof ComplementColors) {
                    HColor color = ((ComplementColors)complement).getCenter();
                    return VerbIsOrAre.this.manageColor(project, subject, color);
                }
                if (complement == ComplementClose.CLOSE) {
                    return VerbIsOrAre.this.manageClose(project, subject);
                }
                if (complement == ComplementOpen.OPEN) {
                    return VerbIsOrAre.this.manageOpen(project, subject);
                }
                return CommandExecutionResult.error("assertion fail");
            }
        };
    }

    private CommandExecutionResult manageColor(GanttDiagram project, Subject subject, HColor color) {
        if (subject instanceof Day) {
            Day day = (Day)subject;
            project.colorDay(day, color);
        }
        if (subject instanceof DaysAsDates) {
            DaysAsDates days = (DaysAsDates)subject;
            for (Day d : days) {
                project.colorDay(d, color);
            }
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult manageClose(GanttDiagram project, Subject subject) {
        if (subject instanceof Day) {
            Day day = (Day)subject;
            project.closeDayAsDate(day);
        }
        if (subject instanceof DaysAsDates) {
            DaysAsDates days = (DaysAsDates)subject;
            for (Day d : days) {
                project.closeDayAsDate(d);
            }
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult manageOpen(GanttDiagram project, Subject subject) {
        if (subject instanceof Day) {
            Day day = (Day)subject;
            project.openDayAsDate(day);
        }
        if (subject instanceof DaysAsDates) {
            DaysAsDates days = (DaysAsDates)subject;
            for (Day d : days) {
                project.openDayAsDate(d);
            }
        }
        return CommandExecutionResult.ok();
    }
}

