/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.Stairs2;
import net.sourceforge.plantuml.sequencediagram.teoz.StairsPosition;

public class EventsHistory {
    private final Participant p;
    private final List<Event> events;
    private final Map<Event, Double> ys3 = new HashMap<Event, Double>();

    public EventsHistory(Participant p, List<Event> events) {
        this.p = p;
        this.events = events;
    }

    public void addStepForLivebox(Event event, double y) {
        this.ys3.put(event, y);
    }

    public Participant getParticipant() {
        return this.p;
    }

    public int getLevelAt(Event event, EventsHistoryMode mode) {
        int result = this.getLevelAtInternal(event, mode);
        return result;
    }

    private int getLevelAtInternal(Event event, EventsHistoryMode mode) {
        int level = 0;
        Iterator<Event> it = this.events.iterator();
        while (it.hasNext()) {
            Event next;
            Event current = it.next();
            if (current instanceof LifeEvent) {
                LifeEvent le = (LifeEvent)current;
                if (le.getParticipant() == this.p && le.isActivate()) {
                    ++level;
                }
                if (le.getParticipant() == this.p && le.isDeactivateOrDestroy()) {
                    --level;
                }
            }
            if (event != current) continue;
            if (current instanceof AbstractMessage && (next = this.nextButSkippingNotes(it)) instanceof LifeEvent) {
                LifeEvent le = (LifeEvent)next;
                AbstractMessage msg = (AbstractMessage)current;
                if (mode != EventsHistoryMode.IGNORE_FUTURE_ACTIVATE && le.isActivate() && msg.dealWith(this.p) && le.getParticipant() == this.p) {
                    ++level;
                }
                if (mode == EventsHistoryMode.CONSIDERE_FUTURE_DEACTIVATE && le.isDeactivateOrDestroy() && msg.dealWith(this.p) && le.getParticipant() == this.p) {
                    --level;
                }
            }
            if (level < 0) {
                return 0;
            }
            return level;
        }
        throw new IllegalArgumentException();
    }

    private boolean isNextEventADestroy(Event event) {
        Iterator<Event> it = this.events.iterator();
        while (it.hasNext()) {
            Event next;
            Event current = it.next();
            if (event != current) continue;
            if (current instanceof Message && (next = this.nextButSkippingNotes(it)) instanceof LifeEvent) {
                LifeEvent le = (LifeEvent)next;
                return le.isDestroy(this.p);
            }
            return false;
        }
        return false;
    }

    private SymbolContext getActivateColor(Event event) {
        LifeEvent le;
        if (event instanceof LifeEvent && (le = (LifeEvent)event).isActivate()) {
            return le.getSpecificColors();
        }
        Iterator<Event> it = this.events.iterator();
        while (it.hasNext()) {
            Event next;
            Event current = it.next();
            if (event != current) continue;
            if (current instanceof Message && (next = this.nextButSkippingNotes(it)) instanceof LifeEvent) {
                LifeEvent le2 = (LifeEvent)next;
                if (le2.isActivate()) {
                    return le2.getSpecificColors();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private Event nextButSkippingNotes(Iterator<Event> it) {
        Event next;
        do {
            if (it.hasNext()) continue;
            return null;
        } while ((next = it.next()) instanceof Note);
        return next;
    }

    public Stairs2 getStairs(double createY, double totalHeight) {
        Stairs2 result = new Stairs2();
        int value = 0;
        for (Event event : this.events) {
            Double position = this.ys3.get(event);
            if (position == null) continue;
            assert (position <= totalHeight) : "position=" + position + " totalHeight=" + totalHeight;
            value = this.getLevelAt(event, EventsHistoryMode.CONSIDERE_FUTURE_DEACTIVATE);
            SymbolContext activateColor = this.getActivateColor(event);
            result.addStep(new StairsPosition(Math.max(createY, position), this.isNextEventADestroy(event)), value, activateColor);
        }
        result.addStep(new StairsPosition(totalHeight, false), value, null);
        return result;
    }

    public int getMaxValue() {
        int max = 0;
        int level = 0;
        for (Event current : this.events) {
            if (!(current instanceof LifeEvent)) continue;
            LifeEvent le = (LifeEvent)current;
            if (le.getParticipant() == this.p && le.isActivate()) {
                ++level;
            }
            if (level > max) {
                max = level;
            }
            if (le.getParticipant() != this.p || !le.isDeactivateOrDestroy()) continue;
            --level;
        }
        return max;
    }
}

