/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.BaseFile;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.NamedOutputStream;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ImageDataAbstract;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierActivity;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierState;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public final class CucaDiagramFileMakerSvek
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;

    public CucaDiagramFileMakerSvek(CucaDiagram diagram) throws IOException {
        this.diagram = diagram;
    }

    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        try {
            return this.createFileInternal(os, dotStrings, fileFormatOption);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    private GeneralImageBuilder createDotDataImageBuilder(DotMode dotMode, StringBounder stringBounder) {
        DotData dotData = new DotData(this.diagram.getEntityFactory().getRootGroup(), this.getOrderedLinks(), this.diagram.getLeafsvalues(), this.diagram.getUmlDiagramType(), this.diagram.getSkinParam(), this.diagram, this.diagram, this.diagram.getColorMapper(), this.diagram.getEntityFactory(), this.diagram.isHideEmptyDescriptionForState(), dotMode, this.diagram.getNamespaceSeparator(), this.diagram.getPragma());
        boolean intricated = this.diagram.mergeIntricated();
        return new GeneralImageBuilder(intricated, dotData, this.diagram.getEntityFactory(), this.diagram.getSource(), this.diagram.getPragma(), stringBounder);
    }

    private ImageData createFileInternal(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        TextBlockBackcolored result;
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            new CucaDiagramSimplifierActivity(this.diagram, dotStrings, fileFormatOption.getDefaultStringBounder());
        } else if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            new CucaDiagramSimplifierState(this.diagram, dotStrings, fileFormatOption.getDefaultStringBounder());
        }
        GeneralImageBuilder svek2 = this.createDotDataImageBuilder(DotMode.NORMAL, fileFormatOption.getDefaultStringBounder());
        BaseFile basefile = null;
        if (fileFormatOption.isDebugSvek() && os instanceof NamedOutputStream) {
            basefile = ((NamedOutputStream)os).getBasefile();
        }
        if ((result = svek2.buildImage(basefile, this.diagram.getDotStringSkek())) instanceof GraphvizCrash) {
            svek2 = this.createDotDataImageBuilder(DotMode.NO_LEFT_RIGHT_AND_XLABEL, fileFormatOption.getDefaultStringBounder());
            result = svek2.buildImage(basefile, this.diagram.getDotStringSkek());
        }
        boolean isGraphvizCrash = result instanceof GraphvizCrash;
        result = new AnnotatedWorker(this.diagram, this.diagram.getSkinParam(), fileFormatOption.getDefaultStringBounder()).addAdd(result);
        String widthwarning = this.diagram.getSkinParam().getValue("widthwarning");
        String warningOrError = null;
        if (widthwarning != null && widthwarning.matches("\\d+")) {
            warningOrError = svek2.getWarningOrError(Integer.parseInt(widthwarning));
        }
        Dimension2D dim = result.calculateDimension(fileFormatOption.getDefaultStringBounder());
        double scale = this.getScale(fileFormatOption, dim);
        ImageBuilder imageBuilder = new ImageBuilder(this.diagram.getSkinParam(), scale, fileFormatOption.isWithMetadata() ? this.diagram.getMetadata() : null, warningOrError, 0.0, 10.0, this.diagram.getAnimation(), result.getBackcolor());
        imageBuilder.setUDrawable(result);
        ImageData imageData = imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.diagram.seed(), os);
        if (isGraphvizCrash) {
            ((ImageDataAbstract)imageData).setStatus(503);
        }
        return imageData;
    }

    private List<Link> getOrderedLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link l : this.diagram.getLinks()) {
            this.addLinkNew(result, l);
        }
        return result;
    }

    private void addLinkNew(List<Link> result, Link link) {
        for (int i = 0; i < result.size(); ++i) {
            Link other = result.get(i);
            if (!other.sameConnections(link)) continue;
            while (i < result.size() && result.get(i).sameConnections(link)) {
                ++i;
            }
            if (i == result.size()) {
                result.add(link);
            } else {
                result.add(i, link);
            }
            return;
        }
        result.add(link);
    }

    private double getScale(FileFormatOption fileFormatOption, Dimension2D dim) {
        Scale diagScale = this.diagram.getScale();
        double scale = diagScale == null ? this.diagram.getScaleCoef(fileFormatOption) : diagScale.getScale(dim.getWidth(), dim.getHeight());
        return scale;
    }
}

