/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.EaterFunctionCall;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;

public class InvokeProcedure
implements TFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%invoke_procedure", 1);
    }

    @Override
    public boolean canCover(int nbArg) {
        return nbArg > 0;
    }

    @Override
    public TFunctionType getFunctionType() {
        return TFunctionType.PROCEDURE;
    }

    @Override
    public void executeProcedure(TContext context, TMemory memory, LineLocation location, String s) throws EaterException, EaterExceptionLocated {
        EaterFunctionCall call = new EaterFunctionCall(new StringLocated(s, location), false, this.isUnquoted());
        call.analyze(context, memory);
        List<TValue> values = call.getValues();
        String fname = values.get(0).toString();
        List<TValue> args = values.subList(1, values.size());
        TFunctionSignature signature = new TFunctionSignature(fname, args.size());
        TFunction func = context.getFunctionSmart(signature);
        if (func == null) {
            throw EaterException.located("Cannot find void function " + fname, new StringLocated(s, location));
        }
        func.executeProcedureInternal(context, memory, args);
    }

    @Override
    public void executeProcedureInternal(TContext context, TMemory memory, List<TValue> args) throws EaterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> args) throws EaterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUnquoted() {
        return false;
    }
}

