from .. import Provider as PersonProvider


class Provider(PersonProvider):
    formats = (
        '{{first_name}} {{last_name}}', '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{prefix}} {{first_name}} {{last_name}}',
        '{{prefix}} {{first_name}} {{last_name}} {{suffix}}',
        '{{first_name}} {{last_name}} {{suffix}}')

    # Thai prefix
    # http://www.stou.ac.th/thai/grad_stdy/Apply/prefix.asp
    prefixes_female = (
        "พลเอก", "พลโท", "พลตรี", "พันเอก", "พันโท", "พันตรี", "ร้อยเอก", "ร้อยโท",
        "ร้อยตรี",
        "จ่าสิบเอก", "จ่าสิบโท", "จ่าสิบตรี", "สิบเอก", "สิบโท", "สิบตรี", "พลทหาร",
        "พลเรือเอก", "พลเรือโท", "พลเรือตรี", "นาวาเอก", "นาวาโท", "นาวาตรี", "เรือเอก",
        "เรือโท", "เรือตรี", "พันจ่าเอก", "พันจ่าโท", "พันจ่าตรี", "จ่าเอก", "จ่าโท",
        "จ่าตรี", "พลทหาร", "พลอากาศเอก", "พลอากาศโท", "พลอากาศตรี", "นาวาอากาศเอก",
        "นาวาอากาศโท", "นาวาอากาศตรี", "เรืออากาศเอก", "เรืออากาศโท", "เรืออากาศตรี",
        "พันจ่าอากาศเอก", "พันจ่าอากาศโท", "พันจ่าอากาศตรี", "จ่าอากาศเอก", "จ่าอากาศโท",
        "จ่าอากาศตรี", "พลทหาร", "พลตำรวจเอก", "พลตำรวจโท", "พลตำรวจตรี", "พันตำรวจเอก",
        "พันตำรวจโท", "พันตำรวจตรี", "ร้อยตำรวจเอก", "ร้อยตำรวจโท", "ร้อยตำรวจตรี",
        "นายดาบตำรวจ", "จ่าสิบตำรวจ", "สิบตำรวจเอก", "สิบตำรวจโท", "สิบตำรวจตรี",
        "พลตำรวจ", "นาง", "นางสาว", "หม่อมหลวง", "หม่อมราชวงศ์", "พล.อ.",
        "พล.ท.", "พล.ต.", "พ.อ.", "พ.ท.", "พ.ต.", "ร.อ.", "ร.ท.", "ร.ต.", "จ.ส.อ.",
        "จ.ส.ท.",
        "จ.ส.ต.", "ส.อ.", "ส.ท.", "ส.ต.", "พลฯ", "พล.ร.อ.", "พล.ร.ท.", "พล.ร.ต.", "น.อ.",
        "น.ท.", "น.ต.", "ร.อ.", "ร.ท.", "ร.ต.", "พ.จ.อ.", "พ.จ.ท.", "พ.จ.ต.", "จ.อ.",
        "จ.ท.",
        "จ.ต.", "พลฯ", "พล.อ.อ.", "พล.อ.ท.", "พล.อ.ต.", "น.อ.", "น.ท.", "น.ต.", "ร.อ.",
        "ร.ท.", "ร.ต.", "พ.อ.อ.", "พ.อ.ท.", "พ.อ.ต.", "จ.อ.", "จ.ท.", "จ.ต.", "พลฯ",
        "พล.ต.อ.", "พล.ต.ท.", "พล.ต.ต.", "พ.ต.อ.", "พ.ต.ท.", "พ.ต.ต.", "ร.ต.อ.", "ร.ต.ท.",
        "ร.ต.ต.", "ด.ต.", "จ.ส.ต.", "ส.ต.อ.", "ส.ต.ท.", "ส.ต.ต.", "พลฯ", "ม.ล.", "ม.ร.ว.")

    prefixes_male = (
        "พลเอก", "พลโท", "พลตรี", "พันเอก", "พันโท", "พันตรี", "ร้อยเอก", "ร้อยโท",
        "ร้อยตรี",
        "จ่าสิบเอก", "จ่าสิบโท", "จ่าสิบตรี", "สิบเอก", "สิบโท", "สิบตรี", "พลทหาร",
        "พลเรือเอก", "พลเรือโท", "พลเรือตรี", "นาวาเอก", "นาวาโท", "นาวาตรี", "เรือเอก",
        "เรือโท", "เรือตรี", "พันจ่าเอก", "พันจ่าโท", "พันจ่าตรี", "จ่าเอก", "จ่าโท",
        "จ่าตรี", "พลทหาร", "พลอากาศเอก", "พลอากาศโท", "พลอากาศตรี", "นาวาอากาศเอก",
        "นาวาอากาศโท", "นาวาอากาศตรี", "เรืออากาศเอก", "เรืออากาศโท", "เรืออากาศตรี",
        "พันจ่าอากาศเอก", "พันจ่าอากาศโท", "พันจ่าอากาศตรี", "จ่าอากาศเอก", "จ่าอากาศโท",
        "จ่าอากาศตรี", "พลทหาร", "พลตำรวจเอก", "พลตำรวจโท", "พลตำรวจตรี", "พันตำรวจเอก",
        "พันตำรวจโท", "พันตำรวจตรี", "ร้อยตำรวจเอก", "ร้อยตำรวจโท", "ร้อยตำรวจตรี",
        "นายดาบตำรวจ", "จ่าสิบตำรวจ", "สิบตำรวจเอก", "สิบตำรวจโท", "สิบตำรวจตรี",
        "พลตำรวจ",
        "นาย", "บาทหลวง", "หม่อมหลวง", "หม่อมราชวงศ์", "สามเณร", "พระ",
        "พระอธิการ", "เจ้าอธิการ", "พระปลัด", "พระสมุห์", "พระใบฎีกา", "พระครูปลัด",
        "พระครูสมุห์", "พระครูใบฎีกา", "พระมหา", "พระครูธรรมธร", "พระครูวินัยธร", "พล.อ.",
        "พล.ท.", "พล.ต.", "พ.อ.", "พ.ท.", "พ.ต.", "ร.อ.", "ร.ท.", "ร.ต.", "จ.ส.อ.",
        "จ.ส.ท.",
        "จ.ส.ต.", "ส.อ.", "ส.ท.", "ส.ต.", "พลฯ", "พล.ร.อ.", "พล.ร.ท.", "พล.ร.ต.", "น.อ.",
        "น.ท.", "น.ต.", "ร.อ.", "ร.ท.", "ร.ต.", "พ.จ.อ.", "พ.จ.ท.", "พ.จ.ต.", "จ.อ.",
        "จ.ท.",
        "จ.ต.", "พลฯ", "พล.อ.อ.", "พล.อ.ท.", "พล.อ.ต.", "น.อ.", "น.ท.", "น.ต.", "ร.อ.",
        "ร.ท.", "ร.ต.", "พ.อ.อ.", "พ.อ.ท.", "พ.อ.ต.", "จ.อ.", "จ.ท.", "จ.ต.", "พลฯ",
        "พล.ต.อ.", "พล.ต.ท.", "พล.ต.ต.", "พ.ต.อ.", "พ.ต.ท.", "พ.ต.ต.", "ร.ต.อ.", "ร.ต.ท.",
        "ร.ต.ต.", "ด.ต.", "จ.ส.ต.", "ส.ต.อ.", "ส.ต.ท.", "ส.ต.ต.", "พลฯ", "ม.ล.", "ม.ร.ว.")

    prefixes = prefixes_female + prefixes_male

    # Chulalongkorn University famous teacher&student first name
    # https://th.wikipedia.org/wiki/%E0%B8%A3%E0%B8%B2%E0%B8%A2%E0%B8%99%E0%B8%B2%E0%B8%A1%E0%B8%9A%E0%B8%B8%E0%B8%84%E0%B8%84%E0%B8%A5%E0%B8%88%E0%B8%B2%E0%B8%81%E0%B8%88%E0%B8%B8%E0%B8%AC%E0%B8%B2%E0%B8%A5%E0%B8%87%E0%B8%81%E0%B8%A3%E0%B8%93%E0%B9%8C%E0%B8%A1%E0%B8%AB%E0%B8%B2%E0%B8%A7%E0%B8%B4%E0%B8%97%E0%B8%A2%E0%B8%B2%E0%B8%A5%E0%B8%B1%E0%B8%A2
    first_names = (
        "ขวัญข้าว", "จักรพงศ์", "วัลลภ", "ธนชัย", "ธนพร", "หม่อมหลวงปิยาภัสร์",
        "นันทวัฒน์", "ภัทร", "ศิริพิชยา", "สุนิดา", "สุรางค์", "หม่อมหลวงสราลี", "อรพรรณ",
        "อัษฎาวุธ", "อิทธิพงศ์", "อดิสรณ์", "เกริก", "กุศล", "กรรณิการ์", "กฤษฎา",
        "กอบชัย", "ชยาวุธ", "ชลอ", "ชนิสาร์", "ชาญชัย", "ชูเกียรติ", "ถาวร", "ณัฐจักร",
        "ณรงค์", "นันทศักดิ์", "ประดิษฐ์", "ปิยะพันธ์", "ยรรยง", "บุญส่ง", "ปรีชา",
        "มิ่งขวัญ", "เลิศศักดิ์", "วัฒนา", "วีระศักดิ์", "สดศรี", "ภูริกูลกฤษฎ์",
        "สุวิชา", "สุธรรม", "อาทิวราห์", "กริช", "กฤชภร", "กฤษดา", "กิจมาโนชญ์",
        "กุลนัดดา", "คมกฤษ", "คีรติ", "จันทรา", "ชนม์ทิดา", "จิระ", "ชลิตา", "ชูเกียรติ",
        "ทรงยศ", "ฉันทวิชช์", "ฉัตรปวีณ์", "ฐิติมา", "ณภศศิ", "ฟองสนาน", "ทรงยศ",
        "ทักษอร", "ธีรัตถ์", "ธิติมา", "ณภศศิ", "นิธิวัฒน์", "นิรมล", "บุญยอด", "บรรจง",
        "ประภัทร์", "ประสงค์", "ประวีณมัย", "ปราโมช", "ปวีณ์สุดา", "ปวีณ์นุช", "ปาณิสรา",
        "ปิยณี", "พัชรศรี", "พันธุ์เลิศ", "พุทธชาด", "ไพบูลย์", "ภัทรวี", "ยงยุทธ",
        "ยุทธนา", "รัชวิน", "วิชชพัชร์", "วันชัย", "หม่อมหลวงวราภา", "วิทยา", "วรรษพร",
        "ศศิวรรณ์", "สุทธิชัย", "สมพล", "สันติ", "สู่ขวัญ", "สายทิพย์", "สายัณห์",
        "สิริยากร", "สุภิญญา", "เสริมคุณ", "สวรรยา", "หฤหรรษ์", "อดิสรณ์", "มาดามมด",
        "ไอยวริญท์", "อรุโณชา", "อ่อนอุษา", "อาภาภัทร", "อเล็กซ์", "อภิชาต", "ปวีณ",
        "เมษ", "ปิยะชาติ", "จารุณี", "ธีมะ", "จักรพันธ์", "ธนพล", "คณาธิป", "กิจมาโนชญ์",
        "ธัญชนก", "พัฒนะชัย", "สุทัตตา", "ภัทร", "รสสุคนธ์", "นิพนธ์", "ธัญญา",
        "ปรัชญานันท์", "กรกันต์", "ปาจรีย์", "พิสิทธิ์", "กฤตยา", "กันต์", "กอบศักดิ์",
        "กานธนิกา", "ขัตติยา", "ชฎาทิพ", "ดวงใจ", "จุฑาวุฒิ", "จันทิมา", "งามนิตย์",
        "เมตตา", "ปริศนา", "ธนะชัย", "ธนันต์ธรญ์", "นวลพรรณ", "นภารัตน์", "เมธินี", "บดี",
        "บุษกร", "ประเวช", "พชร", "พลอย", "ภัทรียา", "ยิ่งพันธ์", "ลักษณา", "เลอศักดิ์",
        "สรสิทธิ์", "สาลินี", "ทองอุไร", "วรุธ", "วิสิฐ", "วศิน", "วรพิศ", "สันติ",
        "สุกัญญา", "สุวิชญ", "เสาวณี", "สุวรรณ", "สามารถ", "สาคร", "สุชาดา", "หิรัญญา",
        "ศุภเดช", "ศรัณย์ทร", "อโนทัย", "อนันต์", "บุญยงค์", "พรรณประภา", "วิชัย",
        "สุรพล", "สมัย", "สำลี", "รอดคล้าย", "สอนตระกูล", "ธรณินทร์", "ศรีหล้า",
        "สิทธิหล่อ", "วัฒนางกูร", "บุหงา", "สมหมาย", "ขัตติยะ", "บุญทอง", "โสภา",
        "ธวัชชัย", "ดารณี", "ศิริพร", "อมรวิชช์", "แขมมณี", "สุนีย์", "ชนิตา", "สมพงษ์",
        "สุนพงษ์ศรี", "ไพฑูรย์", "นงลักษณ์", "ปทีป", "สมหวัง", "วิจิตร", "ธนู", "ธำรง",
        "นายแพทย์", "พิศาล", "คงสง", "เอี่ยมวรวุฒิกุล", "ชินโสภณทรัพย์", "เพ็ชรา",
        "ทองประสม", "พสุธา", "ยุกตะนันทน์", "มธุราสัย", "ชาติสุทธิพันธุ์",
        "หม่อมราชวงศ์อ๊อด", "ประสิทธิ์", "ไตรรัตน์วรกุล", "จีรศักดิ์", "จันศิษย์ยานนท์",
        "สมพร", "ศิริจิตร", "คันธวงศ์", "พาลุสุข", "พหิทธานุกร", "วลัยเสถียร", "จุลพงศธร",
        "ภูมิ", "จุฑานนท์", "เดชรักษา", "ดิสสะมาน", "เชื้อบุญชัย", "สรุโฆษิต", "ชลอ",
        "ปกป้อง", "เหมะรัชตะ", "มันตราภรณ์", "ประยูร", "ไพโรจน์", "ดร.", "ชุติวงศ์",
        "ภักดีธนากุล", "วสันตสิงห์", "นิติสิริ", "จันทรางศุ", "วิชิตชลชัย", "มหาคุณ",
        "อริยะนันทกะ", "ธรรมาพิทักษ์กุล", "มงคลนาวิน", "สุรเกียรติ์", "ติงสมิตร", "ฤทัย",
        "เมฆเกรียงไกร", "เกรียงไกร", "สุนีย์", "วีระพงษ์", "นันทวัฒน์", "ศักดา",
        "บวรศักดิ์", "วิษณุ", "อุรพีพัฒนพงศ์", "เขมะจารุ", "สุชีวะ", "ลัดพลี",
        "โฆวิไลกูล", "ดิษฐอำนาจ", "สัจจวานิช", "พานิชวงศ์", "ไตรประสิทธิ์", "ฉ่ำเฉลิม",
        "ภัทราคม", "ไพศิษฐ์", "คณิต", "สุนทร", "หยุด", "อมร", "โกเมน", "ฦาไชย",
        "กิตติพงษ์", "มาศดิตถ์", "มาลีนนท์", "ตั้งพูลสินธนา", "รัตนนาคินทร์",
        "หม่อมหลวงวิฏราธร", "ประกอบผล", "เตชานันท์", "วิรุฬห์รักษ์", "ประเสริฐสกุล",
        "สุดบรรทัด", "สถาปิตานนท์", "เบ็ญจรงค์กิจ", "ปั้นเหน่งเพ็ชร์", "รอดคำดี",
        "ทองมีอาคม", "ศิริยุวศักดิ์", "ชลวิไล", "ปราสาททองโอสถ", "เกยุราพันธุ์", "เมณฑกา",
        "วีระเมธีกุล", "สมะลาภา", "ทองปาน", "แสงสนิท", "คุณพนิชกิจ", "ปานะนนท์",
        "สามโกเศศ", "บุนนาค", "วีรวรรณ", "สุทธิวาทนฤพุฒิ", "ธัญลักษณ์ภาคย์", "วรรธนะสิน",
        "รุนสำราญ", "กรัยวิเชียร", "บัญชี", "เมาลานนท์", "อภิเมธีธำรง", "สุชาดา",
        "จันทร์ฉาย", "ตันละมัย", "กรพรหม", "จันทรลาวัณย์", "ดวงเนตร", "เจริญเศรษฐศิลป์",
        "ลี่สถาพรวงศา", "เจียมบุญศรี", "อัถโถปกรณ์", "เมฆธน", "วลีอิทธิกุล",
        "ศรีประพันธ์", "พระครูปลัดสุวัฒนโพธิคุณ", "มโน", "นลินี", "บุรพรัตน์",
        "ตัณฑ์ไพโรจน์", "มานพ", "เสาวภาพ", "ณรงค์", "ตันตยาภรณ์", "ชีวะเกตุ",
        "สัณฑ์พิทักษ์", "โปษยะจินดา", "อัมพร", "ชัยชน", "มหาทุมะรัตน์", "ประภัสสราทร",
        "เหมะจุฑา", "ตัณฑวิเชียร", "ลิ้มสุวรรณ", "เทียนบุญ", "ปิยะรัตน์", "ภู่วรวรรณ",
        "ศุภจัตุรัส", "โชติเลอศักดิ์", "บุณยะโหตระ", "กสานติกุล", "ลิ้มพงศานุรักษ์",
        "อนุราษฎร์", "จิตต์มิตรภาพ", "สุวรรณเวลา", "สิทธีอมร", "อ่องจริต", "ดุสิตสิน",
        "ภานุภาค", "ฟูตระกูล", "โปษยะจินดา", "สิตปรีชา", "ช่วงโชติ", "ศรีจิตรา", "ประมวล",
        "บุญเชียร", "หงศ์ลดารมภ์", "รามสูต", "อึ้งถาวร", "วาทีสาธกกิจ", "สันติไชยกุล")

    # last name that has given by senior officer
    # http://www.reurnthai.com/index.php?topic=5273.45
    last_names = (
        "ดำริห์ชอบ", "ดวงทับทิม", "ดิศดใน", "ดัตพันธุ์", "ดุษฎีวนิช", "ดาบเพ็ชร์",
        "ดิสกะประกาย", "เดชคุ้ม", "ดาวกระจาย", "ดาบเงิน", "ดีตพันธุ์", "ดุริยพันธุ์",
        "ดาวอร่าม", "เดชวา", "ติระคมน์", "ไตรบรรพ", "ตระกูลบุญ", "เตมิยะเดช", "ตวงทอง",
        "แต้กุล", "ตรีครุธพันธุ์", "ตัณฑนุช", "ตั้งกุลงาม", "ตระกูลไม้เรียง", "ตะละภัฏ",
        "ตั้งเผ่า", "ตันเผ่า", "เตชะกำพุ", "ตัณสถิตย์", "ตราชู", "ตวันเยี่ยม",
        "ตรีเภรินทร์",
        "ตันตราจิณ", "ตั้งรบ", "ถนัดกลึง", "ถนอมมนุษย์", "ถนัดอักษร", "ถนัดการยนต์",
        "ถนัดหัดถกรรม", "ถาวรายุศม์", "ถนัดการเขียน", "ถาวรรัตน", "ถนัดพิมพการ",
        "ถ้วนศรี",
        "ถนอมพล", "ถาวระวรณ์", "ถนัดรบ", "ถนอมกุลบุตร", "ถมปัด", "ถนัดภาษา",
        "ถนัดเดินข่าว",
        "ถนัดรักษา", "ถนิมมาศ", "ถมังรักษสัตว์", "แถมธน", "ถะเกิงชศ", "ถิรสวัสดิ์",
        "ถนัดอาวุธ", "ถุงเงิน", "ทุมะบุตร์", "ทองประดิฐ", "ทรงโกมล", "ทัศนสุทธิ",
        "ทหารแท้",
        "ทองอยู่", "ทำประดู่", "ทรัพย์สาร", "ทีฆะ", "ทวนทอง", "ไทยสุชาต", "ทันยุค",
        "ไทนิยม",
        "ทองลาภ", "ทองเนื้อดี", "ทองแท้", "ทวีเดช", "ทับทิมไทย", "ทองสินธุ์", "ไทไชโย",
        "ทวนไชย์", "ทองสุกเลิศ", "ไทยแท้", "ทองสีไพล", "ธรรมนิยม", "ธนประทีป", "ธรรมเมธา",
        "ธุวะนุติ์", "ธาราธร", "ธีวร", "ธัญเสถียร", "ธนูปกรณ์", "เธียรายัน", "ธรรมฤดี",
        "ธัญาโภชน์", "ธนรักษ์", "ธูปะวิโรจน์", "ธูปหอม", "แนวพนิช", "นักสำหรวจ",
        "นฤทุกข์",
        "นาฏคายี", "เนื่องนนท์", "น้ำทิพย์", "เนื้อนุ่ม", "นวลฉวี", "นาคพันธุ์", "นำธวัช",
        "แน่นดุจป้อม", "เณรานุสนธิ์", "นามเสวตร", "นิษประปัญจ์", "นิระหานี", "นิลสุวรรณ์",
        "นักรบ", "นิติสาขา", "นิยมธรรม", "นิลเสนา", "หนุนสุข", "นิลวิมล", "นฤภัย",
        "นาถะเดชะ",
        "นพตระกูล", "นิยมเซียม", "หนักแน่น", "นามขำ", "นานายน", "นับเนื่องนอ", "แนวพญา",
        "นาถะพินธุ", "นิลสลัว", "นะวะมันดร", "นิลวรรณ", "เนตร์มณี", "นุตตาร",
        "นิยมสำหรวจ",
        "นกทอง", "นุชแนวนุ่ม", "นาคสุทิน", "นพคเชนทร์", "นาคะนคร", "นิละทัต", "นาควงษ์",
        "นากกนก", "บุนยาภิสนท์", "บุญญาภิรมย์", "บุณยะภาชน์", "บินดี", "บุนยะศัพท์",
        "บุนยะตีรณะ", "บุญญาไลย์", "บุญบำรุง")

    # thai suffix that has given by the king
    # https://th.wikipedia.org/wiki/%E0%B8%99%E0%B8%B2%E0%B8%A1%E0%B8%AA%E0%B8%81%E0%B8%B8%E0%B8%A5%E0%B8%9E%E0%B8%A3%E0%B8%B0%E0%B8%A3%E0%B8%B2%E0%B8%8A%E0%B8%97%E0%B8%B2%E0%B8%99
    suffixes = (
        "ณ กาฬสินธุ์",
        "ณ จัมปาศักดิ์",
        "ณ เชียงใหม่",
        "ณ ตะกั่วทุ่ง",
        "ณ ถลาง",
        "ณ นคร",
        "ณ น่าน",
        "ณ บางช้าง",
        "ณ ป้อมเพชร์",
        "ณ พัทลุง",
        "ณ พิศณุโลก",
        "ณ มโนรม",
        "ณ มหาไชย",
        "ณ ร้อยเอ็จ",
        "ณ ระนอง",
        "ณ ลำปาง",
        "ณ ลำพูน",
        "ณ วิเชียร",
        "ณ สงขลา",
        "ณ หนองคาย",
        "ณ อุบล")
