/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalMapping;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public final class GlobalOrdinalsIndexFieldData
extends AbstractIndexComponent
implements IndexOrdinalsFieldData,
Accountable {
    private final String fieldName;
    private final long memorySizeInBytes;
    private final OrdinalMap ordinalMap;
    private final LeafOrdinalsFieldData[] segmentAfd;
    private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;

    protected GlobalOrdinalsIndexFieldData(IndexSettings indexSettings, String fieldName, LeafOrdinalsFieldData[] segmentAfd, OrdinalMap ordinalMap, long memorySizeInBytes, Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        super(indexSettings);
        this.fieldName = fieldName;
        this.memorySizeInBytes = memorySizeInBytes;
        this.ordinalMap = ordinalMap;
        this.segmentAfd = segmentAfd;
        this.scriptFunction = scriptFunction;
    }

    public IndexOrdinalsFieldData newConsumer(DirectoryReader source) {
        return new Consumer(source, this.indexSettings);
    }

    @Override
    public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        throw new IllegalStateException("loadDirect(LeafReaderContext) should not be called in this context");
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        return this;
    }

    @Override
    public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        return this;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new UnsupportedOperationException("no global ordinals sorting yet");
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    @Override
    public void clear() {
    }

    public long ramBytesUsed() {
        return this.memorySizeInBytes;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public LeafOrdinalsFieldData load(LeafReaderContext context) {
        throw new IllegalStateException("load(LeafReaderContext) should not be called in this context");
    }

    @Override
    public OrdinalMap getOrdinalMap() {
        return this.ordinalMap;
    }

    @Override
    public boolean supportsGlobalOrdinalsMapping() {
        return true;
    }

    public class Consumer
    extends AbstractIndexComponent
    implements IndexOrdinalsFieldData,
    Accountable {
        private final DirectoryReader source;
        private TermsEnum[] lookups;

        Consumer(DirectoryReader source, IndexSettings settings) {
            super(settings);
            this.source = source;
        }

        private TermsEnum[] getOrLoadTermsEnums() {
            if (this.lookups == null) {
                this.lookups = new TermsEnum[GlobalOrdinalsIndexFieldData.this.segmentAfd.length];
                for (int i = 0; i < this.lookups.length; ++i) {
                    try {
                        this.lookups[i] = GlobalOrdinalsIndexFieldData.this.segmentAfd[i].getOrdinalsValues().termsEnum();
                        continue;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to load terms enum", e);
                    }
                }
            }
            return this.lookups;
        }

        @Override
        public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
            return this.load(context);
        }

        @Override
        public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
            return this;
        }

        @Override
        public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
            return this;
        }

        @Override
        public String getFieldName() {
            return GlobalOrdinalsIndexFieldData.this.fieldName;
        }

        @Override
        public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
            throw new UnsupportedOperationException("no global ordinals sorting yet");
        }

        @Override
        public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
            throw new IllegalArgumentException("only supported on numeric fields");
        }

        @Override
        public void clear() {
        }

        public long ramBytesUsed() {
            return GlobalOrdinalsIndexFieldData.this.memorySizeInBytes;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        @Override
        public LeafOrdinalsFieldData load(final LeafReaderContext context) {
            assert (this.source.getReaderCacheHelper().getKey() == context.parent.reader().getReaderCacheHelper().getKey());
            return new AbstractLeafOrdinalsFieldData(GlobalOrdinalsIndexFieldData.this.scriptFunction){

                @Override
                public SortedSetDocValues getOrdinalsValues() {
                    SortedSetDocValues values = GlobalOrdinalsIndexFieldData.this.segmentAfd[context.ord].getOrdinalsValues();
                    if (values.getValueCount() == GlobalOrdinalsIndexFieldData.this.ordinalMap.getValueCount()) {
                        return values;
                    }
                    TermsEnum[] atomicLookups = Consumer.this.getOrLoadTermsEnums();
                    return new GlobalOrdinalMapping(GlobalOrdinalsIndexFieldData.this.ordinalMap, values, atomicLookups, context.ord);
                }

                public long ramBytesUsed() {
                    return GlobalOrdinalsIndexFieldData.this.segmentAfd[context.ord].ramBytesUsed();
                }

                public Collection<Accountable> getChildResources() {
                    return GlobalOrdinalsIndexFieldData.this.segmentAfd[context.ord].getChildResources();
                }

                @Override
                public void close() {
                }
            };
        }

        @Override
        public boolean supportsGlobalOrdinalsMapping() {
            return true;
        }

        @Override
        public OrdinalMap getOrdinalMap() {
            return GlobalOrdinalsIndexFieldData.this.ordinalMap;
        }
    }
}

