package PPPUsage::Res2Term;

# provides:
#
# results2term ($datafile)

use strict;
use Exporter;
use PPPUsage::Query;
use PPPUsage::Version;

use vars qw(@EXPORT @ISA);

@ISA    = qw(Exporter);
@EXPORT = qw(results2term);

# -----> results2term ($datafile)
#
# Calls query($datafile) and prints the returned data to STDOUT.
# Returns 0 on success.
#
sub results2term {

	my ($sum,$months,$mm_sums) = query(shift);

	my $me      = $main::me;
	my $ansis   = $main::opt_b;
	my $version = $VERSION;

	my $line    = "--------------------";
	my $dline   = "====================";
	my $norm    = $ansis ? '' : "\e[00m";
	my $bold    = $ansis ? '' : "\e[01m";
	my $blue    = $ansis ? '' : "\e[34m";
	my $red     = $ansis ? '' : "\e[31m";

	print <<"EOF";

$blue$line$line$line$norm

 $red***$norm $bold$me $version$norm $red***$norm

 $blue$dline$dline$norm
 $sum->{'fy'}-$sum->{'fm'}-$sum->{'fd'} to $sum->{'ly'}-$sum->{'lm'}-$sum->{'ld'}
 $blue$dline$dline$norm

$bold Total Connections:$norm   $sum->{'connects'}
$bold Total Online Time:$norm   $sum->{'time_t'}
$bold Time / Connection:$norm   $sum->{'time_c'}

$bold Kilobytes received:$norm  $sum->{'i_k'}
$bold Megabytes received:$norm  $sum->{'i_m'}
$bold Gigabytes received:$norm  $sum->{'i_g'}

$bold Kilobytes sent:$norm      $sum->{'o_k'}
$bold Megabytes sent:$norm      $sum->{'o_m'}
$bold Gigabytes sent:$norm      $sum->{'o_g'}

$bold Kilobytes TOTAL:$norm     $sum->{'t_k'}
$bold Megabytes TOTAL:$norm     $sum->{'t_m'}
$bold Gigabytes TOTAL:$norm     $red$sum->{'t_g'}$norm
EOF

	# show some monthly statistics if we're looking
	# at data for more than one month

	if (@$months > 1) {

	print <<"EOF";

 $blue$dline$dline$norm
 AVERAGE PER MONTH
 $blue$dline$dline$norm

$bold Kilobytes TOTAL:$norm     $sum->{'m_av_k'}
$bold Megabytes TOTAL:$norm     $sum->{'m_av_m'}
$bold Gigabytes TOTAL:$norm     $red$sum->{'m_av_g'}$norm

 $blue$dline$dline$norm
 MONTHLY TOTALS
 $blue$dline$dline$norm

EOF

		foreach (@$months) {

			print  "$bold $_:$norm             ";
			printf("$red%.1f$norm Gigabyte\n",
			        $mm_sums->{$_}/(1024*1024*1024));
		}
	}

	print "\n$blue$line$line$line$norm\n\n";

	return 0;
}

1;
