/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss2.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.krss2.renderer.KRSS2Vocabulary;
import org.semanticweb.owlapi.krss2.renderer.KRSSObjectRenderer;
import org.semanticweb.owlapi.krss2.renderer.KRSSVocabulary;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;

public class KRSS2ObjectRenderer
extends KRSSObjectRenderer {
    @Nonnull
    private final Set<OWLSubPropertyChainOfAxiom> leftRightIdentityUsed = new HashSet<OWLSubPropertyChainOfAxiom>();
    protected boolean ignoreDeclarations = false;

    public KRSS2ObjectRenderer(@Nonnull OWLOntology ontology, @Nonnull Writer writer) {
        super(ontology, writer);
    }

    public void setIgnoreDeclarations(boolean ignoreDeclarations) {
        this.ignoreDeclarations = ignoreDeclarations;
    }

    protected void write(KRSS2Vocabulary v) {
        this.write(v.toString());
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.reset();
        for (OWLClass eachClass : ontology.getClassesInSignature()) {
            if (this.ignoreDeclarations && ontology.getAxioms(eachClass, Imports.EXCLUDED).size() == 1 && ontology.getDeclarationAxioms(eachClass).size() == 1) continue;
            boolean primitive = !EntitySearcher.isDefined(eachClass, ontology);
            this.writeOpenBracket();
            if (primitive) {
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_CONCEPT);
                this.write(eachClass);
                this.writeSpace();
                Collection axioms = ontology.filterAxioms(Filters.subClassWithSub, eachClass, Imports.INCLUDED);
                this.flatten(Searcher.sup(axioms, OWLClassExpression.class), KRSSVocabulary.AND);
                this.writeCloseBracket();
                this.writeln();
                Collection<OWLClassExpression> classes = Searcher.equivalent(ontology.getEquivalentClassesAxioms(eachClass), OWLClassExpression.class);
                for (OWLClassExpression description : classes) {
                    this.writeOpenBracket();
                    this.write(eachClass);
                    this.write(KRSS2Vocabulary.EQUIVALENT);
                    this.write(description);
                    this.writeCloseBracket();
                    this.writeln();
                }
                continue;
            }
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_CONCEPT);
            this.write(eachClass);
            Collection<OWLClassExpression> classes = Searcher.equivalent(ontology.getEquivalentClassesAxioms(eachClass), OWLClassExpression.class);
            this.flatten(classes, KRSSVocabulary.AND);
            this.writeCloseBracket();
            this.writeln();
            Collection<OWLClassExpression> supclasses = Searcher.sup(ontology.getSubClassAxiomsForSubClass(eachClass), OWLClassExpression.class);
            for (OWLClassExpression description : supclasses) {
                this.writeOpenBracket();
                this.write(eachClass);
                this.write(KRSS2Vocabulary.IMPLIES);
                this.write(description);
                this.writeCloseBracket();
                this.writeln();
            }
        }
        for (OWLObjectProperty property : KRSS2ObjectRenderer.sort(ontology.getObjectPropertiesInSignature())) {
            Collection<OWLClassExpression> desc;
            Iterator<OWLObjectPropertyExpression> inverses;
            if (this.ignoreDeclarations && ontology.getAxioms((OWLObjectPropertyExpression)property, Imports.EXCLUDED).size() == 1 && ontology.getDeclarationAxioms(property).size() == 1) continue;
            this.writeOpenBracket();
            Collection<OWLObjectPropertyExpression> properties = Searcher.equivalent(ontology.getEquivalentObjectPropertiesAxioms(property));
            boolean isPrimitive = properties.isEmpty();
            if (isPrimitive) {
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_ROLE);
                this.write(property);
                Collection axioms = ontology.filterAxioms(Filters.subObjectPropertyWithSub, property, Imports.INCLUDED);
                Collection<OWLObjectPropertyExpression> superProperties = Searcher.sup(axioms, OWLObjectPropertyExpression.class);
                int superSize = superProperties.size();
                if (superSize == 1) {
                    this.writeSpace();
                    this.write(KRSS2Vocabulary.PARENT_ATTR);
                    this.writeSpace();
                    this.write(superProperties.iterator().next());
                } else if (superSize > 1) {
                    this.writeSpace();
                    this.write(KRSS2Vocabulary.PARENTS_ATTR);
                    this.writeSpace();
                    this.flattenProperties(superProperties, null);
                } else {
                    Set<OWLSubPropertyChainOfAxiom> chainAxioms = this.getPropertyChainSubPropertyAxiomsFor(property);
                    if (chainAxioms.size() == 1) {
                        OWLSubPropertyChainOfAxiom axiom = chainAxioms.iterator().next();
                        if (KRSS2ObjectRenderer.isLeftIdentityAxiom(axiom, property)) {
                            this.leftRightIdentityUsed.add(axiom);
                            this.writeSpace();
                            this.write(KRSS2Vocabulary.LEFTIDENTITY_ATTR);
                            this.write(axiom.getPropertyChain().get(0));
                        } else if (KRSS2ObjectRenderer.isRightIdentityAxiom(axiom, property)) {
                            this.leftRightIdentityUsed.add(axiom);
                            this.writeSpace();
                            this.write(KRSS2Vocabulary.RIGHTIDENTITY_ATTR);
                            this.write(axiom.getPropertyChain().get(1));
                        }
                    }
                }
            } else if (properties.isEmpty()) {
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_ROLE);
                this.write(property);
                this.writeSpace();
            } else {
                this.write(KRSS2Vocabulary.DEFINE_ROLE);
                this.write(property);
                OWLObjectPropertyExpression expr = properties.iterator().next();
                this.write(expr);
                properties.remove(expr);
                this.writeSpace();
            }
            if (EntitySearcher.isTransitive((OWLObjectPropertyExpression)property, ontology)) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRANSITIVE_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (EntitySearcher.isSymmetric((OWLObjectPropertyExpression)property, ontology)) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.SYMMETRIC_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (EntitySearcher.isReflexive((OWLObjectPropertyExpression)property, ontology)) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.REFLEXIVE_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (!(inverses = Searcher.inverse(ontology.getInverseObjectPropertyAxioms(property), property).iterator()).hasNext()) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.INVERSE_ATTR);
                this.write(inverses.next());
            }
            if (!(desc = Searcher.domain(ontology.getObjectPropertyDomainAxioms(property))).isEmpty()) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.DOMAIN_ATTR);
                this.flatten(desc, KRSSVocabulary.AND);
            }
            if (!(desc = Searcher.range(ontology.getObjectPropertyRangeAxioms(property))).isEmpty()) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.RANGE_ATTR);
                this.flatten(desc, KRSSVocabulary.AND);
            }
            this.writeCloseBracket();
            this.writeln();
            while (inverses.hasNext()) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.INVERSE);
                this.write(property);
                this.write(inverses.next());
                this.writeOpenBracket();
                this.writeln();
            }
            for (OWLObjectPropertyExpression expr : properties) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.ROLES_EQUIVALENT);
                this.write(property);
                this.write(expr);
                this.writeCloseBracket();
                this.writeln();
            }
        }
        for (OWLNamedIndividual individual : KRSS2ObjectRenderer.sort(ontology.getIndividualsInSignature())) {
            if (this.ignoreDeclarations && ontology.getAxioms((OWLIndividual)individual, Imports.EXCLUDED).size() == 1 && ontology.getDeclarationAxioms(individual).size() == 1) continue;
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_INDIVIDUAL);
            this.write(individual);
            this.writeCloseBracket();
            this.writeln();
        }
        for (OWLAxiom axiom : ontology.getAxioms()) {
            axiom.accept(this);
        }
        try {
            this.writer.flush();
        }
        catch (IOException io) {
            throw new OWLRuntimeException(io);
        }
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        if (!(axiom.getSubClass() instanceof OWLClass)) {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.IMPLIES);
            this.write(axiom.getSubClass());
            this.write(axiom.getSuperClass());
            this.writeCloseBracket();
            this.writeln();
        }
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        List<OWLClassExpression> descs = KRSS2ObjectRenderer.sort(axiom.getClassExpressions());
        int size = descs.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.DISJOINT);
                this.write(descs.get(i));
                this.write(descs.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        List properties = KRSS2ObjectRenderer.sort(axiom.getProperties());
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.ROLES_EQUIVALENT);
                this.write((OWLPropertyExpression)properties.get(i));
                this.write((OWLPropertyExpression)properties.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        List properties = KRSS2ObjectRenderer.sort(axiom.getProperties());
        int size = properties.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.DISJOINT_ROLES);
                this.write((OWLPropertyExpression)properties.get(i));
                this.write((OWLPropertyExpression)properties.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.write(KRSS2Vocabulary.RELATED);
        this.write(axiom.getSubject());
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.write((OWLIndividual)axiom.getObject());
        this.writeln();
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        if (!(axiom.getSubProperty() instanceof OWLObjectProperty)) {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.IMPLIES_ROLE);
            this.write((OWLPropertyExpression)axiom.getSubProperty());
            this.write((OWLPropertyExpression)axiom.getSuperProperty());
            this.writeCloseBracket();
            this.writeln();
        }
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        List<OWLClassExpression> descriptions = KRSS2ObjectRenderer.sort(axiom.getClassExpressions());
        int size = descriptions.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.EQUIVALENT);
                this.write(descriptions.get(i));
                this.write(descriptions.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        if (this.leftRightIdentityUsed.contains(axiom)) {
            return;
        }
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ROLE_INCLUSTION);
        this.writeSpace();
        this.writeChain(axiom.getPropertyChain(), 0);
        this.writeSpace();
        this.write(axiom.getSuperProperty());
        this.writeCloseBracket();
        this.writeln();
    }

    protected void writeChain(List<OWLObjectPropertyExpression> expressions, int i) {
        if (i == expressions.size() - 1) {
            this.write(expressions.get(i));
        } else {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.COMPOSE);
            this.write(expressions.get(i));
            this.writeChain(expressions, i + 1);
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.INVERSE);
        axiom.getFirstProperty().accept(this);
        axiom.getSecondProperty().accept(this);
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public void visit(OWLClass desc) {
        this.write(desc.getIRI());
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ONE_OF);
        for (OWLIndividual individual : ce.getIndividuals()) {
            assert (individual != null);
            this.write(individual);
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.write(property.getIRI());
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.INV);
        this.writeSpace();
        property.getInverseProperty();
        property.getInverse().accept(this);
        this.writeCloseBracket();
    }

    protected static boolean isLeftIdentityAxiom(OWLSubPropertyChainOfAxiom axiom, OWLObjectProperty property) {
        Iterator<OWLObjectPropertyExpression> chain;
        if (axiom.getSuperProperty().equals(property) && (chain = axiom.getPropertyChain().iterator()).hasNext() && chain.next() instanceof OWLObjectProperty && chain.hasNext() && chain.next().equals(property)) {
            return !chain.hasNext();
        }
        return false;
    }

    protected static boolean isRightIdentityAxiom(OWLSubPropertyChainOfAxiom axiom, OWLObjectProperty property) {
        Iterator<OWLObjectPropertyExpression> chain;
        if (axiom.getSuperProperty().equals(property) && (chain = axiom.getPropertyChain().iterator()).hasNext() && chain.next().equals(property) && chain.hasNext()) {
            chain.next();
            return !chain.hasNext();
        }
        return false;
    }

    protected Set<OWLSubPropertyChainOfAxiom> getPropertyChainSubPropertyAxiomsFor(OWLPropertyExpression property) {
        HashSet<OWLSubPropertyChainOfAxiom> axioms = new HashSet<OWLSubPropertyChainOfAxiom>();
        for (OWLSubPropertyChainOfAxiom axiom : this.ont.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
            if (!axiom.getSuperProperty().equals(property)) continue;
            axioms.add(axiom);
        }
        return axioms;
    }

    protected void reset() {
        this.leftRightIdentityUsed.clear();
    }
}

