/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeViews;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class CacheObservers<T>
implements FileTreeDataViews.CacheObserver<T>,
AutoCloseable {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Map<Integer, FileTreeDataViews.CacheObserver<T>> observers = new LinkedHashMap<Integer, FileTreeDataViews.CacheObserver<T>>();

    CacheObservers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreate(FileTreeDataViews.Entry<T> entry) {
        ArrayList<FileTreeDataViews.CacheObserver<T>> arrayList;
        Object object = this.observers;
        synchronized (object) {
            arrayList = new ArrayList<FileTreeDataViews.CacheObserver<T>>(this.observers.values());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                ((FileTreeDataViews.CacheObserver)object.next()).onCreate(entry);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete(FileTreeDataViews.Entry<T> entry) {
        ArrayList<FileTreeDataViews.CacheObserver<T>> arrayList;
        Object object = this.observers;
        synchronized (object) {
            arrayList = new ArrayList<FileTreeDataViews.CacheObserver<T>>(this.observers.values());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                ((FileTreeDataViews.CacheObserver)object.next()).onDelete(entry);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(FileTreeDataViews.Entry<T> entry, FileTreeDataViews.Entry<T> entry2) {
        ArrayList<FileTreeDataViews.CacheObserver<T>> arrayList;
        Object object = this.observers;
        synchronized (object) {
            arrayList = new ArrayList<FileTreeDataViews.CacheObserver<T>>(this.observers.values());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                ((FileTreeDataViews.CacheObserver)object.next()).onUpdate(entry, entry2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(IOException iOException) {
        ArrayList<FileTreeDataViews.CacheObserver<T>> arrayList;
        Object object = this.observers;
        synchronized (object) {
            arrayList = new ArrayList<FileTreeDataViews.CacheObserver<T>>(this.observers.values());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((FileTreeDataViews.CacheObserver)object.next()).onError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addObserver(FileTreeViews.Observer<? super FileTreeDataViews.Entry<T>> observer) {
        int n = this.counter.getAndIncrement();
        Map<Integer, FileTreeDataViews.CacheObserver<T>> map = this.observers;
        synchronized (map) {
            this.observers.put(n, CacheObservers.fromObserver(observer));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addCacheObserver(FileTreeDataViews.CacheObserver<T> cacheObserver) {
        int n = this.counter.getAndIncrement();
        Map<Integer, FileTreeDataViews.CacheObserver<T>> map = this.observers;
        synchronized (map) {
            this.observers.put(n, cacheObserver);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObserver(int n) {
        Map<Integer, FileTreeDataViews.CacheObserver<T>> map = this.observers;
        synchronized (map) {
            this.observers.remove(n);
        }
    }

    @Override
    public void close() {
        this.observers.clear();
    }

    static <T> FileTreeDataViews.CacheObserver<T> fromObserver(final FileTreeViews.Observer<? super FileTreeDataViews.Entry<T>> observer) {
        return new FileTreeDataViews.CacheObserver<T>(){

            @Override
            public void onCreate(FileTreeDataViews.Entry<T> entry) {
                observer.onNext(entry);
            }

            @Override
            public void onDelete(FileTreeDataViews.Entry<T> entry) {
                observer.onNext(entry);
            }

            @Override
            public void onUpdate(FileTreeDataViews.Entry<T> entry, FileTreeDataViews.Entry<T> entry2) {
                observer.onNext(entry2);
            }

            @Override
            public void onError(IOException iOException) {
                observer.onError(iOException);
            }
        };
    }
}

