/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CompositeFoldingBuilder
extends FoldingBuilderEx
implements PossiblyDumbAware {
    private final List<? extends FoldingBuilder> myBuilders;

    CompositeFoldingBuilder(List<? extends FoldingBuilder> builders) {
        this.myBuilders = builders;
    }

    @Override
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root2, @NotNull Document document, boolean quick) {
        if (root2 == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<FoldingDescriptorWrapper> descriptors = new ArrayList<FoldingDescriptorWrapper>();
        HashSet<TextRange> rangesCoveredByDescriptors = new HashSet<TextRange>();
        for (FoldingBuilder foldingBuilder : DumbService.getInstance(root2.getProject()).filterByDumbAwareness(this.myBuilders)) {
            for (FoldingDescriptor descriptor2 : LanguageFolding.buildFoldingDescriptorsNoPlaceholderCaching(foldingBuilder, root2, document, quick)) {
                if (!rangesCoveredByDescriptors.add(descriptor2.getRange())) continue;
                descriptors.add(new FoldingDescriptorWrapper(descriptor2, foldingBuilder));
            }
        }
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(4);
        }
        return node.getText();
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(5);
        }
        return node.getText();
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(6);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.myBuilders;
    }

    @Override
    public boolean isDumbAware() {
        for (FoldingBuilder foldingBuilder : this.myBuilders) {
            if (!DumbService.isDumbAware(foldingBuilder)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/folding/CompositeFoldingBuilder";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/folding/CompositeFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mayUseBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProjectByNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalBuilder";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class FoldingDescriptorWrapper
    extends FoldingDescriptor {
        @NotNull
        private final FoldingDescriptor myFoldingDescriptor;
        @NotNull
        private final FoldingBuilder myBuilder;

        FoldingDescriptorWrapper(@NotNull FoldingDescriptor foldingDescriptor, @NotNull FoldingBuilder builder) {
            if (foldingDescriptor == null) {
                FoldingDescriptorWrapper.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                FoldingDescriptorWrapper.$$$reportNull$$$0(1);
            }
            super(foldingDescriptor.getElement(), foldingDescriptor.getRange(), foldingDescriptor.getGroup(), foldingDescriptor.getDependencies(), foldingDescriptor.isNonExpandable(), foldingDescriptor.getCachedPlaceholderText(), foldingDescriptor.isCollapsedByDefault());
            this.myFoldingDescriptor = foldingDescriptor;
            this.myBuilder = builder;
        }

        @Override
        @NotNull
        public Set<Object> getDependencies() {
            Set<Object> set = this.myFoldingDescriptor.getDependencies();
            if (set == null) {
                FoldingDescriptorWrapper.$$$reportNull$$$0(2);
            }
            return set;
        }

        @Override
        public void setCanBeRemovedWhenCollapsed(boolean canBeRemovedWhenCollapsed) {
            this.myFoldingDescriptor.setCanBeRemovedWhenCollapsed(canBeRemovedWhenCollapsed);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foldingDescriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/folding/CompositeFoldingBuilder$FoldingDescriptorWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/folding/CompositeFoldingBuilder$FoldingDescriptorWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

