/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00140\u000fH\u0002J\u0016\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationResolver;", "", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "checkRedeclarations", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkRedeclarationsInPackages", "topLevelDescriptorProvider", "Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;", "topLevelFqNames", "Lcom/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getTopLevelDescriptorsByFqName", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "fqName", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "reportRedeclarationsWithClassifiers", "descriptorMap", "Lorg/jetbrains/kotlin/name/Name;", "resolveAnnotationsOnFiles", "scopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "frontend"})
public final class DeclarationResolver {
    private final AnnotationResolver annotationResolver;
    private final BindingTrace trace;

    /*
     * WARNING - void declaration
     */
    public final void resolveAnnotationsOnFiles(@NotNull TopDownAnalysisContext c, @NotNull FileScopeProvider scopeProvider) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(scopeProvider, "scopeProvider");
        Collection<KtFile> collection = c.getFiles();
        Intrinsics.checkExpressionValueIsNotNull(collection, "c.files");
        Map filesToScope2 = CollectionsKt.keysToMap((Iterable)collection, (Function1)new Function1<KtFile, LexicalScope>(scopeProvider){
            final /* synthetic */ FileScopeProvider $scopeProvider;

            @NotNull
            public final LexicalScope invoke(KtFile it) {
                KtFile ktFile = it;
                Intrinsics.checkExpressionValueIsNotNull(ktFile, "it");
                return this.$scopeProvider.getFileResolutionScope(ktFile);
            }
            {
                this.$scopeProvider = fileScopeProvider;
                super(1);
            }
        });
        Object object = filesToScope2;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void file2;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl2 = false;
            object = (KtFile)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            LexicalScope fileScope = (LexicalScope)entry2.getValue();
            void v1 = file2;
            Intrinsics.checkExpressionValueIsNotNull(v1, "file");
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, v1.getAnnotationEntries(), this.trace);
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file2.getDanglingAnnotations(), this.trace);
        }
    }

    public final void checkRedeclarations(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        for (ClassDescriptorWithResolutionScopes classDescriptor2 : c.getDeclaredClasses().values()) {
            HashMultimap descriptorMap = HashMultimap.create();
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptorWithResolutionScopes, "classDescriptor");
            for (DeclarationDescriptor desc : ResolutionScope.DefaultImpls.getContributedDescriptors$default(classDescriptorWithResolutionScopes.getUnsubstitutedMemberScope(), null, null, 3, null)) {
                if (!(desc instanceof ClassifierDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put(desc.getName(), desc);
            }
            HashMultimap hashMultimap = descriptorMap;
            Intrinsics.checkExpressionValueIsNotNull(hashMultimap, "descriptorMap");
            this.reportRedeclarationsWithClassifiers(hashMultimap);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportRedeclarationsWithClassifiers(Multimap<Name, DeclarationDescriptor> descriptorMap) {
        for (Name name : descriptorMap.keySet()) {
            boolean bl;
            Collection<DeclarationDescriptor> descriptors;
            block5: {
                descriptors = descriptorMap.get(name);
                if (descriptors.size() <= 1) continue;
                Collection<DeclarationDescriptor> collection = descriptors;
                Intrinsics.checkExpressionValueIsNotNull(collection, "descriptors");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof ClassifierDescriptor)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            for (DeclarationDescriptor descriptor2 : descriptors) {
                void it;
                void trace$iv;
                PsiElement psiElement;
                DeclarationDescriptor descriptor$iv;
                BindingTrace bindingTrace = this.trace;
                Intrinsics.checkExpressionValueIsNotNull(descriptor2, "descriptor");
                boolean $i$f$reportOnDeclaration = false;
                if (DescriptorToSourceUtils.descriptorToDeclaration(descriptor$iv) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                PsiElement psiElement$iv = psiElement;
                boolean bl5 = false;
                PsiElement psiElement2 = psiElement$iv;
                void var17_20 = trace$iv;
                boolean bl6 = false;
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.REDECLARATION.on((PsiElement)it, descriptors);
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "REDECLARATION.on(it, descriptors)");
                Diagnostic diagnostic = parametrizedDiagnostic;
                var17_20.report(diagnostic);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkRedeclarationsInPackages(@NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull Multimap<FqName, KtElement> topLevelFqNames) {
        Intrinsics.checkParameterIsNotNull(topLevelDescriptorProvider, "topLevelDescriptorProvider");
        Intrinsics.checkParameterIsNotNull(topLevelFqNames, "topLevelFqNames");
        Map<FqName, Collection<KtElement>> map2 = topLevelFqNames.asMap();
        Intrinsics.checkExpressionValueIsNotNull(map2, "topLevelFqNames.asMap()");
        Object object = map2;
        boolean bl = false;
        for (Map.Entry<FqName, Collection<KtElement>> entry : object.entrySet()) {
            void expected;
            void fqName2;
            Object object2 = entry;
            boolean bl2 = false;
            object = object2.getKey();
            object2 = entry;
            bl2 = false;
            Collection<KtElement> declarationsOrPackageDirectives = object2.getValue();
            void v1 = fqName2;
            Intrinsics.checkExpressionValueIsNotNull(v1, "fqName");
            if (v1.isRoot()) continue;
            Iterable $this$partition$iv = this.getTopLevelDescriptorsByFqName(topLevelDescriptorProvider, (FqName)fqName2, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                boolean bl3 = false;
                if (it instanceof MemberDescriptor && ((MemberDescriptor)it).isExpect()) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            object2 = pair.component1();
            List actual = pair.component2();
            for (List descriptors : kotlin.collections.CollectionsKt.listOf(expected, actual)) {
                if (descriptors.size() <= 1) continue;
                for (KtElement directive : declarationsOrPackageDirectives) {
                    PsiElement psiElement;
                    KtElement ktElement = directive;
                    if (!(ktElement instanceof KtPackageDirective)) {
                        ktElement = null;
                    }
                    if ((psiElement = (KtPackageDirective)ktElement) == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                        psiElement = directive;
                    }
                    PsiElement reportAt = psiElement;
                    this.trace.report(Errors.PACKAGE_OR_CLASSIFIER_REDECLARATION.on(reportAt, fqName2.shortName().asString()));
                }
            }
        }
    }

    private final Set<DeclarationDescriptor> getTopLevelDescriptorsByFqName(TopLevelDescriptorProvider topLevelDescriptorProvider, FqName fqName2, LookupLocation location2) {
        HashSet<ClassifierDescriptor> descriptors = new HashSet<ClassifierDescriptor>();
        CollectionsKt.addIfNotNull((Collection)descriptors, topLevelDescriptorProvider.getPackageFragment(fqName2));
        descriptors.addAll(topLevelDescriptorProvider.getTopLevelClassifierDescriptors(fqName2, location2));
        return descriptors;
    }

    public DeclarationResolver(@NotNull AnnotationResolver annotationResolver, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.annotationResolver = annotationResolver;
        this.trace = trace;
    }
}

